/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.dialog;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.serenegiant.common.R;
import com.serenegiant.widget.ColorPickerView;

@Deprecated
@TargetApi(value=17)
public class ColorPickerDialog
extends DialogFragment {
    private static final boolean DEBUG = false;
    private static final String TAG = "ColorPickerDialog";
    private static final String KEY_TITLE_ID = "title_id";
    private static final String KEY_COLOR_INIT = "initial_color";
    private static final String KEY_COLOR_CURRENT = "current_color";
    private static final int DEFAULT_COLOR = -1;
    private OnColorChangedListener mListener;
    private int mTitleResId;
    private int mInitialColor = -1;
    private int mCurrentColor = -1;
    private boolean isCanceled;
    private final ColorPickerView.ColorPickerListener mColorPickerListener = new ColorPickerView.ColorPickerListener(){

        @Override
        public void onColorChanged(ColorPickerView view, int color) {
            if (ColorPickerDialog.this.mCurrentColor != color) {
                ColorPickerDialog.this.mCurrentColor = color;
                if (ColorPickerDialog.this.mListener != null) {
                    ColorPickerDialog.this.mListener.onColorChanged(ColorPickerDialog.this, color);
                }
            }
        }
    };
    private final DialogInterface.OnClickListener mOnClickListner = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            switch (which) {
                case -1: {
                    dialog.dismiss();
                    break;
                }
                case -2: {
                    dialog.cancel();
                }
            }
        }
    };

    public static ColorPickerDialog show(Activity parent, int titleResId, int initialColor) {
        ColorPickerDialog dialog = ColorPickerDialog.newInstance(titleResId, initialColor);
        dialog.show(parent.getFragmentManager(), TAG);
        return dialog;
    }

    public static ColorPickerDialog show(Fragment parent, int titleResId, int initialColor) {
        ColorPickerDialog dialog = ColorPickerDialog.newInstance(titleResId, initialColor);
        dialog.setTargetFragment(parent, 0);
        dialog.show(parent.getFragmentManager(), TAG);
        return dialog;
    }

    public static ColorPickerDialog newInstance(int titleResId, int initialColor) {
        ColorPickerDialog dialog = new ColorPickerDialog();
        dialog.setArguments(titleResId, initialColor);
        return dialog;
    }

    public void setArguments(int titleResId, int initialColor) {
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_TITLE_ID, titleResId);
        bundle.putInt(KEY_COLOR_INIT, initialColor);
        bundle.remove(KEY_COLOR_CURRENT);
        this.setArguments(bundle);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null) {
            this.mTitleResId = args.getInt(KEY_TITLE_ID);
            this.mCurrentColor = this.mInitialColor = args.getInt(KEY_COLOR_INIT, -1);
        }
        if (savedInstanceState != null) {
            this.mCurrentColor = savedInstanceState.getInt(KEY_COLOR_CURRENT, this.mInitialColor);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putInt(KEY_COLOR_CURRENT, this.mCurrentColor);
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.isCanceled = false;
        try {
            this.mListener = (OnColorChangedListener)this.getTargetFragment();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.mListener == null) {
            try {
                this.mListener = (OnColorChangedListener)this.getParentFragment();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.mListener == null) {
            try {
                this.mListener = (OnColorChangedListener)activity;
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.mListener == null) {
            Log.w((String)TAG, (String)"must implement OnColorChangedListener");
        }
    }

    @SuppressLint(value={"InflateParams"})
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Activity activity = this.getActivity();
        FrameLayout rootView = (FrameLayout)LayoutInflater.from((Context)activity).inflate(R.layout.color_picker, null);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        ColorPickerView view = new ColorPickerView((Context)this.getActivity());
        view.setColor(this.mCurrentColor);
        view.setColorPickerListener(this.mColorPickerListener);
        rootView.addView((View)view, (ViewGroup.LayoutParams)params);
        AlertDialog dialog = new AlertDialog.Builder((Context)activity).setPositiveButton(R.string.color_picker_select, this.mOnClickListner).setNegativeButton(R.string.color_picker_cancel, this.mOnClickListner).setTitle(this.mTitleResId != 0 ? this.mTitleResId : R.string.color_picker_default_title).setView((View)rootView).create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
        this.isCanceled = true;
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.mListener != null) {
            if (this.isCanceled) {
                this.mListener.onCancel(this);
            } else {
                this.mListener.onDismiss(this, this.mCurrentColor);
            }
        }
    }

    public static interface OnColorChangedListener {
        public void onColorChanged(ColorPickerDialog var1, int var2);

        public void onCancel(ColorPickerDialog var1);

        public void onDismiss(ColorPickerDialog var1, int var2);
    }
}

