/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.uac;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.jiangdg.uac.UACAudio;
import com.jiangdg.uac.UACAudioCallBack;
import com.jiangdg.usb.USBMonitor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class UACAudioHandler
extends Handler {
    private static final String TAG = "UACAudioHandler";
    private static final int MSG_INIT = 0;
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    private static final int MSG_RELEASE = 3;
    private volatile boolean mIsReleased;
    private final WeakReference<AudioThread> mThreadWf;

    public static UACAudioHandler createHandler(USBMonitor.UsbControlBlock ctrlBlock) {
        AudioThread audioThread = new AudioThread(UACAudioHandler.class, ctrlBlock);
        audioThread.start();
        return audioThread.getHandler();
    }

    private UACAudioHandler(AudioThread thread) {
        this.mThreadWf = new WeakReference<AudioThread>(thread);
    }

    public void initAudioRecord() {
        this.checkReleased();
        this.obtainMessage(0).sendToTarget();
    }

    public void startRecording() {
        this.checkReleased();
        this.obtainMessage(1).sendToTarget();
    }

    public void stopRecording() {
        this.checkReleased();
        this.obtainMessage(2).sendToTarget();
    }

    public void releaseAudioRecord() {
        this.checkReleased();
        this.obtainMessage(3).sendToTarget();
    }

    public boolean isRecording() {
        AudioThread thread = (AudioThread)this.mThreadWf.get();
        if (thread == null || this.isReleased()) {
            return false;
        }
        return thread.isRecording();
    }

    public UACAudio.AudioStatus getAudioStatus() {
        AudioThread thread = (AudioThread)this.mThreadWf.get();
        if (this.isReleased()) {
            return UACAudio.AudioStatus.ERROR;
        }
        return thread.getAudioStatus();
    }

    public int getSampleRate() {
        AudioThread thread = (AudioThread)this.mThreadWf.get();
        if (this.isReleased()) {
            return -1;
        }
        return thread.getSampleRate();
    }

    public int getBitResolution() {
        AudioThread thread = (AudioThread)this.mThreadWf.get();
        if (this.isReleased()) {
            return -1;
        }
        return thread.getBitResolution();
    }

    public int getChannelCount() {
        AudioThread thread = (AudioThread)this.mThreadWf.get();
        if (this.isReleased()) {
            return -1;
        }
        return thread.getChannelCount();
    }

    public void addDataCallBack(UACAudioCallBack callBack) {
        AudioThread thread = (AudioThread)this.mThreadWf.get();
        if (callBack == null || this.isReleased()) {
            return;
        }
        if (thread.mCallBackList.contains(callBack)) {
            return;
        }
        thread.mCallBackList.add(callBack);
    }

    public void removeDataCallBack(UACAudioCallBack callBack) {
        AudioThread thread = (AudioThread)this.mThreadWf.get();
        if (callBack == null || this.isReleased()) {
            return;
        }
        if (!thread.mCallBackList.contains(callBack)) {
            return;
        }
        thread.mCallBackList.remove(callBack);
    }

    public void handleMessage(Message msg) {
        AudioThread thread = (AudioThread)this.mThreadWf.get();
        if (thread == null) {
            Log.w((String)TAG, (String)"handleMessage: err, thread is null");
            return;
        }
        switch (msg.what) {
            case 0: {
                thread.handleInitAudioRecord();
                break;
            }
            case 1: {
                thread.handleStartRecording();
                break;
            }
            case 2: {
                thread.handleStopRecording();
                break;
            }
            case 3: {
                thread.handleReleaseAudioRecord();
                break;
            }
        }
    }

    public boolean isReleased() {
        return this.mIsReleased || this.mThreadWf.get() == null;
    }

    private void checkReleased() {
        if (this.isReleased()) {
            throw new IllegalStateException("uac handler already been released");
        }
    }

    public static class AudioThread
    extends Thread {
        private static final String TAG = "AudioThread";
        private static final long TIMES_OUT_MS = 1500L;
        private final Object mSync = new Object();
        private final USBMonitor.UsbControlBlock mCtrlBlock;
        private final Class<UACAudioHandler> mHandlerClass;
        private UACAudioHandler mUACHandler;
        private UACAudio mUACAudio;
        private final Set<UACAudioCallBack> mCallBackList = new CopyOnWriteArraySet<UACAudioCallBack>();

        public AudioThread(Class<UACAudioHandler> handlerClass, USBMonitor.UsbControlBlock ctrlBlock) {
            this.mCtrlBlock = ctrlBlock;
            this.mHandlerClass = handlerClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleInitAudioRecord() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.isRecording()) {
                    return;
                }
                this.mUACAudio = new UACAudio();
                this.mUACAudio.init(this.mCtrlBlock);
                this.mUACAudio.addAudioCallBack(this::callOnDataCallBack);
                this.mSync.notifyAll();
            }
            Log.i((String)TAG, (String)"handleInitAudioRecord");
        }

        public void handleStartRecording() {
            if (this.mUACAudio == null) {
                Log.e((String)TAG, (String)"handleStartRecording failed, you should call initAudioRecord first");
                return;
            }
            this.mUACAudio.startRecording();
            Log.i((String)TAG, (String)"handleStartRecording");
        }

        public void handleStopRecording() {
            if (this.mUACAudio == null) {
                Log.e((String)TAG, (String)"handleStopRecording failed, you should call initAudioRecord first");
                return;
            }
            this.mUACAudio.stopRecording();
            Log.i((String)TAG, (String)"handleStopRecording");
        }

        public void handleReleaseAudioRecord() {
            Looper looper;
            this.handleStopRecording();
            if (this.mUACAudio != null) {
                this.mUACAudio.release();
                this.mUACAudio = null;
            }
            this.mCallBackList.clear();
            if (this.mUACHandler != null) {
                this.mUACHandler.mIsReleased = true;
            }
            if ((looper = Looper.myLooper()) != null) {
                looper.quit();
            }
            Log.i((String)TAG, (String)"handleReleaseAudioRecord");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSampleRate() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mUACAudio == null) {
                    try {
                        this.mSync.wait(1500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return this.mUACAudio != null ? this.mUACAudio.getSampleRate() : -1;
                }
                return this.mUACAudio.getSampleRate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getChannelCount() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mUACAudio == null) {
                    try {
                        this.mSync.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return this.mUACAudio != null ? this.mUACAudio.getChannelCount() : -1;
                }
                return this.mUACAudio.getChannelCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getBitResolution() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mUACAudio == null) {
                    try {
                        this.mSync.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return this.mUACAudio != null ? this.mUACAudio.getBitResolution() : -1;
                }
                return this.mUACAudio.getBitResolution();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UACAudio.AudioStatus getAudioStatus() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mUACAudio == null) {
                    try {
                        this.mSync.wait(1500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return this.mUACAudio != null ? this.mUACAudio.getAudioStatus() : UACAudio.AudioStatus.ERROR;
                }
                return this.mUACAudio.getAudioStatus();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRecording() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mUACAudio == null) {
                    try {
                        this.mSync.wait(1500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return this.mUACAudio != null && this.mUACAudio.isRecording();
                }
                return this.mUACAudio.isRecording();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Log.i((String)TAG, (String)"Audio thread start");
            Looper.prepare();
            UACAudioHandler uacHandler = null;
            try {
                Constructor<UACAudioHandler> constructor = this.mHandlerClass.getDeclaredConstructor(AudioThread.class);
                uacHandler = constructor.newInstance(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("UACAudioHandler new failed, " + e.getMessage()));
            }
            if (uacHandler != null) {
                object = this.mSync;
                synchronized (object) {
                    this.mUACHandler = uacHandler;
                    this.mSync.notifyAll();
                }
                Looper.loop();
                if (this.mUACHandler != null) {
                    this.mUACHandler.mIsReleased = true;
                }
            }
            this.mCallBackList.clear();
            object = this.mSync;
            synchronized (object) {
                this.mUACHandler = null;
                this.mSync.notifyAll();
            }
            Log.i((String)TAG, (String)"Audio thread stop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UACAudioHandler getHandler() {
            Log.i((String)TAG, (String)"getHandler: ");
            Object object = this.mSync;
            synchronized (object) {
                if (this.mUACHandler == null) {
                    try {
                        this.mSync.wait(1500L);
                    }
                    catch (InterruptedException e) {
                        Log.e((String)TAG, (String)("getHandler: failed, " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            }
            return this.mUACHandler;
        }

        private void callOnDataCallBack(byte[] pcm) {
            for (UACAudioCallBack callBack : this.mCallBackList) {
                try {
                    callBack.pcmData(pcm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

