/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.uac;

import android.text.TextUtils;
import android.util.Log;
import com.jiangdg.uac.UACAudioCallBack;
import com.jiangdg.usb.USBMonitor;

public class UACAudio {
    private static final String TAG = "UACAudio";
    private static final String DEFAULT_USBFS = "/dev/bus/usb";
    public UACAudioCallBack mAudioCallBack;
    private AudioStatus mStatus = AudioStatus.RELEASED;
    private long mNativePtr;

    public void init(USBMonitor.UsbControlBlock ctrlBlock) {
        int result = -1;
        try {
            result = this.nativeInit(ctrlBlock.getVenderId(), ctrlBlock.getProductId(), ctrlBlock.getBusNum(), ctrlBlock.getDevNum(), ctrlBlock.getFileDescriptor(), this.getUSBFSName(ctrlBlock));
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("initAudio: err = " + e.getMessage()));
        }
        this.mStatus = result < 0 ? AudioStatus.ERROR : AudioStatus.CREATED;
        Log.i((String)TAG, (String)("initAudio: " + result + ", mNativePtr = " + this.mNativePtr));
    }

    public void startRecording() {
        if (this.mStatus == AudioStatus.RELEASED) {
            Log.e((String)TAG, (String)"startRecording failed: init status error");
            return;
        }
        if (this.nativeStartRecord(this.mNativePtr) < 0) {
            Log.e((String)TAG, (String)"startRecording: start failed");
            this.mStatus = AudioStatus.ERROR;
            return;
        }
        this.mStatus = AudioStatus.RUNNING;
        Log.i((String)TAG, (String)"startRecording: success");
    }

    public void stopRecording() {
        if (this.mStatus != AudioStatus.RUNNING) {
            Log.e((String)TAG, (String)"stopRecording: not in running");
            return;
        }
        if (this.nativeStopRecord(this.mNativePtr) < 0) {
            Log.e((String)TAG, (String)"stopRecording: stop failed.");
            return;
        }
        this.mStatus = AudioStatus.STOPPED;
        Log.i((String)TAG, (String)"stopRecording: success");
    }

    public void release() {
        this.nativeRelease(this.mNativePtr);
        this.mStatus = AudioStatus.RELEASED;
        Log.i((String)TAG, (String)"release: success");
    }

    public int getSampleRate() {
        return this.nativeGetSampleRate(this.mNativePtr);
    }

    public int getChannelCount() {
        return this.nativeGetChannelCount(this.mNativePtr);
    }

    public int getBitResolution() {
        return this.nativeGetBitResolution(this.mNativePtr);
    }

    public AudioStatus getAudioStatus() {
        return this.mStatus;
    }

    public boolean isRecording() {
        return this.nativeGetRecordingState(this.mNativePtr);
    }

    public void addAudioCallBack(UACAudioCallBack callBack) {
        this.mAudioCallBack = callBack;
    }

    public void pcmData(byte[] data) {
        if (this.mAudioCallBack != null) {
            this.mAudioCallBack.pcmData(data);
        }
    }

    private String getUSBFSName(USBMonitor.UsbControlBlock ctrlBlock) {
        String[] v;
        String result = null;
        String name = ctrlBlock.getDeviceName();
        String[] stringArray = v = !TextUtils.isEmpty((CharSequence)name) ? name.split("/") : null;
        if (v != null && v.length > 2) {
            StringBuilder sb = new StringBuilder(v[0]);
            for (int i = 1; i < v.length - 2; ++i) {
                sb.append("/").append(v[i]);
            }
            result = sb.toString();
        }
        if (TextUtils.isEmpty(result)) {
            Log.w((String)TAG, (String)("failed to get USBFS path, try to use default path:" + name));
            result = DEFAULT_USBFS;
        }
        return result;
    }

    private native int nativeInit(int var1, int var2, int var3, int var4, int var5, String var6);

    private native void nativeRelease(long var1);

    private native int nativeStartRecord(long var1);

    private native int nativeStopRecord(long var1);

    private native boolean nativeGetRecordingState(long var1);

    private native int nativeGetSampleRate(long var1);

    private native int nativeGetChannelCount(long var1);

    private native int nativeGetBitResolution(long var1);

    static {
        System.loadLibrary(TAG);
    }

    public static enum AudioStatus {
        CREATED,
        RUNNING,
        STOPPED,
        RELEASED,
        ERROR;

    }
}

