/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.utils;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import androidx.annotation.ChecksSdkIntAtLeast;
import com.jiangdg.ausbc.utils.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0007J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jiangdg/ausbc/utils/MediaUtils;", "", "()V", "TAG", "", "findRecentMedia", "context", "Landroid/content/Context;", "isImage", "", "isAboveQ", "readRawTextFile", "rawId", "", "saveYuv2Jpeg", "path", "data", "", "width", "height", "transferByte2Short", "", "readBytes", "libausbc_release"})
public final class MediaUtils {
    @NotNull
    public static final MediaUtils INSTANCE = new MediaUtils();
    @NotNull
    private static final String TAG = "MediaUtils";

    private MediaUtils() {
    }

    @NotNull
    public final String readRawTextFile(@NotNull Context context, int rawId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        InputStream inputStream = context.getResources().openRawResource(rawId);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.resources.openRawResource(rawId)");
        InputStream inputStream2 = inputStream;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream2));
        String line = null;
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                string = br.readLine();
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                line = it;
                if (string != null) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.INSTANCE.e(TAG, "open raw file failed!", e);
        }
        try {
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.INSTANCE.e(TAG, "close raw file failed!", e);
        }
        string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @Nullable
    public final String findRecentMedia(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String imagePath = this.findRecentMedia(context, true);
        String videoPath = this.findRecentMedia(context, false);
        if (imagePath == null) {
            return videoPath;
        }
        if (videoPath == null) {
            return imagePath;
        }
        File imageFile = new File(imagePath);
        File videoFile = new File(videoPath);
        if (imageFile.lastModified() >= videoFile.lastModified()) {
            return imagePath;
        }
        return videoPath;
    }

    @Nullable
    public final String findRecentMedia(@NotNull Context context, boolean isImage) {
        boolean bl;
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] uri = null;
        String sortOrder = null;
        String columnName = null;
        if (isImage) {
            columnName = "_data";
            sortOrder = "_id DESC";
            stringArray3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"EXTERNAL_CONTENT_URI");
            uri = stringArray3;
            stringArray3 = new String[]{"_data", "date_added", "_size", "mime_type", "width", "height"};
            stringArray2 = stringArray3;
        } else {
            columnName = "_data";
            sortOrder = "_id DESC";
            stringArray3 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"EXTERNAL_CONTENT_URI");
            uri = stringArray3;
            stringArray3 = new String[]{"_data", "_display_name", "date_added", "_size", "mime_type", "duration", "width", "height"};
            stringArray2 = stringArray3;
        }
        String[] projection = stringArray2;
        stringArray3 = context.getContentResolver().query((Uri)uri, projection, null, null, sortOrder);
        if (stringArray3 == null) {
            stringArray = null;
        } else {
            String[] stringArray4 = stringArray3;
            bl = false;
            boolean bl2 = false;
            String[] $this$findRecentMedia_u24lambda_u2d1 = stringArray4;
            boolean bl3 = false;
            if ($this$findRecentMedia_u24lambda_u2d1.getCount() < 1) {
                $this$findRecentMedia_u24lambda_u2d1.close();
                return null;
            }
            while ($this$findRecentMedia_u24lambda_u2d1.moveToNext()) {
                String data = $this$findRecentMedia_u24lambda_u2d1.getString($this$findRecentMedia_u24lambda_u2d1.getColumnIndexOrThrow(columnName));
                File file = new File(data);
                if (!file.exists()) continue;
                $this$findRecentMedia_u24lambda_u2d1.close();
                return file.getPath();
            }
            stringArray = stringArray4;
        }
        stringArray3 = stringArray;
        boolean bl4 = false;
        bl = false;
        String[] it = stringArray3;
        boolean bl5 = false;
        String[] stringArray5 = it;
        if (stringArray5 != null) {
            stringArray5.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean saveYuv2Jpeg(@NotNull String path, @NotNull byte[] data, int width, int height) {
        boolean e2;
        YuvImage yuvImage;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            yuvImage = new YuvImage(data, 17, width, height, null);
        }
        catch (Exception e2) {
            Logger.INSTANCE.e(TAG, "create YuvImage failed.", e2);
            yuvImage = null;
        }
        YuvImage yuvImage2 = yuvImage;
        if (yuvImage2 == null) {
            return false;
        }
        YuvImage yuvImage3 = yuvImage2;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        try {
            e2 = yuvImage3.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)bos);
        }
        catch (Exception e3) {
            Logger.INSTANCE.e(TAG, "compressToJpeg failed.", e3);
            e2 = false;
        }
        boolean result = e2;
        if (!result) {
            return false;
        }
        byte[] buffer = bos.toByteArray();
        File file = new File(path);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(buffer);
            fos.close();
        }
        catch (IOException e4) {
            Logger.INSTANCE.e(TAG, "saveYuv2Jpeg failed.", e4);
            result = false;
            e4.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e5) {
                result = false;
                Logger.INSTANCE.e(TAG, "saveYuv2Jpeg failed.", e5);
                e5.printStackTrace();
            }
        }
        return result;
    }

    @NotNull
    public final short[] transferByte2Short(@NotNull byte[] data, int readBytes) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int shortLen = readBytes / 2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, readBytes);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(data, 0, readBytes)");
        ByteBuffer byteBuffer2 = byteBuffer;
        ShortBuffer shortBuffer = byteBuffer2.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)shortBuffer, (String)"byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer()");
        ShortBuffer shortBuffer2 = shortBuffer;
        short[] shortData = new short[shortLen];
        shortBuffer2.get(shortData, 0, shortLen);
        return shortData;
    }

    @ChecksSdkIntAtLeast(api=29)
    public final boolean isAboveQ() {
        return Build.VERSION.SDK_INT >= 29;
    }
}

