/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode.audio;

import com.jiangdg.ausbc.encode.audio.AudioUac;
import com.jiangdg.ausbc.encode.audio.IAudio;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.uac.UACAudioCallBack;
import com.jiangdg.uac.UACAudioHandler;
import com.jiangdg.usb.USBMonitor;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\b\u0010\u001f\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jiangdg/ausbc/encode/audio/AudioUac;", "Lcom/jiangdg/ausbc/encode/audio/IAudio;", "ctrlBlock", "Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;", "(Lcom/jiangdg/usb/USBMonitor$UsbControlBlock;)V", "mCallback", "Lcom/jiangdg/uac/UACAudioCallBack;", "mLatch", "Ljava/util/concurrent/CountDownLatch;", "getMLatch", "()Ljava/util/concurrent/CountDownLatch;", "mLatch$delegate", "Lkotlin/Lazy;", "mPcmDataQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "mUacHandler", "Lcom/jiangdg/uac/UACAudioHandler;", "getAudioFormat", "", "getChannelConfig", "getChannelCount", "getSampleRate", "initAudioRecord", "", "isRecording", "", "read", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "releaseAudioRecord", "startRecording", "stopRecording", "Companion", "libausbc_release"})
public final class AudioUac
implements IAudio {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final USBMonitor.UsbControlBlock ctrlBlock;
    @Nullable
    private UACAudioHandler mUacHandler;
    @NotNull
    private final ConcurrentLinkedQueue<byte[]> mPcmDataQueue;
    @NotNull
    private final Lazy mLatch$delegate;
    @NotNull
    private final UACAudioCallBack mCallback;
    @NotNull
    private static final String TAG = "AudioUac";
    private static final long TIMES_OUT = 1500L;
    private static final int MAX_QUEUE_SIZE = 10;
    private static final int SAMPLE_RATE = 8000;
    private static final int BIT_RESOLUTION = 8;
    private static final int CHANNEL_COUNT = 1;

    public AudioUac(@NotNull USBMonitor.UsbControlBlock ctrlBlock) {
        Intrinsics.checkNotNullParameter((Object)ctrlBlock, (String)"ctrlBlock");
        this.ctrlBlock = ctrlBlock;
        this.mPcmDataQueue = new ConcurrentLinkedQueue();
        this.mLatch$delegate = LazyKt.lazy((Function0)mLatch.2.INSTANCE);
        this.mCallback = arg_0 -> AudioUac.mCallback$lambda-0(this, arg_0);
    }

    private final CountDownLatch getMLatch() {
        Lazy lazy = this.mLatch$delegate;
        boolean bl = false;
        return (CountDownLatch)lazy.getValue();
    }

    @Override
    public void initAudioRecord() {
        this.mUacHandler = UACAudioHandler.createHandler((USBMonitor.UsbControlBlock)this.ctrlBlock);
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.initAudioRecord();
        }
        this.getMLatch().countDown();
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "initAudioRecord");
        }
    }

    @Override
    public void startRecording() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.startRecording();
        }
        uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.addDataCallBack(this.mCallback);
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "startRecording:");
        }
    }

    @Override
    public void stopRecording() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.stopRecording();
        }
        uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.removeDataCallBack(this.mCallback);
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "stopRecording:");
        }
    }

    @Override
    public void releaseAudioRecord() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        if (uACAudioHandler != null) {
            uACAudioHandler.releaseAudioRecord();
        }
        if (Utils.INSTANCE.getDebugCamera()) {
            Logger.INSTANCE.i(TAG, "releaseAudioRecord:");
        }
    }

    @Override
    @Nullable
    public RawData read() {
        RawData rawData;
        byte[] byArray = this.mPcmDataQueue.poll();
        if (byArray == null) {
            rawData = null;
        } else {
            byte[] byArray2 = byArray;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray2;
            boolean bl3 = false;
            rawData = new RawData(it, it.length);
        }
        return rawData;
    }

    @Override
    public boolean isRecording() {
        UACAudioHandler uACAudioHandler = this.mUacHandler;
        return uACAudioHandler == null ? false : uACAudioHandler.isRecording();
    }

    @Override
    public int getSampleRate() {
        int n;
        UACAudioHandler uACAudioHandler;
        if (this.mUacHandler == null) {
            this.getMLatch().await(1500L, TimeUnit.MILLISECONDS);
        }
        return (uACAudioHandler = this.mUacHandler) == null ? 8000 : (n = uACAudioHandler.getSampleRate());
    }

    @Override
    public int getAudioFormat() {
        UACAudioHandler uACAudioHandler;
        if (this.mUacHandler == null) {
            this.getMLatch().await(1500L, TimeUnit.MILLISECONDS);
        }
        return ((uACAudioHandler = this.mUacHandler) == null ? false : uACAudioHandler.getBitResolution() == 8) ? 3 : 2;
    }

    @Override
    public int getChannelCount() {
        int n;
        UACAudioHandler uACAudioHandler;
        if (this.mUacHandler == null) {
            this.getMLatch().await(1500L, TimeUnit.MILLISECONDS);
        }
        return (uACAudioHandler = this.mUacHandler) == null ? 1 : (n = uACAudioHandler.getChannelCount());
    }

    @Override
    public int getChannelConfig() {
        return this.getChannelConfig() == 1 ? 16 : 12;
    }

    private static final void mCallback$lambda-0(AudioUac this$0, byte[] data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.mPcmDataQueue.size() >= 10) {
            this$0.mPcmDataQueue.poll();
        }
        this$0.mPcmDataQueue.offer(data);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jiangdg/ausbc/encode/audio/AudioUac$Companion;", "", "()V", "BIT_RESOLUTION", "", "CHANNEL_COUNT", "MAX_QUEUE_SIZE", "SAMPLE_RATE", "TAG", "", "TIMES_OUT", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

