/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.encode;

import android.media.MediaCodec;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.jiangdg.ausbc.callback.IEncodeDataCallBack;
import com.jiangdg.ausbc.encode.AbstractProcessor;
import com.jiangdg.ausbc.encode.bean.RawData;
import com.jiangdg.ausbc.encode.muxer.Mp4Muxer;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.natives.YUVUtils;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 ?2\u00020\u0001:\u0001?B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\nJ\b\u0010*\u001a\u00020(H\u0004J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0005H$J\b\u0010.\u001a\u00020/H$J\b\u00100\u001a\u00020(H$J\b\u00101\u001a\u00020(H$J\u0006\u00102\u001a\u00020\u0003J\b\u00103\u001a\u00020\u0003H\u0004J\u0018\u00104\u001a\u00020(2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0005H\u0002J\u000e\u00108\u001a\u00020(2\u0006\u00109\u001a\u00020$J\b\u0010:\u001a\u00020(H\u0002J\u0016\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020!2\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010=\u001a\u00020(J\u0006\u0010>\u001a\u00020(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/jiangdg/ausbc/encode/AbstractProcessor;", "", "gLESRender", "", "width", "", "height", "(ZII)V", "isVideo", "mEncodeDataCb", "Lcom/jiangdg/ausbc/callback/IEncodeDataCallBack;", "mEncodeHandler", "Landroid/os/Handler;", "mEncodeState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMEncodeState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mEncodeState$delegate", "Lkotlin/Lazy;", "mEncodeThread", "Landroid/os/HandlerThread;", "mMainHandler", "getMMainHandler", "()Landroid/os/Handler;", "setMMainHandler", "(Landroid/os/Handler;)V", "mMediaCodec", "Landroid/media/MediaCodec;", "getMMediaCodec", "()Landroid/media/MediaCodec;", "setMMediaCodec", "(Landroid/media/MediaCodec;)V", "mMp4Muxer", "Lcom/jiangdg/ausbc/encode/muxer/Mp4Muxer;", "mRawDataQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/jiangdg/ausbc/encode/bean/RawData;", "getMRawDataQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "addEncodeDataCallBack", "", "callBack", "doEncodeData", "getPTSUs", "", "bufferSize", "getThreadName", "", "handleStartEncode", "handleStopEncode", "isEncoding", "isLowerLollipop", "logSpecialFrame", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "length", "putRawData", "data", "queueFrameIfNeed", "setMp4Muxer", "muxer", "startEncode", "stopEncode", "Companion", "libausbc_release"})
public abstract class AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean gLESRender;
    private final int width;
    private final int height;
    @Nullable
    private HandlerThread mEncodeThread;
    @Nullable
    private Handler mEncodeHandler;
    @Nullable
    private MediaCodec mMediaCodec;
    @Nullable
    private Mp4Muxer mMp4Muxer;
    private boolean isVideo;
    @Nullable
    private IEncodeDataCallBack mEncodeDataCb;
    @NotNull
    private final ConcurrentLinkedQueue<RawData> mRawDataQueue;
    @NotNull
    private Handler mMainHandler;
    @NotNull
    private final Lazy mEncodeState$delegate;
    @NotNull
    private static final String TAG = "AbstractProcessor";
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    private static final long TIMES_OUT_US = 10000L;
    public static final int MAX_QUEUE_SIZE = 10;

    public AbstractProcessor(boolean gLESRender, int width, int height) {
        this.gLESRender = gLESRender;
        this.width = width;
        this.height = height;
        this.mRawDataQueue = new ConcurrentLinkedQueue();
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mEncodeState$delegate = LazyKt.lazy((Function0)mEncodeState.2.INSTANCE);
    }

    public /* synthetic */ AbstractProcessor(boolean bl, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            bl = false;
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(bl, n, n2);
    }

    @Nullable
    protected final MediaCodec getMMediaCodec() {
        return this.mMediaCodec;
    }

    protected final void setMMediaCodec(@Nullable MediaCodec mediaCodec) {
        this.mMediaCodec = mediaCodec;
    }

    @NotNull
    protected final ConcurrentLinkedQueue<RawData> getMRawDataQueue() {
        return this.mRawDataQueue;
    }

    @NotNull
    protected final Handler getMMainHandler() {
        return this.mMainHandler;
    }

    protected final void setMMainHandler(@NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"<set-?>");
        this.mMainHandler = handler;
    }

    @NotNull
    protected final AtomicBoolean getMEncodeState() {
        Lazy lazy = this.mEncodeState$delegate;
        boolean bl = false;
        return (AtomicBoolean)lazy.getValue();
    }

    public final void startEncode() {
        Message message;
        this.mEncodeThread = new HandlerThread(this.getThreadName());
        HandlerThread handlerThread = this.mEncodeThread;
        if (handlerThread != null) {
            handlerThread.start();
        }
        HandlerThread handlerThread2 = this.mEncodeThread;
        Intrinsics.checkNotNull((Object)handlerThread2);
        this.mEncodeHandler = new Handler(handlerThread2.getLooper(), arg_0 -> AbstractProcessor.startEncode$lambda-0(this, arg_0));
        handlerThread = this.mEncodeHandler;
        if (handlerThread != null && (message = handlerThread.obtainMessage(1)) != null) {
            message.sendToTarget();
        }
    }

    public final void stopEncode() {
        Message message;
        this.getMEncodeState().set(false);
        Handler handler = this.mEncodeHandler;
        if (handler != null && (message = handler.obtainMessage(2)) != null) {
            message.sendToTarget();
        }
        if ((handler = this.mEncodeThread) != null) {
            handler.quitSafely();
        }
        this.mEncodeThread = null;
        this.mEncodeHandler = null;
        this.mEncodeDataCb = null;
    }

    public final void addEncodeDataCallBack(@Nullable IEncodeDataCallBack callBack) {
        this.mEncodeDataCb = callBack;
    }

    public final synchronized void setMp4Muxer(@NotNull Mp4Muxer muxer, boolean isVideo) {
        Intrinsics.checkNotNullParameter((Object)muxer, (String)"muxer");
        this.mMp4Muxer = muxer;
        this.isVideo = isVideo;
    }

    public final void putRawData(@NotNull RawData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!this.getMEncodeState().get()) {
            return;
        }
        if (this.mRawDataQueue.size() >= 10) {
            this.mRawDataQueue.poll();
        }
        this.mRawDataQueue.offer(data);
    }

    public final boolean isEncoding() {
        return this.getMEncodeState().get();
    }

    @NotNull
    protected abstract String getThreadName();

    protected abstract void handleStartEncode();

    protected abstract void handleStopEncode();

    protected abstract long getPTSUs(int var1);

    protected final boolean isLowerLollipop() {
        return Build.VERSION.SDK_INT < 21;
    }

    protected final void doEncodeData() {
        while (this.getMEncodeState().get()) {
            try {
                this.queueFrameIfNeed();
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                int outputIndex = 0;
                do {
                    ByteBuffer outputBuffer;
                    MediaCodec mediaCodec;
                    if ((mediaCodec = this.mMediaCodec) == null) continue;
                    MediaCodec mediaCodec2 = mediaCodec;
                    boolean bl = false;
                    boolean bl2 = false;
                    MediaCodec codec = mediaCodec2;
                    boolean bl3 = false;
                    outputIndex = codec.dequeueOutputBuffer(bufferInfo, 10000L);
                    int n = outputIndex;
                    if (n == -2) {
                        Mp4Muxer mp4Muxer;
                        if (Utils.INSTANCE.getDebugCamera()) {
                            Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"addTracker is video = ", (Object)this.isVideo));
                        }
                        if ((mp4Muxer = this.mMp4Muxer) == null) continue;
                        MediaCodec mediaCodec3 = this.getMMediaCodec();
                        mp4Muxer.addTracker(mediaCodec3 == null ? null : mediaCodec3.getOutputFormat(), this.isVideo);
                        continue;
                    }
                    if (outputIndex < 0) continue;
                    ByteBuffer byteBuffer = outputBuffer = this.isLowerLollipop() ? codec.getOutputBuffers()[outputIndex] : codec.getOutputBuffer(outputIndex);
                    if (outputBuffer != null) {
                        byte[] encodeData = new byte[bufferInfo.size];
                        outputBuffer.get(encodeData);
                        IEncodeDataCallBack.DataType type = this.isVideo ? IEncodeDataCallBack.DataType.H264 : IEncodeDataCallBack.DataType.AAC;
                        Object object = this.mEncodeDataCb;
                        if (object != null) {
                            object.onEncodeData(encodeData, encodeData.length, type);
                        }
                        object = this.mMp4Muxer;
                        if (object != null) {
                            ((Mp4Muxer)object).pumpStream(outputBuffer, bufferInfo, this.isVideo);
                        }
                        this.logSpecialFrame(bufferInfo, encodeData.length);
                    }
                    codec.releaseOutputBuffer(outputIndex, false);
                } while (outputIndex >= 0);
            }
            catch (Exception e) {
                Logger.INSTANCE.e(TAG, "doEncodeData failed, video = " + this.isVideo + "\uff0c err = " + e.getLocalizedMessage(), e);
            }
        }
    }

    private final void queueFrameIfNeed() {
        MediaCodec mediaCodec = this.mMediaCodec;
        if (mediaCodec != null) {
            RawData rawData;
            MediaCodec mediaCodec2 = mediaCodec;
            boolean bl = false;
            boolean bl2 = false;
            MediaCodec codec = mediaCodec2;
            boolean bl3 = false;
            if (!(this.getMRawDataQueue().isEmpty() || this.gLESRender && this.isVideo || (rawData = this.getMRawDataQueue().poll()) == null)) {
                RawData rawData2 = rawData;
                int inputIndex = codec.dequeueInputBuffer(10000L);
                if (inputIndex >= 0) {
                    ByteBuffer byteBuffer;
                    ByteBuffer inputBuffer = this.isLowerLollipop() ? codec.getInputBuffers()[inputIndex] : codec.getInputBuffer(inputIndex);
                    byte[] data = rawData2.getData();
                    if (this.isVideo) {
                        byte[] yuv420sp = new byte[rawData2.getSize()];
                        System.arraycopy(rawData2.getData(), 0, yuv420sp, 0, rawData2.getSize());
                        YUVUtils.INSTANCE.nv21ToYuv420sp(yuv420sp, this.width, this.height);
                        data = yuv420sp;
                    }
                    if ((byteBuffer = inputBuffer) != null) {
                        byteBuffer.clear();
                    }
                    byteBuffer = inputBuffer;
                    if (byteBuffer != null) {
                        byteBuffer.put(data);
                    }
                    codec.queueInputBuffer(inputIndex, 0, data.length, this.getPTSUs(data.length), 0);
                    if (Utils.INSTANCE.getDebugCamera()) {
                        Logger.INSTANCE.i(TAG, "queue mediacodec data, isVideo=" + this.isVideo + ", len=" + data.length);
                    }
                }
            }
        }
    }

    private final void logSpecialFrame(MediaCodec.BufferInfo bufferInfo, int length) {
        if (length == 0 || !this.isVideo) {
            return;
        }
        if (bufferInfo.flags == 1) {
            Logger.INSTANCE.i(TAG, "isVideo = " + this.isVideo + ", Key frame, len = " + length);
        } else if (bufferInfo.flags == 2) {
            Logger.INSTANCE.i(TAG, "isVideo = " + this.isVideo + ", Pps/sps frame, len = " + length);
        }
    }

    private static final boolean startEncode$lambda-0(AbstractProcessor this$0, Message msg) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = msg.what;
        switch (n) {
            case 1: {
                this$0.handleStartEncode();
                break;
            }
            case 2: {
                this$0.handleStopEncode();
            }
        }
        return true;
    }

    public AbstractProcessor() {
        this(false, 0, 0, 7, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jiangdg/ausbc/encode/AbstractProcessor$Companion;", "", "()V", "MAX_QUEUE_SIZE", "", "MSG_START", "MSG_STOP", "TAG", "", "TIMES_OUT_US", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

