/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.render;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.location.Location;
import android.location.LocationManager;
import android.opengl.EGLContext;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.provider.MediaStore;
import android.view.Surface;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.render.RenderManager;
import com.jiangdg.ausbc.render.effect.AbstractEffect;
import com.jiangdg.ausbc.render.env.RotateType;
import com.jiangdg.ausbc.render.internal.AbstractFboRender;
import com.jiangdg.ausbc.render.internal.AbstractRender;
import com.jiangdg.ausbc.render.internal.CameraRender;
import com.jiangdg.ausbc.render.internal.CaptureRender;
import com.jiangdg.ausbc.render.internal.EncodeRender;
import com.jiangdg.ausbc.render.internal.ScreenRender;
import com.jiangdg.ausbc.utils.GLBitmapUtils;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.Utils;
import com.jiangdg.ausbc.utils.bus.EventBus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 m2\u00020\u00012\u00020\u0002:\u0002lmB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010?\u001a\u00020@2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010A\u001a\u00020@2\b\u0010B\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010C\u001a\u00020@2\u0006\u0010D\u001a\u00020\u0006H\u0002J\u0018\u0010E\u001a\u00020@2\u0006\u0010F\u001a\u00020\u00062\u0006\u0010G\u001a\u00020*H\u0002J\b\u0010H\u001a\u00020@H\u0002J\u0016\u0010I\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fJ\n\u0010J\u001a\u0004\u0018\u00010KH\u0002J\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0016J\u0012\u0010P\u001a\u00020@2\b\u0010Q\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010R\u001a\u00020@2\b\u0010B\u001a\u0004\u0018\u00010\u000bJ\u001a\u0010S\u001a\u00020@2\b\u0010T\u001a\u0004\u0018\u00010\u00182\b\u0010U\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010V\u001a\u00020@2\b\u0010W\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010X\u001a\u00020@2\u0006\u0010Y\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020\u0006J\u0010\u0010[\u001a\u00020@2\b\u0010\\\u001a\u0004\u0018\u00010]J\u001e\u0010^\u001a\u00020@2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020\u00062\u0006\u0010b\u001a\u00020\u0006J \u0010c\u001a\u00020@2\u0006\u0010d\u001a\u00020`2\u0006\u0010Y\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020\u0006H\u0002J,\u0010e\u001a\u00020@2\u0006\u0010Y\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020\u00062\b\u0010f\u001a\u0004\u0018\u00010`2\n\b\u0002\u0010g\u001a\u0004\u0018\u00010hJ\u0006\u0010i\u001a\u00020@J\b\u0010j\u001a\u00020@H\u0002J\u0006\u0010k\u001a\u00020@R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0012\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010 \u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u0012\u001a\u0004\b#\u0010$R\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010.\u001a\u00020/8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u0012\u001a\u0004\b0\u00101R\u0010\u00103\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u0004\u0018\u000105X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "Landroid/os/Handler$Callback;", "context", "Landroid/content/Context;", "previewWidth", "", "previewHeight", "(Landroid/content/Context;II)V", "mCacheEffectList", "Ljava/util/ArrayList;", "Lcom/jiangdg/ausbc/render/effect/AbstractEffect;", "Lkotlin/collections/ArrayList;", "mCameraDir", "", "getMCameraDir", "()Ljava/lang/String;", "mCameraDir$delegate", "Lkotlin/Lazy;", "mCameraRender", "Lcom/jiangdg/ausbc/render/internal/CameraRender;", "mCameraSurfaceTexture", "Landroid/graphics/SurfaceTexture;", "mCaptureDataCb", "Lcom/jiangdg/ausbc/callback/ICaptureCallBack;", "mCaptureRender", "Lcom/jiangdg/ausbc/render/internal/CaptureRender;", "mCaptureState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getMCaptureState", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "mCaptureState$delegate", "mContext", "mDateFormat", "Ljava/text/SimpleDateFormat;", "getMDateFormat", "()Ljava/text/SimpleDateFormat;", "mDateFormat$delegate", "mEffectList", "mEncodeRender", "Lcom/jiangdg/ausbc/render/internal/EncodeRender;", "mEndTime", "", "mFBOId", "mFrameRate", "mHeight", "mMainHandler", "Landroid/os/Handler;", "getMMainHandler", "()Landroid/os/Handler;", "mMainHandler$delegate", "mRenderCodecHandler", "mRenderCodecThread", "Landroid/os/HandlerThread;", "mRenderHandler", "mRenderThread", "mScreenRender", "Lcom/jiangdg/ausbc/render/internal/ScreenRender;", "mStartTime", "mTextureId", "mTransformMatrix", "", "mWidth", "addLifecycleObserver", "", "addRenderEffect", "effect", "drawFrame2Capture", "fboId", "drawFrame2Codec", "textureId", "timeStamps", "emitFrameRate", "getCacheEffectList", "getGpsLocation", "Landroid/location/Location;", "handleMessage", "", "msg", "Landroid/os/Message;", "onFrameAvailable", "surfaceTexture", "removeRenderEffect", "saveImage", "callBack", "path", "saveImageInternal", "savePath", "setRenderSize", "w", "h", "setRotateType", "type", "Lcom/jiangdg/ausbc/render/env/RotateType;", "startRenderCodec", "inputSurface", "Landroid/view/Surface;", "width", "height", "startRenderCodecInternal", "surface", "startRenderScreen", "outSurface", "listener", "Lcom/jiangdg/ausbc/render/RenderManager$CameraSurfaceTextureListener;", "stopRenderCodec", "stopRenderCodecInternal", "stopRenderScreen", "CameraSurfaceTextureListener", "Companion", "libausbc_release"})
public final class RenderManager
implements SurfaceTexture.OnFrameAvailableListener,
Handler.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int previewWidth;
    private final int previewHeight;
    private int mTextureId;
    @Nullable
    private HandlerThread mRenderThread;
    @Nullable
    private Handler mRenderHandler;
    @Nullable
    private HandlerThread mRenderCodecThread;
    @Nullable
    private Handler mRenderCodecHandler;
    @Nullable
    private CameraRender mCameraRender;
    @Nullable
    private ScreenRender mScreenRender;
    @Nullable
    private EncodeRender mEncodeRender;
    @Nullable
    private CaptureRender mCaptureRender;
    @Nullable
    private SurfaceTexture mCameraSurfaceTexture;
    @NotNull
    private float[] mTransformMatrix;
    private int mWidth;
    private int mHeight;
    private int mFBOId;
    @NotNull
    private Context mContext;
    @NotNull
    private ArrayList<AbstractEffect> mEffectList;
    @NotNull
    private ArrayList<AbstractEffect> mCacheEffectList;
    @Nullable
    private ICaptureCallBack mCaptureDataCb;
    private int mFrameRate;
    private long mEndTime;
    private long mStartTime;
    @NotNull
    private final Lazy mMainHandler$delegate;
    @NotNull
    private final Lazy mCaptureState$delegate;
    @NotNull
    private final Lazy mDateFormat$delegate;
    @NotNull
    private final Lazy mCameraDir$delegate;
    @NotNull
    private static final String TAG = "RenderManager";
    @NotNull
    private static final String RENDER_THREAD = "gl_render";
    @NotNull
    private static final String RENDER_CODEC_THREAD = "gl_render_codec";
    private static final int MSG_GL_INIT = 0;
    private static final int MSG_GL_DRAW = 1;
    private static final int MSG_GL_RELEASE = 2;
    private static final int MSG_GL_START_RENDER_CODEC = 3;
    private static final int MSG_GL_STOP_RENDER_CODEC = 4;
    private static final int MSG_GL_CHANGED_SIZE = 5;
    private static final int MSG_GL_ADD_EFFECT = 6;
    private static final int MSG_GL_REMOVE_EFFECT = 7;
    private static final int MSG_GL_SAVE_IMAGE = 8;
    private static final int MSG_GL_ROUTE_ANGLE = 9;
    private static final int MSG_GL_RENDER_CODEC_INIT = 17;
    private static final int MSG_GL_RENDER_CODEC_CHANGED_SIZE = 18;
    private static final int MSG_GL_RENDER_CODEC_DRAW = 19;
    private static final int MSG_GL_RENDER_CODEC_RELEASE = 20;

    public RenderManager(@NotNull Context context, int previewWidth, int previewHeight) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.previewWidth = previewWidth;
        this.previewHeight = previewHeight;
        this.mTransformMatrix = new float[16];
        this.mContext = context;
        boolean bl = false;
        this.mEffectList = new ArrayList();
        bl = false;
        this.mCacheEffectList = new ArrayList();
        this.mStartTime = System.currentTimeMillis();
        this.mMainHandler$delegate = LazyKt.lazy((Function0)mMainHandler.2.INSTANCE);
        this.mCaptureState$delegate = LazyKt.lazy((Function0)mCaptureState.2.INSTANCE);
        this.mDateFormat$delegate = LazyKt.lazy((Function0)mDateFormat.2.INSTANCE);
        this.mCameraDir$delegate = LazyKt.lazy((Function0)mCameraDir.2.INSTANCE);
        this.mCameraRender = new CameraRender(context);
        this.mScreenRender = new ScreenRender(context);
        this.mCaptureRender = new CaptureRender(context);
        this.addLifecycleObserver(context);
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"create RenderManager, Open ES version is ", (Object)Utils.INSTANCE.getGLESVersion(context)));
    }

    private final Handler getMMainHandler() {
        Lazy lazy = this.mMainHandler$delegate;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    private final AtomicBoolean getMCaptureState() {
        Lazy lazy = this.mCaptureState$delegate;
        boolean bl = false;
        return (AtomicBoolean)lazy.getValue();
    }

    private final SimpleDateFormat getMDateFormat() {
        Lazy lazy = this.mDateFormat$delegate;
        boolean bl = false;
        return (SimpleDateFormat)lazy.getValue();
    }

    private final String getMCameraDir() {
        Lazy lazy = this.mCameraDir$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    public boolean handleMessage(@NotNull Message msg) {
        Object object;
        boolean bl;
        int n;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        String string = Utils.INSTANCE.getGLESVersion(this.mContext);
        if (string != null) {
            object2 = string;
            n = 0;
            bl = false;
            String version = object2;
            boolean bl2 = false;
            object = version;
            boolean bl3 = false;
            if (Float.parseFloat((String)object) < 2.0f) {
                Logger.e$default(Logger.INSTANCE, TAG, "OpenGL ES version(" + version + ") is too lower", null, 4, null);
                return true;
            }
        }
        int n2 = msg.what;
        switch (n2) {
            case 0: {
                object2 = msg.obj;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Triple<*, *, *>");
                }
                object2 = (Triple)object2;
                n = 0;
                bl = false;
                Object $this$handleMessage_u24lambda_u2d1 = object2;
                boolean bl4 = false;
                object = $this$handleMessage_u24lambda_u2d1.getFirst();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int w = (Integer)object;
                Object object3 = $this$handleMessage_u24lambda_u2d1.getSecond();
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int h = (Integer)object3;
                Object object4 = $this$handleMessage_u24lambda_u2d1.getThird();
                Surface surface2 = object4 instanceof Surface ? (Surface)object4 : null;
                object4 = this.mScreenRender;
                if (object4 != null) {
                    ((ScreenRender)object4).initEGLEvn();
                }
                object4 = this.mScreenRender;
                if (object4 != null) {
                    ((ScreenRender)object4).setupSurface(surface2, w, h);
                }
                object4 = this.mScreenRender;
                if (object4 != null) {
                    ((ScreenRender)object4).eglMakeCurrent();
                }
                object4 = this.mCameraRender;
                if (object4 != null) {
                    ((AbstractRender)object4).initGLES();
                }
                object4 = this.mScreenRender;
                if (object4 != null) {
                    ((AbstractRender)object4).initGLES();
                }
                object4 = this.mCaptureRender;
                if (object4 != null) {
                    ((AbstractRender)object4).initGLES();
                }
                EventBus.INSTANCE.with("render-ready").postMessage(true);
                break;
            }
            case 5: {
                object2 = msg.obj;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                }
                object2 = (Pair)object2;
                n = 0;
                bl = false;
                Object $this$handleMessage_u24lambda_u2d2 = object2;
                boolean bl5 = false;
                Object h = $this$handleMessage_u24lambda_u2d2.getFirst();
                if (h == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                this.mWidth = (Integer)h;
                h = $this$handleMessage_u24lambda_u2d2.getSecond();
                if (h == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                this.mHeight = (Integer)h;
                h = this.mCameraRender;
                if (h != null) {
                    ((AbstractFboRender)h).setSize(this.mWidth, this.mHeight);
                }
                h = this.mScreenRender;
                if (h != null) {
                    ((AbstractRender)h).setSize(this.mWidth, this.mHeight);
                }
                h = this.mCaptureRender;
                if (h != null) {
                    ((AbstractFboRender)h).setSize(this.mWidth, this.mHeight);
                }
                h = this.mCameraSurfaceTexture;
                if (h == null) break;
                h.setDefaultBufferSize(this.mWidth, this.mHeight);
                break;
            }
            case 8: {
                object2 = msg.obj;
                this.saveImageInternal(object2 instanceof String ? (String)object2 : null);
                break;
            }
            case 3: {
                object2 = msg.obj;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Triple<*, *, *>");
                }
                object2 = (Triple)object2;
                n = 0;
                bl = false;
                Object $this$handleMessage_u24lambda_u2d52 = object2;
                boolean bl6 = false;
                Object h = $this$handleMessage_u24lambda_u2d52.getFirst();
                if (h == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.Surface");
                }
                Surface surface = (Surface)h;
                Object surface2 = $this$handleMessage_u24lambda_u2d52.getSecond();
                if (surface2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int width = (Integer)surface2;
                Object object5 = $this$handleMessage_u24lambda_u2d52.getThird();
                if (object5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int height = (Integer)object5;
                this.startRenderCodecInternal(surface, width, height);
                break;
            }
            case 4: {
                this.stopRenderCodecInternal();
                break;
            }
            case 9: {
                Object object6 = msg.obj;
                Object object7 = object2 = object6 instanceof RotateType ? (RotateType)((Object)object6) : null;
                if (object2 == null) break;
                object6 = object2;
                bl = false;
                boolean $this$handleMessage_u24lambda_u2d52 = false;
                Object $this$handleMessage_u24lambda_u2d4 = object6;
                boolean bl7 = false;
                CameraRender surface = this.mCameraRender;
                if (surface == null) break;
                surface.setRotateAngle((RotateType)((Object)$this$handleMessage_u24lambda_u2d4));
                break;
            }
            case 1: {
                long l;
                long l2;
                Integer n3;
                object2 = this.mCameraSurfaceTexture;
                if (object2 != null) {
                    object2.updateTexImage();
                }
                object2 = this.mCameraSurfaceTexture;
                if (object2 != null) {
                    object2.getTransformMatrix(this.mTransformMatrix);
                }
                object2 = this.mCameraRender;
                if (object2 != null) {
                    ((CameraRender)object2).setTransformMatrix(this.mTransformMatrix);
                }
                object2 = this.mCameraRender;
                if (object2 != null) {
                    ((AbstractFboRender)object2).drawFrame(this.mTextureId);
                }
                object2 = this.mCameraRender;
                if (object2 == null) break;
                int $this$handleMessage_u24lambda_u2d52 = n = ((AbstractFboRender)object2).getFboTextureId();
                boolean $this$handleMessage_u24lambda_u2d4 = false;
                boolean bl7 = false;
                int fboId = $this$handleMessage_u24lambda_u2d52;
                boolean bl8 = false;
                int effectId = 0;
                effectId = fboId;
                Iterable $this$forEach$iv = this.mEffectList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AbstractEffect effectRender = (AbstractEffect)element$iv;
                    boolean bl9 = false;
                    effectRender.drawFrame(effectId);
                    effectId = effectRender.getFboTextureId();
                }
                Integer $this$handleMessage_u24lambda_u2d52 = n3 = Integer.valueOf(effectId);
                $this$handleMessage_u24lambda_u2d4 = false;
                bl7 = false;
                int id = ((Number)$this$handleMessage_u24lambda_u2d52).intValue();
                boolean bl10 = false;
                ScreenRender screenRender = this.mScreenRender;
                if (screenRender != null) {
                    screenRender.drawFrame(id);
                }
                this.drawFrame2Capture(id);
                screenRender = this.mCameraSurfaceTexture;
                this.drawFrame2Codec(id, screenRender == null ? 0L : (l2 = screenRender.getTimestamp()));
                screenRender = this.mScreenRender;
                if (screenRender == null) break;
                SurfaceTexture surfaceTexture = this.mCameraSurfaceTexture;
                screenRender.swapBuffers(surfaceTexture == null ? 0L : (l = surfaceTexture.getTimestamp()));
                break;
            }
            case 6: {
                Object object8 = msg.obj;
                Object object9 = object2 = object8 instanceof AbstractEffect ? (AbstractEffect)object8 : null;
                if (object2 == null) break;
                object8 = object2;
                bl = false;
                boolean $this$handleMessage_u24lambda_u2d52 = false;
                Object effect = object8;
                boolean bl11 = false;
                if (this.mEffectList.contains(effect)) break;
                ((AbstractRender)effect).initGLES();
                ((AbstractFboRender)effect).setSize(this.mWidth, this.mHeight);
                this.mEffectList.add((AbstractEffect)effect);
                this.mCacheEffectList.add((AbstractEffect)effect);
                Logger.INSTANCE.i(TAG, "add effect, name = " + effect.getClass().getSimpleName() + ", size = " + this.mEffectList.size());
                break;
            }
            case 7: {
                Object object10 = msg.obj;
                Object object11 = object2 = object10 instanceof AbstractEffect ? (AbstractEffect)object10 : null;
                if (object2 == null) break;
                object10 = object2;
                bl = false;
                boolean $this$handleMessage_u24lambda_u2d52 = false;
                Object it = object10;
                boolean bl12 = false;
                if (!this.mEffectList.contains(it)) break;
                ((AbstractRender)it).releaseGLES();
                this.mEffectList.remove(it);
                this.mCacheEffectList.remove(it);
                Logger.INSTANCE.i(TAG, "remove effect, name = " + it.getClass().getSimpleName() + ", size = " + this.mEffectList.size());
                break;
            }
            case 2: {
                EventBus.INSTANCE.with("render-ready").postMessage(false);
                Iterable $this$forEach$iv = this.mEffectList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AbstractEffect effect = (AbstractEffect)element$iv;
                    boolean bl13 = false;
                    effect.releaseGLES();
                }
                this.mEffectList.clear();
                object2 = this.mCameraRender;
                if (object2 != null) {
                    ((AbstractRender)object2).releaseGLES();
                }
                object2 = this.mScreenRender;
                if (object2 != null) {
                    ((AbstractRender)object2).releaseGLES();
                }
                object2 = this.mCaptureRender;
                if (object2 != null) {
                    ((AbstractRender)object2).releaseGLES();
                }
                object2 = this.mCameraSurfaceTexture;
                if (object2 != null) {
                    object2.setOnFrameAvailableListener(null);
                }
                this.mCameraSurfaceTexture = null;
            }
        }
        return true;
    }

    private final void drawFrame2Capture(int fboId) {
        CaptureRender captureRender = this.mCaptureRender;
        if (captureRender != null) {
            captureRender.drawFrame(fboId);
        }
        captureRender = this.mCaptureRender;
        if (captureRender != null) {
            int n;
            int n2 = n = captureRender.getFboTextureId();
            boolean bl = false;
            boolean bl2 = false;
            int id = n2;
            boolean bl3 = false;
            this.mFBOId = id;
        }
    }

    public final void startRenderScreen(int w, int h, @Nullable Surface outSurface, @Nullable CameraSurfaceTextureListener listener2) {
        Message message;
        Object object;
        if (this.mCameraSurfaceTexture == null) {
            object = this.mCameraRender;
            Integer n = object == null ? null : Integer.valueOf(((AbstractRender)object).createOESTexture());
            Intrinsics.checkNotNull((Object)n);
            this.mTextureId = n;
            this.mCameraSurfaceTexture = new SurfaceTexture(this.mTextureId);
            object = this.mCameraSurfaceTexture;
            if (object != null) {
                object.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            }
        }
        if ((object = listener2) != null) {
            object.onSurfaceTextureAvailable(this.mCameraSurfaceTexture);
        }
        this.mRenderThread = new HandlerThread(RENDER_THREAD);
        object = this.mRenderThread;
        if (object != null) {
            object.start();
        }
        HandlerThread handlerThread = this.mRenderThread;
        Intrinsics.checkNotNull((Object)handlerThread);
        this.mRenderHandler = new Handler(handlerThread.getLooper(), (Handler.Callback)this);
        object = new Triple((Object)w, (Object)h, (Object)outSurface);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$startRenderScreen_u24lambda_u2d12 = object;
        boolean bl3 = false;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(0, $this$startRenderScreen_u24lambda_u2d12)) != null) {
            message.sendToTarget();
        }
        this.setRenderSize(w, h);
    }

    public static /* synthetic */ void startRenderScreen$default(RenderManager renderManager, int n, int n2, Surface surface, CameraSurfaceTextureListener cameraSurfaceTextureListener, int n3, Object object) {
        if ((n3 & 8) != 0) {
            cameraSurfaceTextureListener = null;
        }
        renderManager.startRenderScreen(n, n2, surface, cameraSurfaceTextureListener);
    }

    public final void stopRenderScreen() {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(2)) != null) {
            message.sendToTarget();
        }
        if ((handler = this.mRenderThread) != null) {
            handler.quitSafely();
        }
        this.mRenderThread = null;
        this.mRenderHandler = null;
    }

    public final void startRenderCodec(@NotNull Surface inputSurface, int width, int height) {
        Message message;
        Intrinsics.checkNotNullParameter((Object)inputSurface, (String)"inputSurface");
        Triple triple = new Triple((Object)inputSurface, (Object)width, (Object)height);
        boolean bl = false;
        boolean bl2 = false;
        Triple $this$startRenderCodec_u24lambda_u2d13 = triple;
        boolean bl3 = false;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(3, (Object)$this$startRenderCodec_u24lambda_u2d13)) != null) {
            message.sendToTarget();
        }
    }

    public final void stopRenderCodec() {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(4)) != null) {
            message.sendToTarget();
        }
    }

    public final void setRenderSize(int w, int h) {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(5, (Object)new Pair((Object)w, (Object)h))) != null) {
            message.sendToTarget();
        }
    }

    public final void addRenderEffect(@Nullable AbstractEffect effect) {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(6, (Object)effect)) != null) {
            message.sendToTarget();
        }
    }

    public final void removeRenderEffect(@Nullable AbstractEffect effect) {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(7, (Object)effect)) != null) {
            message.sendToTarget();
        }
    }

    public final void setRotateType(@Nullable RotateType type) {
        Message message;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(9, (Object)type)) != null) {
            message.sendToTarget();
        }
    }

    @NotNull
    public final ArrayList<AbstractEffect> getCacheEffectList() {
        return this.mCacheEffectList;
    }

    public final void saveImage(@Nullable ICaptureCallBack callBack, @Nullable String path) {
        Message message;
        this.mCaptureDataCb = callBack;
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(8, (Object)path)) != null) {
            message.sendToTarget();
        }
    }

    public void onFrameAvailable(@Nullable SurfaceTexture surfaceTexture) {
        Message message;
        this.emitFrameRate();
        Handler handler = this.mRenderHandler;
        if (handler != null && (message = handler.obtainMessage(1)) != null) {
            message.sendToTarget();
        }
    }

    private final void startRenderCodecInternal(Surface surface, int w, int h) {
        Message message;
        Message message2;
        this.stopRenderCodecInternal();
        this.mRenderCodecThread = new HandlerThread(RENDER_CODEC_THREAD);
        Object object = this.mRenderCodecThread;
        if (object != null) {
            object.start();
        }
        HandlerThread handlerThread = this.mRenderCodecThread;
        Intrinsics.checkNotNull((Object)handlerThread);
        this.mRenderCodecHandler = new Handler(handlerThread.getLooper(), arg_0 -> RenderManager.startRenderCodecInternal$lambda-17(this, arg_0));
        object = this.mScreenRender;
        object = object == null ? null : ((ScreenRender)object).getCurrentContext();
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        if (it == null) {
            throw new NullPointerException("Current EGLContext can't be null.");
        }
        Handler handler = this.mRenderCodecHandler;
        if (handler != null && (message2 = handler.obtainMessage(17, (Object)new Pair(it, (Object)surface))) != null) {
            message2.sendToTarget();
        }
        object = this.mRenderCodecHandler;
        if (object != null && (message = object.obtainMessage(18, (Object)new Pair((Object)w, (Object)h))) != null) {
            message.sendToTarget();
        }
    }

    private final void drawFrame2Codec(int textureId, long timeStamps) {
        Message message;
        Pair pair = new Pair((Object)textureId, (Object)timeStamps);
        boolean bl = false;
        boolean bl2 = false;
        Pair $this$drawFrame2Codec_u24lambda_u2d19 = pair;
        boolean bl3 = false;
        Handler handler = this.mRenderCodecHandler;
        if (handler != null && (message = handler.obtainMessage(19, (Object)$this$drawFrame2Codec_u24lambda_u2d19)) != null) {
            message.sendToTarget();
        }
    }

    private final void stopRenderCodecInternal() {
        Message message;
        Handler handler = this.mRenderCodecHandler;
        if (handler != null && (message = handler.obtainMessage(20)) != null) {
            message.sendToTarget();
        }
        if ((handler = this.mRenderCodecThread) != null) {
            handler.quitSafely();
        }
        this.mRenderCodecThread = null;
        this.mRenderCodecHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void saveImageInternal(String savePath) {
        if (this.getMCaptureState().get()) {
            return;
        }
        this.getMCaptureState().set(true);
        this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda-20(this));
        String date = this.getMDateFormat().format(System.currentTimeMillis());
        String string = savePath;
        String title = string == null ? Intrinsics.stringPlus((String)"IMG_JJCamera_", (Object)date) : string;
        String string2 = savePath;
        String displayName = string2 == null ? Intrinsics.stringPlus((String)title, (Object)".jpg") : string2;
        String string3 = savePath;
        String path = string3 == null ? this.getMCameraDir() + '/' + displayName : string3;
        int width = this.mWidth;
        int height = this.mHeight;
        Location location = this.getGpsLocation();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            Object object = GLBitmapUtils.INSTANCE.transFrameBufferToBitmap(this.mFBOId, width, height);
            boolean bl = false;
            boolean bl2 = false;
            Bitmap $this$saveImageInternal_u24lambda_u2d21 = object;
            boolean bl3 = false;
            $this$saveImageInternal_u24lambda_u2d21.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            $this$saveImageInternal_u24lambda_u2d21.recycle();
            try {
                object = fos;
                ((FileOutputStream)object).close();
            }
            catch (IOException e) {
                Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Failed to write file, err = ", (Object)e.getLocalizedMessage()), e);
            }
        }
        catch (IOException e) {
            this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda-22(this, e));
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Failed to write file, err = ", (Object)e.getLocalizedMessage()), e);
        }
        finally {
            try {
                FileOutputStream e = fos;
                if (e != null) {
                    e.close();
                }
            }
            catch (IOException e) {
                Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"Failed to write file, err = ", (Object)e.getLocalizedMessage()), e);
            }
        }
        File file = new File(path);
        if (file.length() == 0L) {
            Logger.e$default(Logger.INSTANCE, TAG, Intrinsics.stringPlus((String)"Failed to save file ", (Object)path), null, 4, null);
            file.delete();
            this.getMCaptureState().set(false);
            return;
        }
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        values.put("_data", path);
        values.put("datetaken", date);
        values.put("width", Integer.valueOf(width));
        values.put("height", Integer.valueOf(height));
        Location location2 = location;
        values.put("longitude", location2 == null ? null : Double.valueOf(location2.getLongitude()));
        location2 = location;
        values.put("latitude", location2 == null ? null : Double.valueOf(location2.getLatitude()));
        location2 = this.mContext.getContentResolver();
        if (location2 != null) {
            location2.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        this.getMMainHandler().post(() -> RenderManager.saveImageInternal$lambda-23(this, path));
        this.getMCaptureState().set(false);
        if (!Utils.INSTANCE.getDebugCamera$libausbc_release()) return;
        Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"captureImageInternal save path = ", (Object)path));
    }

    private final void addLifecycleObserver(Context context) {
        if (!(context instanceof LifecycleOwner)) {
            return;
        }
        ((LifecycleOwner)context).getLifecycle().addObserver((LifecycleObserver)new LifecycleEventObserver(this){
            final /* synthetic */ RenderManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Lifecycle.Event event2 = event;
                int n = addLifecycleObserver.WhenMappings.$EnumSwitchMapping$0[event2.ordinal()];
                if (n == 1) {
                    this.this$0.stopRenderScreen();
                }
            }
        });
    }

    private final Location getGpsLocation() {
        Context context = this.mContext;
        boolean bl = false;
        boolean bl2 = false;
        Context ctx = context;
        boolean bl3 = false;
        Object object = ctx.getSystemService("location");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.location.LocationManager");
        }
        LocationManager locationManager = (LocationManager)object;
        int locPermission = ContextCompat.checkSelfPermission((Context)ctx, (String)"android.permission.ACCESS_FINE_LOCATION");
        if (locPermission == 0) {
            return locationManager.getLastKnownLocation("passive");
        }
        return null;
    }

    private final void emitFrameRate() {
        RenderManager renderManager = this;
        int n = renderManager.mFrameRate;
        renderManager.mFrameRate = n + 1;
        this.mEndTime = System.currentTimeMillis();
        if (this.mEndTime - this.mStartTime >= 1000L) {
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, "camera render frame rate is " + this.mFrameRate + " fps");
            }
            EventBus.INSTANCE.with("frame-rate").postMessage(this.mFrameRate);
            this.mStartTime = this.mEndTime;
            this.mFrameRate = 0;
        }
    }

    private static final boolean startRenderCodecInternal$lambda-17(RenderManager this$0, Message message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = message.what;
        switch (n) {
            case 17: {
                Object object = message.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                }
                object = (Pair)object;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d14 = object;
                boolean bl3 = false;
                Object object2 = $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d14.getFirst();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.opengl.EGLContext");
                }
                EGLContext shareContext = (EGLContext)object2;
                Object object3 = $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d14.getSecond();
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.view.Surface");
                }
                Surface inputSurface = (Surface)object3;
                this$0.mEncodeRender = new EncodeRender(this$0.mContext);
                object3 = this$0.mEncodeRender;
                if (object3 != null) {
                    ((EncodeRender)object3).initEGLEvn(shareContext);
                }
                object3 = this$0.mEncodeRender;
                if (object3 != null) {
                    ((EncodeRender)object3).setupSurface(inputSurface);
                }
                object3 = this$0.mEncodeRender;
                if (object3 == null) break;
                ((AbstractRender)object3).initGLES();
                break;
            }
            case 18: {
                Object object = message.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                }
                object = (Pair)object;
                boolean bl = false;
                boolean bl4 = false;
                Object $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d15 = object;
                boolean bl5 = false;
                Object inputSurface = $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d15.getFirst();
                if (inputSurface == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int width = (Integer)inputSurface;
                Object object4 = $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d15.getSecond();
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int height = (Integer)object4;
                object4 = this$0.mEncodeRender;
                if (object4 == null) break;
                ((AbstractRender)object4).setSize(width, height);
                break;
            }
            case 19: {
                Object object = message.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Pair<*, *>");
                }
                object = (Pair)object;
                boolean bl = false;
                boolean bl6 = false;
                Object $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d16 = object;
                boolean bl7 = false;
                Object object5 = $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d16.getFirst();
                if (object5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                int textureId = (Integer)object5;
                Object object6 = $this$startRenderCodecInternal_u24lambda_u2d17_u24lambda_u2d16.getSecond();
                if (object6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                long timeStamps = (Long)object6;
                object6 = this$0.mEncodeRender;
                if (object6 != null) {
                    ((AbstractRender)object6).drawFrame(textureId);
                }
                object6 = this$0.mEncodeRender;
                if (object6 == null) break;
                ((EncodeRender)object6).swapBuffers(timeStamps);
                break;
            }
            case 20: {
                EncodeRender encodeRender = this$0.mEncodeRender;
                if (encodeRender != null) {
                    encodeRender.releaseGLES();
                }
                this$0.mEncodeRender = null;
            }
        }
        return true;
    }

    private static final void saveImageInternal$lambda-20(RenderManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onBegin();
        }
    }

    private static final void saveImageInternal$lambda-22(RenderManager this$0, IOException $e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError($e.getLocalizedMessage());
        }
    }

    private static final void saveImageInternal$lambda-23(RenderManager this$0, String $path) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        ICaptureCallBack iCaptureCallBack = this$0.mCaptureDataCb;
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onComplete($path);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager$CameraSurfaceTextureListener;", "", "onSurfaceTextureAvailable", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "libausbc_release"})
    public static interface CameraSurfaceTextureListener {
        public void onSurfaceTextureAvailable(@Nullable SurfaceTexture var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jiangdg/ausbc/render/RenderManager$Companion;", "", "()V", "MSG_GL_ADD_EFFECT", "", "MSG_GL_CHANGED_SIZE", "MSG_GL_DRAW", "MSG_GL_INIT", "MSG_GL_RELEASE", "MSG_GL_REMOVE_EFFECT", "MSG_GL_RENDER_CODEC_CHANGED_SIZE", "MSG_GL_RENDER_CODEC_DRAW", "MSG_GL_RENDER_CODEC_INIT", "MSG_GL_RENDER_CODEC_RELEASE", "MSG_GL_ROUTE_ANGLE", "MSG_GL_SAVE_IMAGE", "MSG_GL_START_RENDER_CODEC", "MSG_GL_STOP_RENDER_CODEC", "RENDER_CODEC_THREAD", "", "RENDER_THREAD", "TAG", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

