/*
 * Decompiled with CFR 0.152.
 */
package com.jiangdg.ausbc.camera;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.location.Location;
import android.media.Image;
import android.media.ImageReader;
import android.provider.MediaStore;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.jiangdg.ausbc.callback.ICaptureCallBack;
import com.jiangdg.ausbc.callback.IPreviewDataCallBack;
import com.jiangdg.ausbc.camera.Camera2Strategy;
import com.jiangdg.ausbc.camera.ICameraStrategy;
import com.jiangdg.ausbc.camera.bean.CameraInfo;
import com.jiangdg.ausbc.camera.bean.CameraRequest;
import com.jiangdg.ausbc.camera.bean.CameraStatus;
import com.jiangdg.ausbc.camera.bean.CameraV2Info;
import com.jiangdg.ausbc.camera.bean.PreviewSize;
import com.jiangdg.ausbc.utils.Logger;
import com.jiangdg.ausbc.utils.SettableFuture;
import com.jiangdg.ausbc.utils.Utils;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ab\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u000f*\u0003\u000f\u0015\u001a\b\u0007\u0018\u0000 V2\u00020\u0001:\u0001VB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u001dH\u0014J\b\u00100\u001a\u00020.H\u0002J\b\u00101\u001a\u00020.H\u0002J\b\u00102\u001a\u00020.H\u0002J\b\u00103\u001a\u00020.H\u0002J\u001d\u00104\u001a\b\u0012\u0004\u0012\u000206052\b\u00107\u001a\u0004\u0018\u000108H\u0016\u00a2\u0006\u0002\u00109J\u0012\u0010:\u001a\u0004\u0018\u00010\u00072\u0006\u0010;\u001a\u00020\u001dH\u0002J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020=H\u0002J,\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00072\n\u0010C\u001a\u0006\u0012\u0002\b\u00030D2\u0006\u0010E\u001a\u00020=2\u0006\u0010F\u001a\u00020=H\u0002J-\u0010@\u001a\u00020A2\u000e\u0010G\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010H2\u0006\u0010E\u001a\u00020=2\u0006\u0010F\u001a\u00020=H\u0002\u00a2\u0006\u0002\u0010IJ\b\u0010J\u001a\u00020.H\u0014J\b\u0010K\u001a\u00020.H\u0003J\b\u0010L\u001a\u00020.H\u0002J\b\u0010M\u001a\u00020.H\u0002J\b\u0010N\u001a\u00020.H\u0002J\b\u0010O\u001a\u00020.H\u0014J\b\u0010P\u001a\u00020.H\u0014J\u0012\u0010Q\u001a\u00020.2\b\u0010R\u001a\u0004\u0018\u00010\u001dH\u0014J\u0018\u0010S\u001a\u00020.2\u0006\u0010T\u001a\u00020=2\u0006\u0010U\u001a\u00020=H\u0014R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcom/jiangdg/ausbc/camera/Camera2Strategy;", "Lcom/jiangdg/ausbc/camera/ICameraStrategy;", "ctx", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mCameraCharacteristicsFuture", "Lcom/jiangdg/ausbc/utils/SettableFuture;", "Landroid/hardware/camera2/CameraCharacteristics;", "mCameraDeviceFuture", "Landroid/hardware/camera2/CameraDevice;", "mCameraManager", "Landroid/hardware/camera2/CameraManager;", "mCameraSessionFuture", "Landroid/hardware/camera2/CameraCaptureSession;", "mCameraStateCallBack", "com/jiangdg/ausbc/camera/Camera2Strategy$mCameraStateCallBack$1", "Lcom/jiangdg/ausbc/camera/Camera2Strategy$mCameraStateCallBack$1;", "mCaptureResults", "Ljava/util/concurrent/BlockingQueue;", "Landroid/hardware/camera2/CaptureResult;", "mCreateSessionStateCallBack", "com/jiangdg/ausbc/camera/Camera2Strategy$mCreateSessionStateCallBack$1", "Lcom/jiangdg/ausbc/camera/Camera2Strategy$mCreateSessionStateCallBack$1;", "mImageCaptureBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "mImageCaptureStateCallBack", "com/jiangdg/ausbc/camera/Camera2Strategy$mImageCaptureStateCallBack$1", "Lcom/jiangdg/ausbc/camera/Camera2Strategy$mImageCaptureStateCallBack$1;", "mImageSavePath", "", "mJpegAvailableListener", "Landroid/media/ImageReader$OnImageAvailableListener;", "getMJpegAvailableListener$annotations", "()V", "mJpegDataSurface", "Landroid/view/Surface;", "mJpegImageReader", "Landroid/media/ImageReader;", "mPreviewAvailableListener", "mPreviewCaptureBuilder", "mPreviewDataImageReader", "mPreviewDataSurface", "mPreviewSurface", "mYUVData", "", "captureImageInternal", "", "savePath", "closeCamera", "closeSession", "createCaptureRequestBuilders", "createSession", "getAllPreviewSizes", "", "Lcom/jiangdg/ausbc/camera/bean/PreviewSize;", "aspectRatio", "", "(Ljava/lang/Double;)Ljava/util/List;", "getCameraCharacteristics", "id", "getJpegOrientation", "", "characteristics", "deviceOrientation", "getSuitableSize", "Landroid/util/Size;", "cameraCharacteristics", "clazz", "Ljava/lang/Class;", "maxWidth", "maxHeight", "sizeList", "", "([Landroid/util/Size;II)Landroid/util/Size;", "loadCameraInfo", "openCamera", "realStartPreview", "setImageSize", "setPreviewSize", "startPreviewInternal", "stopPreviewInternal", "switchCameraInternal", "cameraId", "updateResolutionInternal", "width", "height", "Companion", "libausbc_release"})
@RequiresApi(value=21)
public final class Camera2Strategy
extends ICameraStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockingQueue<CaptureResult> mCaptureResults;
    @Nullable
    private CaptureRequest.Builder mImageCaptureBuilder;
    @Nullable
    private CaptureRequest.Builder mPreviewCaptureBuilder;
    @Nullable
    private SettableFuture<CameraDevice> mCameraDeviceFuture;
    @Nullable
    private SettableFuture<CameraCharacteristics> mCameraCharacteristicsFuture;
    @Nullable
    private SettableFuture<CameraCaptureSession> mCameraSessionFuture;
    @NotNull
    private SettableFuture<String> mImageSavePath;
    @Nullable
    private ImageReader mPreviewDataImageReader;
    @Nullable
    private ImageReader mJpegImageReader;
    @Nullable
    private Surface mPreviewSurface;
    @Nullable
    private Surface mPreviewDataSurface;
    @Nullable
    private Surface mJpegDataSurface;
    @Nullable
    private CameraManager mCameraManager;
    @Nullable
    private byte[] mYUVData;
    @NotNull
    private final mCameraStateCallBack.1 mCameraStateCallBack;
    @NotNull
    private final mCreateSessionStateCallBack.1 mCreateSessionStateCallBack;
    @NotNull
    private final mImageCaptureStateCallBack.1 mImageCaptureStateCallBack;
    @NotNull
    private final ImageReader.OnImageAvailableListener mPreviewAvailableListener;
    @NotNull
    private final ImageReader.OnImageAvailableListener mJpegAvailableListener;
    @NotNull
    private static final String TAG = "CameraV2";

    public Camera2Strategy(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        super(ctx);
        this.mCaptureResults = new LinkedBlockingDeque();
        this.mImageSavePath = new SettableFuture();
        this.mCameraStateCallBack = new CameraDevice.StateCallback(this){
            final /* synthetic */ Camera2Strategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOpened(@NotNull CameraDevice camera) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                SettableFuture settableFuture = Camera2Strategy.access$getMCameraDeviceFuture$p(this.this$0);
                if (settableFuture != null) {
                    settableFuture.set(camera);
                }
                settableFuture = Camera2Strategy.access$getMCameraCharacteristicsFuture$p(this.this$0);
                if (settableFuture != null) {
                    String string = camera.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"camera.id");
                    settableFuture.set(Camera2Strategy.access$getCameraCharacteristics(this.this$0, string));
                }
                Logger.INSTANCE.i("CameraV2", "connect camera success in callback.");
            }

            public void onDisconnected(@NotNull CameraDevice camera) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                SettableFuture settableFuture = Camera2Strategy.access$getMCameraDeviceFuture$p(this.this$0);
                if (settableFuture != null) {
                    settableFuture.set(camera);
                }
                this.this$0.stopPreviewInternal();
                Logger.INSTANCE.i("CameraV2", "disconnect camera success in callback.");
            }

            public void onError(@NotNull CameraDevice camera, int error) {
                Intrinsics.checkNotNullParameter((Object)camera, (String)"camera");
                SettableFuture settableFuture = Camera2Strategy.access$getMCameraDeviceFuture$p(this.this$0);
                if (settableFuture != null) {
                    settableFuture.set(camera);
                }
                this.this$0.stopPreviewInternal();
                Logger.INSTANCE.i("CameraV2", "connect camera err = (" + error + ") in callback.");
            }
        };
        this.mCreateSessionStateCallBack = new CameraCaptureSession.StateCallback(this){
            final /* synthetic */ Camera2Strategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConfigured(@NotNull CameraCaptureSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Logger.INSTANCE.i("CameraV2", "configure session success in callback!");
                SettableFuture settableFuture = Camera2Strategy.access$getMCameraSessionFuture$p(this.this$0);
                if (settableFuture != null) {
                    settableFuture.set(session);
                }
            }

            public void onConfigureFailed(@NotNull CameraCaptureSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Logger.INSTANCE.i("CameraV2", "configure session failed in callback!");
                SettableFuture settableFuture = Camera2Strategy.access$getMCameraSessionFuture$p(this.this$0);
                if (settableFuture != null) {
                    settableFuture.set(session);
                }
            }
        };
        this.mImageCaptureStateCallBack = new CameraCaptureSession.CaptureCallback(this){
            final /* synthetic */ Camera2Strategy this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCaptureStarted(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, long timestamp, long frameNumber) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                super.onCaptureStarted(session, request, timestamp, frameNumber);
                this.this$0.getMMainHandler().post(() -> mImageCaptureStateCallBack.1.onCaptureStarted$lambda-0(this.this$0));
            }

            public void onCaptureCompleted(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull TotalCaptureResult result) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                super.onCaptureCompleted(session, request, result);
                Camera2Strategy.access$getMCaptureResults$p(this.this$0).put(result);
            }

            private static final void onCaptureStarted$lambda-0(Camera2Strategy this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
                if (iCaptureCallBack != null) {
                    iCaptureCallBack.onBegin();
                }
            }
        };
        this.mPreviewAvailableListener = arg_0 -> Camera2Strategy.mPreviewAvailableListener$lambda-33(this, arg_0);
        this.mJpegAvailableListener = arg_0 -> Camera2Strategy.mJpegAvailableListener$lambda-38(this, arg_0);
    }

    @Override
    protected void loadCameraInfo() {
        Object object = this.getContext();
        Object object2 = object == null ? null : object.getSystemService("camera");
        this.mCameraManager = object2 instanceof CameraManager ? (CameraManager)object2 : null;
        object2 = this.mCameraManager;
        if (object2 != null) {
            object = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$loadCameraInfo_u24lambda_u2d4 = object;
            boolean bl3 = false;
            String[] stringArray = $this$loadCameraInfo_u24lambda_u2d4.getCameraIdList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"cameraIdList");
            Object[] $this$forEach$iv = stringArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Size[] sizeList;
                Size[] streamConfigurationMap;
                int n;
                String cameraId = (String)element$iv;
                boolean bl4 = false;
                Object object3 = $this$loadCameraInfo_u24lambda_u2d4.getCameraCharacteristics(cameraId);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getCameraCharacteristics(cameraId)");
                CameraCharacteristics characteristics = object3;
                Object object4 = object3 = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                int n2 = 0;
                if (object4 != null && (Integer)object4 == 0) {
                    n = 0;
                } else {
                    Object object5 = object3;
                    n2 = 1;
                    n = object5 != null && (Integer)object5 == n2 ? 1 : 2;
                }
                int n3 = n;
                n2 = 0;
                boolean bl5 = false;
                int type = n3;
                boolean bl6 = false;
                boolean bl7 = false;
                List list = new ArrayList();
                Size[] sizeArray = streamConfigurationMap = (Size[])characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                sizeArray = sizeList = sizeArray == null ? null : sizeArray.getOutputSizes(SurfaceTexture.class);
                if (sizeArray != null) {
                    Size[] $this$forEach$iv2 = sizeArray;
                    boolean $i$f$forEach2 = false;
                    Size[] sizeArray2 = $this$forEach$iv2;
                    int n4 = sizeArray2.length;
                    for (int i = 0; i < n4; ++i) {
                        Size element$iv2;
                        Size it = element$iv2 = sizeArray2[i];
                        boolean bl8 = false;
                        list.add(new PreviewSize(it.getWidth(), it.getHeight()));
                    }
                }
                if (this.getMCameraInfoMap().get(type) != null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)cameraId, (String)"cameraId");
                Object object6 = new CameraV2Info(cameraId);
                boolean bl9 = false;
                boolean bl10 = false;
                CameraV2Info $this$loadCameraInfo_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = object6;
                boolean bl11 = false;
                $this$loadCameraInfo_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setCameraType(type);
                $this$loadCameraInfo_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setCameraPreviewSizes(list);
                $this$loadCameraInfo_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setCameraCharacteristics(characteristics);
                String string = cameraId;
                boolean bl12 = false;
                $this$loadCameraInfo_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setCameraVid(Integer.parseInt(string) + 1);
                string = cameraId;
                bl12 = false;
                $this$loadCameraInfo_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setCameraPid(Integer.parseInt(string) + 1);
                CameraV2Info cameraInfo = object6;
                object6 = this.getMCameraInfoMap();
                Integer n5 = type;
                bl10 = false;
                object6.put(n5, cameraInfo);
            }
            if (Utils.INSTANCE.getDebugCamera$libausbc_release()) {
                Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"loadCameraInfo success, camera = ", this.getMCameraInfoMap()));
            }
        }
    }

    @Override
    protected void startPreviewInternal() {
        this.openCamera();
        this.createCaptureRequestBuilders();
        this.setPreviewSize();
        this.setImageSize();
        this.createSession();
        this.realStartPreview();
    }

    @Override
    protected void stopPreviewInternal() {
        this.closeSession();
        this.closeCamera();
    }

    @Override
    protected void captureImageInternal(@Nullable String savePath) {
        if (!this.hasCameraPermission() || !this.hasStoragePermission()) {
            this.getMMainHandler().post(() -> Camera2Strategy.captureImageInternal$lambda-5(this));
            Logger.INSTANCE.i(TAG, "takePictureInternal failed, has no storage/camera permission.");
            return;
        }
        SettableFuture<CameraCaptureSession> settableFuture = this.mCameraSessionFuture;
        CameraCaptureSession cameraSession = settableFuture == null ? null : settableFuture.get(3L, TimeUnit.SECONDS);
        SettableFuture<CameraCharacteristics> settableFuture2 = this.mCameraCharacteristicsFuture;
        CameraCharacteristics characteristics = settableFuture2 == null ? null : settableFuture2.get(3L, TimeUnit.SECONDS);
        CaptureRequest.Builder captureBuilder = this.mImageCaptureBuilder;
        Surface jpegSurface = this.mJpegDataSurface;
        if (cameraSession == null || characteristics == null || captureBuilder == null || jpegSurface == null) {
            this.getMMainHandler().post(() -> Camera2Strategy.captureImageInternal$lambda-6(this));
            Logger.e$default(Logger.INSTANCE, TAG, "takePictureInternal failed, camera init error.", null, 4, null);
            return;
        }
        try {
            CaptureRequest.Builder builder = captureBuilder;
            boolean bl = false;
            boolean bl2 = false;
            CaptureRequest.Builder it = builder;
            boolean bl3 = false;
            int deviceOrientation = this.getDeviceOrientation();
            int jpegOrientation = this.getJpegOrientation(characteristics, deviceOrientation);
            Location location = Utils.INSTANCE.getGpsLocation(this.getContext());
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)jpegOrientation);
            captureBuilder.set(CaptureRequest.JPEG_GPS_LOCATION, (Object)location);
            captureBuilder.set(CaptureRequest.JPEG_QUALITY, (Object)100);
            captureBuilder.addTarget(jpegSurface);
            CaptureRequest captureRequest = captureBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)captureRequest, (String)"captureBuilder.let {\n                val deviceOrientation = getDeviceOrientation()\n                val jpegOrientation = getJpegOrientation(characteristics, deviceOrientation)\n                val location = Utils.getGpsLocation(getContext())\n                captureBuilder[CaptureRequest.JPEG_ORIENTATION] = jpegOrientation\n                captureBuilder[CaptureRequest.JPEG_GPS_LOCATION] = location\n                captureBuilder[CaptureRequest.JPEG_QUALITY] = 100\n                captureBuilder.addTarget(jpegSurface)\n                captureBuilder.build()\n            }");
            CaptureRequest captureRequest2 = captureRequest;
            this.mImageSavePath.set(savePath);
            cameraSession.capture(captureRequest2, (CameraCaptureSession.CaptureCallback)this.mImageCaptureStateCallBack, this.getMMainHandler());
        }
        catch (Exception e) {
            this.getMMainHandler().post(() -> Camera2Strategy.captureImageInternal$lambda-8(this, e));
            Logger.INSTANCE.e(TAG, "takePictureInternal failed, camera access error.", e);
        }
    }

    @Override
    protected void switchCameraInternal(@Nullable String cameraId) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest request = cameraRequest2;
            boolean bl3 = false;
            request.setFrontCamera(!request.isFrontCamera());
            this.stopPreviewInternal();
            this.startPreviewInternal();
        }
    }

    @Override
    protected void updateResolutionInternal(int width, int height) {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest request = cameraRequest2;
            boolean bl3 = false;
            request.setPreviewWidth(width);
            request.setPreviewHeight(height);
            this.stopPreviewInternal();
            this.startPreviewInternal();
        }
    }

    @Override
    @NotNull
    public List<PreviewSize> getAllPreviewSizes(@Nullable Double aspectRatio) {
        boolean bl = false;
        List list = new ArrayList();
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            List<PreviewSize> list2;
            CameraInfo cameraInfo;
            Object object;
            block4: {
                CameraRequest cameraRequest2 = cameraRequest;
                boolean bl2 = false;
                boolean bl3 = false;
                CameraRequest request = cameraRequest2;
                boolean bl4 = false;
                object = this.getMCameraInfoMap().values();
                Intrinsics.checkNotNullExpressionValue(object, (String)"mCameraInfoMap.values");
                object = (Iterable)object;
                boolean bl5 = false;
                Iterable<CameraInfo> iterable = object;
                boolean bl6 = false;
                Iterator<CameraInfo> iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    CameraInfo cameraInfo2;
                    CameraInfo it = cameraInfo2 = iterator.next();
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)request.getCameraId(), (Object)it.getCameraId())) continue;
                    cameraInfo = cameraInfo2;
                    break block4;
                }
                cameraInfo = null;
            }
            CameraInfo cameraInfo3 = cameraInfo;
            object = cameraInfo3;
            if (object != null && (list2 = ((CameraInfo)object).getCameraPreviewSizes()) != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (CameraInfo element$iv : $this$forEach$iv) {
                    PreviewSize size = (PreviewSize)((Object)element$iv);
                    boolean bl8 = false;
                    int width = size.getWidth();
                    int height = size.getHeight();
                    double ratio = (double)width / (double)height;
                    if (aspectRatio != null && !Intrinsics.areEqual((double)ratio, (Double)aspectRatio)) continue;
                    list.add(size);
                }
            }
        }
        Logger.INSTANCE.i(TAG, "getAllPreviewSizes aspect ratio = " + aspectRatio + ", list= " + list);
        return list;
    }

    @SuppressLint(value={"MissingPermission"})
    private final void openCamera() {
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest request = cameraRequest2;
            boolean bl3 = false;
            this.mCameraDeviceFuture = new SettableFuture();
            this.mCameraCharacteristicsFuture = new SettableFuture();
            try {
                if (!this.hasCameraPermission()) {
                    Logger.e$default(Logger.INSTANCE, TAG, "openCamera failed, has no camera permission.", null, 4, null);
                } else if (this.mCameraManager == null) {
                    Logger.e$default(Logger.INSTANCE, TAG, "init camera manager failed, is null!", null, 4, null);
                } else {
                    String string;
                    if (request.isFrontCamera()) {
                        CameraInfo cameraInfo = this.getMCameraInfoMap().get(0);
                        Intrinsics.checkNotNull((Object)cameraInfo);
                        string = cameraInfo.getCameraId();
                    } else {
                        CameraInfo cameraInfo = this.getMCameraInfoMap().get(1);
                        Intrinsics.checkNotNull((Object)cameraInfo);
                        string = cameraInfo.getCameraId();
                    }
                    String cameraId = string;
                    request.setCameraId(cameraId);
                    CameraManager cameraManager = this.mCameraManager;
                    Intrinsics.checkNotNull((Object)cameraManager);
                    cameraManager.openCamera(cameraId, (CameraDevice.StateCallback)this.mCameraStateCallBack, this.getMMainHandler());
                    Logger.INSTANCE.i(TAG, "openCamera success, id = " + cameraId + '.');
                }
            }
            catch (CameraAccessException e) {
                this.closeCamera();
                Logger.INSTANCE.e(TAG, "openCamera failed, err = " + e.getReason() + '.', e);
            }
        }
    }

    private final void createCaptureRequestBuilders() {
        try {
            CameraDevice cameraDevice;
            Object object = this.mCameraDeviceFuture;
            CameraDevice cameraDevice2 = cameraDevice = object == null ? null : ((SettableFuture)object).get(3L, TimeUnit.SECONDS);
            if (cameraDevice == null) {
                Logger.e$default(Logger.INSTANCE, TAG, "createCaptureRequestBuilders failed, camera device is null.", null, 4, null);
                return;
            }
            object = this.getRequest();
            if (object != null) {
                CaptureRequest.Builder builder;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object request = object2;
                boolean bl3 = false;
                this.mPreviewCaptureBuilder = cameraDevice.createCaptureRequest(1);
                if (((CameraRequest)request).isContinuousAFModel() && (builder = this.mPreviewCaptureBuilder) != null) {
                    builder.set(CaptureRequest.CONTROL_AE_MODE, (Object)2);
                }
                if (((CameraRequest)request).isContinuousAEModel() && (builder = this.mPreviewCaptureBuilder) != null) {
                    builder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                }
                this.mImageCaptureBuilder = cameraDevice.createCaptureRequest(2);
                Logger.INSTANCE.i(TAG, "createCaptureRequestBuilders success.");
            }
        }
        catch (CameraAccessException e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"createCaptureRequestBuilders failed, err = ", (Object)e.getReason()), e);
        }
    }

    private final void setPreviewSize() {
        Object object;
        Surface previewSurface;
        CameraCharacteristics characteristics;
        SettableFuture<CameraCharacteristics> settableFuture = this.mCameraCharacteristicsFuture;
        CameraCharacteristics cameraCharacteristics = characteristics = settableFuture == null ? null : settableFuture.get(3L, TimeUnit.SECONDS);
        Object object2 = this.getSurfaceTexture() != null ? new Surface(this.getSurfaceTexture()) : (previewSurface = (object = this.getSurfaceHolder()) == null ? null : object.getSurface());
        if (characteristics == null || previewSurface == null) {
            Logger.e$default(Logger.INSTANCE, TAG, "setPreviewSize failed. Camera characteristics is null.", null, 4, null);
            return;
        }
        object = this.getRequest();
        if (object != null) {
            StreamConfigurationMap streamConfigurationMap;
            Object object3 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object request = object3;
            boolean bl3 = false;
            int maxWidth = ((CameraRequest)request).getPreviewWidth();
            int maxHeight = ((CameraRequest)request).getPreviewHeight();
            Size previewSize = this.getSuitableSize(characteristics, SurfaceTexture.class, maxWidth, maxHeight);
            this.mPreviewSurface = previewSurface;
            ((CameraRequest)request).setPreviewWidth(previewSize.getWidth());
            ((CameraRequest)request).setPreviewHeight(previewSize.getHeight());
            this.mYUVData = new byte[((CameraRequest)request).getPreviewWidth() * ((CameraRequest)request).getPreviewHeight() * 3 / 2];
            int imageFormat = 35;
            StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamConfigurationMap2 == null ? false : streamConfigurationMap2.isOutputSupportedFor(imageFormat)) {
                this.mPreviewDataImageReader = ImageReader.newInstance((int)previewSize.getWidth(), (int)previewSize.getHeight(), (int)imageFormat, (int)3);
                streamConfigurationMap2 = this.mPreviewDataImageReader;
                if (streamConfigurationMap2 != null) {
                    streamConfigurationMap2.setOnImageAvailableListener(this.mPreviewAvailableListener, this.getCameraHandler());
                }
                streamConfigurationMap2 = this.mPreviewDataImageReader;
                this.mPreviewDataSurface = streamConfigurationMap2 == null ? null : streamConfigurationMap2.getSurface();
            }
            Logger.INSTANCE.i(TAG, "setPreviewSize success, size = " + previewSize + '.');
        }
    }

    private final void setImageSize() {
        SettableFuture<CameraCharacteristics> settableFuture = this.mCameraCharacteristicsFuture;
        CameraCharacteristics characteristics = settableFuture == null ? null : settableFuture.get(3L, TimeUnit.SECONDS);
        CaptureRequest.Builder captureBuilder = this.mImageCaptureBuilder;
        if (characteristics == null) {
            Logger.e$default(Logger.INSTANCE, TAG, "setImageSize failed. Camera characteristics is null.", null, 4, null);
            return;
        }
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            int maxHeight;
            CameraRequest cameraRequest2 = cameraRequest;
            boolean bl = false;
            boolean bl2 = false;
            CameraRequest request = cameraRequest2;
            boolean bl3 = false;
            int maxWidth = request.getPreviewWidth();
            Size imageSize = this.getSuitableSize(characteristics, ImageReader.class, maxWidth, maxHeight = request.getPreviewHeight());
            this.mJpegImageReader = ImageReader.newInstance((int)imageSize.getWidth(), (int)imageSize.getHeight(), (int)256, (int)5);
            ImageReader imageReader = this.mJpegImageReader;
            if (imageReader != null) {
                imageReader.setOnImageAvailableListener(this.mJpegAvailableListener, this.getCameraHandler());
            }
            imageReader = this.mJpegImageReader;
            this.mJpegDataSurface = imageReader == null ? null : imageReader.getSurface();
            request.setPreviewWidth(imageSize.getWidth());
            request.setPreviewHeight(imageSize.getHeight());
            imageReader = captureBuilder;
            if (imageReader != null) {
                ImageReader imageReader2 = imageReader;
                boolean bl4 = false;
                boolean bl5 = false;
                ImageReader it = imageReader2;
                boolean bl6 = false;
                Size[] availableThumbnailSizes = (Size[])characteristics.get(CameraCharacteristics.JPEG_AVAILABLE_THUMBNAIL_SIZES);
                Size thumbnailSize = this.getSuitableSize(availableThumbnailSizes, maxWidth, maxHeight);
                captureBuilder.set(CaptureRequest.JPEG_THUMBNAIL_SIZE, (Object)thumbnailSize);
            }
            Logger.INSTANCE.i(TAG, "setImageSize success, size = " + imageSize + '.');
        }
    }

    private final void createSession() {
        try {
            Surface it;
            boolean bl;
            boolean bl2;
            Surface surface;
            CameraDevice cameraDevice;
            SettableFuture<CameraDevice> settableFuture = this.mCameraDeviceFuture;
            CameraDevice cameraDevice2 = cameraDevice = settableFuture == null ? null : settableFuture.get(3L, TimeUnit.SECONDS);
            if (cameraDevice == null) {
                Logger.e$default(Logger.INSTANCE, TAG, "realStartPreview failed, camera init failed.", null, 4, null);
                this.stopPreviewInternal();
                return;
            }
            this.mCameraSessionFuture = new SettableFuture();
            boolean bl3 = false;
            List list = new ArrayList();
            boolean bl4 = false;
            boolean bl5 = false;
            List $this$createSession_u24lambda_u2d22 = list;
            boolean bl6 = false;
            Surface surface2 = this.mPreviewSurface;
            if (surface2 != null) {
                surface = surface2;
                bl2 = false;
                bl = false;
                it = surface;
                boolean bl7 = false;
                $this$createSession_u24lambda_u2d22.add(it);
            }
            surface2 = this.mPreviewDataSurface;
            if (surface2 != null) {
                surface = surface2;
                bl2 = false;
                bl = false;
                it = surface;
                boolean bl8 = false;
                $this$createSession_u24lambda_u2d22.add(it);
            }
            surface2 = this.mJpegDataSurface;
            if (surface2 != null) {
                surface = surface2;
                bl2 = false;
                bl = false;
                it = surface;
                boolean bl9 = false;
                $this$createSession_u24lambda_u2d22.add(it);
            }
            List outputs = list;
            cameraDevice.createCaptureSession(outputs, (CameraCaptureSession.StateCallback)this.mCreateSessionStateCallBack, this.getMMainHandler());
            Logger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"createSession, outputs = ", (Object)outputs.size()));
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"createCaptureSession failed, err = ", (Object)e.getLocalizedMessage()), e);
        }
    }

    private final void realStartPreview() {
        CaptureRequest captureRequest;
        boolean bl;
        boolean bl2;
        Surface surface;
        Object object;
        CaptureRequest.Builder builder;
        boolean bl3;
        boolean bl4;
        CaptureRequest.Builder builder2;
        CameraCaptureSession cameraSession;
        SettableFuture<CameraDevice> settableFuture = this.mCameraDeviceFuture;
        CameraDevice cameraDevice = settableFuture == null ? null : settableFuture.get(3L, TimeUnit.SECONDS);
        SettableFuture<CameraCaptureSession> settableFuture2 = this.mCameraSessionFuture;
        CameraCaptureSession cameraCaptureSession = cameraSession = settableFuture2 == null ? null : settableFuture2.get(3L, TimeUnit.SECONDS);
        if (cameraDevice == null || cameraSession == null) {
            Logger.e$default(Logger.INSTANCE, TAG, "realStartPreview failed, camera init failed.", null, 4, null);
            this.stopPreviewInternal();
            this.postCameraStatus(new CameraStatus(-1, "camera init failed"));
            return;
        }
        Surface surface2 = this.mPreviewSurface;
        Intrinsics.checkNotNull((Object)surface2);
        Surface previewSurface = surface2;
        Surface previewDataSurface = this.mPreviewDataSurface;
        CaptureRequest.Builder builder3 = this.mImageCaptureBuilder;
        if (builder3 != null) {
            builder2 = builder3;
            bl4 = false;
            bl3 = false;
            builder = builder2;
            boolean bl5 = false;
            builder.addTarget(previewSurface);
            object = previewDataSurface;
            if (object != null) {
                surface = object;
                bl2 = false;
                bl = false;
                Surface $this$realStartPreview_u24lambda_u2d24_u24lambda_u2d23 = surface;
                boolean bl6 = false;
                builder.addTarget($this$realStartPreview_u24lambda_u2d24_u24lambda_u2d23);
            }
        }
        builder3 = this.mPreviewCaptureBuilder;
        if (builder3 == null) {
            captureRequest = null;
        } else {
            builder2 = builder3;
            bl4 = false;
            bl3 = false;
            builder = builder2;
            boolean bl7 = false;
            object = previewDataSurface;
            if (object != null) {
                surface = object;
                bl2 = false;
                bl = false;
                Surface $this$realStartPreview_u24lambda_u2d26_u24lambda_u2d25 = surface;
                boolean bl8 = false;
                builder.addTarget($this$realStartPreview_u24lambda_u2d26_u24lambda_u2d25);
            }
            builder.addTarget(previewSurface);
            captureRequest = builder.build();
        }
        builder3 = captureRequest;
        boolean bl9 = false;
        bl4 = false;
        CaptureRequest.Builder captureRequest2 = builder3;
        boolean bl10 = false;
        if (captureRequest2 == null) {
            Logger.e$default(Logger.INSTANCE, TAG, "realStartPreview failed, captureRequest is null.", null, 4, null);
            this.postCameraStatus(new CameraStatus(-1, "capture request is null"));
            return;
        }
        cameraSession.setRepeatingRequest((CaptureRequest)captureRequest2, null, this.getCameraHandler());
        this.getMIsPreviewing().set(true);
        CameraRequest cameraRequest = this.getRequest();
        if (cameraRequest != null) {
            object = cameraRequest;
            boolean bl11 = false;
            bl2 = false;
            Object $this$realStartPreview_u24lambda_u2d28_u24lambda_u2d27 = object;
            boolean bl12 = false;
            this.postCameraStatus(new CameraStatus(1, new Pair((Object)((CameraRequest)$this$realStartPreview_u24lambda_u2d28_u24lambda_u2d27).getPreviewWidth(), (Object)((CameraRequest)$this$realStartPreview_u24lambda_u2d28_u24lambda_u2d27).getPreviewHeight()).toString()));
        }
        Logger.INSTANCE.i(TAG, "realStartPreview success!");
    }

    private final void closeSession() {
        CameraCaptureSession cameraCaptureSession;
        if (Utils.INSTANCE.getDebugCamera$libausbc_release() && this.getMIsPreviewing().get()) {
            Logger.INSTANCE.i(TAG, "closeSession success.");
        }
        this.getMIsPreviewing().set(false);
        SettableFuture<CameraCaptureSession> settableFuture = this.mCameraSessionFuture;
        if (settableFuture != null && (cameraCaptureSession = settableFuture.get(10L, TimeUnit.MILLISECONDS)) != null) {
            cameraCaptureSession.close();
        }
        if ((settableFuture = this.mCameraDeviceFuture) != null && (cameraCaptureSession = (CameraDevice)settableFuture.get(10L, TimeUnit.MILLISECONDS)) != null) {
            cameraCaptureSession.close();
        }
        this.mCameraSessionFuture = null;
        this.mCameraDeviceFuture = null;
    }

    private final void closeCamera() {
        ImageReader imageReader;
        if (Utils.INSTANCE.getDebugCamera$libausbc_release() && this.getMIsPreviewing().get()) {
            Logger.INSTANCE.i(TAG, "closeCamera success.");
        }
        if ((imageReader = this.mPreviewDataImageReader) != null) {
            imageReader.close();
        }
        this.mPreviewDataImageReader = null;
        imageReader = this.mJpegImageReader;
        if (imageReader != null) {
            imageReader.close();
        }
        this.mJpegImageReader = null;
        this.mCameraCharacteristicsFuture = null;
        this.postCameraStatus(new CameraStatus(2, null, 2, null));
    }

    private final CameraCharacteristics getCameraCharacteristics(String id) {
        Collection<CameraInfo> collection = this.getMCameraInfoMap().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"mCameraInfoMap.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CameraInfo it = (CameraInfo)element$iv;
            boolean bl = false;
            CameraV2Info cameraInfo = (CameraV2Info)it;
            if (!Intrinsics.areEqual((Object)cameraInfo.getCameraId(), (Object)id)) continue;
            return cameraInfo.getCameraCharacteristics();
        }
        return null;
    }

    private final Size getSuitableSize(CameraCharacteristics cameraCharacteristics, Class<?> clazz, int maxWidth, int maxHeight) {
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        StreamConfigurationMap streamConfigurationMap2 = streamConfigurationMap;
        Size[] supportedSizes = streamConfigurationMap2 == null ? null : streamConfigurationMap2.getOutputSizes(clazz);
        return this.getSuitableSize(supportedSizes, maxWidth, maxHeight);
    }

    /*
     * Unable to fully structure code
     */
    private final Size getSuitableSize(Size[] sizeList, int maxWidth, int maxHeight) {
        aspectRatio = (float)maxWidth / (float)maxHeight;
        var5_5 = sizeList;
        if (var5_5 != null) {
            $this$forEach$iv = var5_5;
            $i$f$forEach = false;
            var8_10 = $this$forEach$iv;
            var9_12 = var8_10.length;
            for (var10_13 = 0; var10_13 < var9_12; ++var10_13) {
                size = element$iv = var8_10[var10_13];
                $i$a$-forEach-Camera2Strategy$getSuitableSize$1 = false;
                w = size.getWidth();
                ratio = (float)w / (float)(h = size.getHeight());
                if (!(ratio == aspectRatio) || w > maxWidth || h > maxHeight) continue;
                return new Size(w, h);
            }
        }
        var5_5 = sizeList;
        var6_7 = false;
        var7_8 = false;
        if (var5_5 == null) ** GOTO lbl-1000
        var7_9 = var5_5;
        var8_11 = false;
        if (var7_9.length == 0) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        return v0 != false ? new Size(maxWidth, maxHeight) : new Size(sizeList[0].getWidth(), sizeList[0].getHeight());
    }

    private final int getJpegOrientation(CameraCharacteristics characteristics, int deviceOrientation) {
        Integer cameraFacing;
        int myDeviceOrientation = deviceOrientation;
        if (myDeviceOrientation == -1) {
            return 0;
        }
        Object object = characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        Intrinsics.checkNotNull((Object)object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION)!!");
        int sensorOrientation = ((Number)object2).intValue();
        Integer n = cameraFacing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
        boolean bl = false;
        boolean facingFront = n != null && n == 0;
        myDeviceOrientation = (myDeviceOrientation + 45) / 90 * 90;
        if (facingFront) {
            myDeviceOrientation = -myDeviceOrientation;
        }
        return (sensorOrientation + myDeviceOrientation + 360) % 360;
    }

    private static /* synthetic */ void getMJpegAvailableListener$annotations() {
    }

    private static final void captureImageInternal$lambda-5(Camera2Strategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError("Have no storage or camera permission.");
        }
    }

    private static final void captureImageInternal$lambda-6(Camera2Strategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError("camera2 init failed.");
        }
    }

    private static final void captureImageInternal$lambda-8(Camera2Strategy this$0, Exception $e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError($e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void mPreviewAvailableListener$lambda-33(Camera2Strategy this$0, ImageReader imageReader) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ImageReader imageReader2 = imageReader;
        Image image = imageReader2 == null ? null : imageReader2.acquireNextImage();
        imageReader2 = image;
        if (imageReader2 != null) {
            AutoCloseable autoCloseable = (AutoCloseable)imageReader2;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Image it = (Image)autoCloseable;
                boolean bl3 = false;
                CameraRequest request = this$0.getRequest();
                Object object = request;
                if (object == null) {
                    return;
                }
                object = this$0.mYUVData;
                if (object == null) {
                    return;
                }
                try {
                    int index;
                    int i;
                    Image.Plane[] planes = it.getPlanes();
                    ByteBuffer yBuffer = planes[0].getBuffer();
                    int yuv420pYLen = request.getPreviewWidth() * request.getPreviewHeight();
                    Intrinsics.checkNotNull((Object)this$0.mYUVData);
                    yBuffer.get(this$0.mYUVData, 0, yuv420pYLen);
                    ByteBuffer vBuffer = planes[2].getBuffer();
                    int vPixelStride = planes[2].getPixelStride();
                    IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)vBuffer.remaining())), (int)vPixelStride);
                    int n = intProgression.getFirst();
                    int n2 = intProgression.getLast();
                    int n3 = intProgression.getStep();
                    int n4 = 0;
                    if (n3 > 0 && n <= n2 || n3 < 0 && n2 <= n) {
                        do {
                            index = n4++;
                            i = n;
                            n += n3;
                            Intrinsics.checkNotNull((Object)this$0.mYUVData);
                            this$0.mYUVData[yuv420pYLen + 2 * index] = vBuffer.get(i);
                        } while (i != n2);
                    }
                    ByteBuffer uBuffer = planes[1].getBuffer();
                    int uPixelStride = planes[1].getPixelStride();
                    IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)uBuffer.remaining())), (int)uPixelStride);
                    n3 = intProgression2.getFirst();
                    n4 = intProgression2.getLast();
                    index = intProgression2.getStep();
                    i = 0;
                    if (index > 0 && n3 <= n4 || index < 0 && n4 <= n3) {
                        int i2;
                        do {
                            int index2 = i++;
                            i2 = n3;
                            n3 += index;
                            Intrinsics.checkNotNull((Object)this$0.mYUVData);
                            this$0.mYUVData[yuv420pYLen + (2 * index2 + 1)] = uBuffer.get(i2);
                        } while (i2 != n4);
                    }
                    Iterable $this$forEach$iv = this$0.getMPreviewDataCbList();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IPreviewDataCallBack cb = (IPreviewDataCallBack)element$iv;
                        boolean bl4 = false;
                        cb.onPreviewData(this$0.mYUVData, IPreviewDataCallBack.DataFormat.NV21);
                    }
                    it.close();
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    private static final void mJpegAvailableListener$lambda-38$lambda-37$lambda-36$lambda-34(Camera2Strategy this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onError("set path failed, save auto ");
        }
    }

    private static final void mJpegAvailableListener$lambda-38$lambda-37$lambda-36$lambda-35(Camera2Strategy this$0, String $path) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        ICaptureCallBack iCaptureCallBack = this$0.getMCaptureDataCb();
        if (iCaptureCallBack != null) {
            iCaptureCallBack.onComplete($path);
        }
    }

    private static final void mJpegAvailableListener$lambda-38$lambda-37$lambda-36(Camera2Strategy this$0, byte[] $jpegBufferArray) {
        ContentResolver contentResolver;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jpegBufferArray, (String)"$jpegBufferArray");
        String savePath = null;
        try {
            savePath = this$0.mImageSavePath.get(3L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logger.INSTANCE.e(TAG, "times out.", e);
            this$0.getMMainHandler().post(() -> Camera2Strategy.mJpegAvailableListener$lambda-38$lambda-37$lambda-36$lambda-34(this$0));
        }
        String date = this$0.getMDateFormat().format(System.currentTimeMillis());
        String string = savePath;
        String title = string == null ? Intrinsics.stringPlus((String)"IMG_JJCamera_", (Object)date) : string;
        String string2 = savePath;
        String displayName = string2 == null ? Intrinsics.stringPlus((String)title, (Object)".jpg") : string2;
        String string3 = savePath;
        String path = string3 == null ? this$0.getMCameraDir() + '/' + displayName : string3;
        FilesKt.writeBytes((File)new File(path), (byte[])$jpegBufferArray);
        ContentValues values = new ContentValues();
        values.put("title", title);
        values.put("_display_name", displayName);
        values.put("_data", path);
        values.put("datetaken", date);
        Context context = this$0.getContext();
        if (context != null && (contentResolver = context.getContentResolver()) != null) {
            contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        this$0.getMMainHandler().post(() -> Camera2Strategy.mJpegAvailableListener$lambda-38$lambda-37$lambda-36$lambda-35(this$0, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void mJpegAvailableListener$lambda-38(Camera2Strategy this$0, ImageReader imageReader) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ImageReader imageReader2 = imageReader;
        Image image = imageReader2 == null ? null : imageReader2.acquireNextImage();
        imageReader2 = image;
        if (imageReader2 != null) {
            AutoCloseable autoCloseable = (AutoCloseable)imageReader2;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Image it = (Image)autoCloseable;
                boolean bl3 = false;
                CaptureResult captureResult = this$0.mCaptureResults.take();
                ByteBuffer jpegBuffer = it.getPlanes()[0].getBuffer();
                byte[] jpegBufferArray = new byte[jpegBuffer.remaining()];
                jpegBuffer.get(jpegBufferArray);
                this$0.getMSaveImageExecutor().submit(() -> Camera2Strategy.mJpegAvailableListener$lambda-38$lambda-37$lambda-36(this$0, jpegBufferArray));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    public static final /* synthetic */ SettableFuture access$getMCameraDeviceFuture$p(Camera2Strategy $this) {
        return $this.mCameraDeviceFuture;
    }

    public static final /* synthetic */ SettableFuture access$getMCameraCharacteristicsFuture$p(Camera2Strategy $this) {
        return $this.mCameraCharacteristicsFuture;
    }

    public static final /* synthetic */ CameraCharacteristics access$getCameraCharacteristics(Camera2Strategy $this, String id) {
        return $this.getCameraCharacteristics(id);
    }

    public static final /* synthetic */ SettableFuture access$getMCameraSessionFuture$p(Camera2Strategy $this) {
        return $this.mCameraSessionFuture;
    }

    public static final /* synthetic */ BlockingQueue access$getMCaptureResults$p(Camera2Strategy $this) {
        return $this.mCaptureResults;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jiangdg/ausbc/camera/Camera2Strategy$Companion;", "", "()V", "TAG", "", "libausbc_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

