/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.encoder.biz;

import android.annotation.TargetApi;
import android.media.AudioRecord;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import com.serenegiant.usb.encoder.biz.Mp4MediaMuxer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

public class AACEncodeConsumer
extends Thread {
    private static final boolean DEBUG = false;
    private static final String TAG = "TMPU";
    private static final String MIME_TYPE = "audio/mp4a-latm";
    private static final long TIMES_OUT = 1000L;
    private static final int SAMPLE_RATE = 8000;
    private static final int BIT_RATE = 16000;
    private static final int BUFFER_SIZE = 1920;
    private int outChannel = 1;
    private int bitRateForLame = 32;
    private int qaulityDegree = 7;
    private int bufferSizeInBytes;
    private AudioRecord mAudioRecord;
    private MediaCodec mAudioEncoder;
    private OnAACEncodeResultListener listener;
    private int mSamplingRateIndex = 0;
    private boolean isEncoderStart = false;
    private boolean isRecMp3 = false;
    private boolean isExit = false;
    private long prevPresentationTimes = 0L;
    private WeakReference<Mp4MediaMuxer> mMuxerRef;
    private MediaFormat newFormat;
    public static final int[] AUDIO_SAMPLING_RATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};
    private FileOutputStream fops;

    public AACEncodeConsumer() {
        for (int i = 0; i < AUDIO_SAMPLING_RATES.length; ++i) {
            if (AUDIO_SAMPLING_RATES[i] != 8000) continue;
            this.mSamplingRateIndex = i;
            break;
        }
    }

    public void setOnAACEncodeResultListener(OnAACEncodeResultListener listener) {
        this.listener = listener;
    }

    public void exit() {
        this.isExit = true;
    }

    public synchronized void setTmpuMuxer(Mp4MediaMuxer mMuxer) {
        this.mMuxerRef = new WeakReference<Mp4MediaMuxer>(mMuxer);
        Mp4MediaMuxer muxer = (Mp4MediaMuxer)this.mMuxerRef.get();
        if (muxer != null && this.newFormat != null) {
            muxer.addTrack(this.newFormat, false);
        }
    }

    @Override
    public void run() {
        if (!this.isEncoderStart) {
            this.initAudioRecord();
            this.initMediaCodec();
        }
        byte[] mp3Buffer = new byte[1024];
        while (!this.isExit) {
            byte[] audioBuffer = new byte[2048];
            int readBytes = this.mAudioRecord.read(audioBuffer, 0, 1920);
            if (readBytes <= 0) continue;
            this.encodeBytes(audioBuffer, readBytes);
        }
        this.stopMediaCodec();
        this.stopAudioRecord();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    private void encodeBytes(byte[] audioBuf, int readBytes) {
        ByteBuffer[] inputBuffers = this.mAudioEncoder.getInputBuffers();
        ByteBuffer[] outputBuffers = this.mAudioEncoder.getOutputBuffers();
        int inputBufferIndex = this.mAudioEncoder.dequeueInputBuffer(1000L);
        if (inputBufferIndex >= 0) {
            ByteBuffer inputBuffer = null;
            inputBuffer = !this.isLollipop() ? inputBuffers[inputBufferIndex] : this.mAudioEncoder.getInputBuffer(inputBufferIndex);
            if (audioBuf == null || readBytes <= 0) {
                this.mAudioEncoder.queueInputBuffer(inputBufferIndex, 0, 0, this.getPTSUs(), 4);
            } else {
                inputBuffer.clear();
                inputBuffer.put(audioBuf);
                this.mAudioEncoder.queueInputBuffer(inputBufferIndex, 0, readBytes, this.getPTSUs(), 0);
            }
        }
        MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
        int outputBufferIndex = -1;
        do {
            if ((outputBufferIndex = this.mAudioEncoder.dequeueOutputBuffer(mBufferInfo, 1000L)) == -1) continue;
            if (outputBufferIndex == -3) {
                if (this.isLollipop()) continue;
                outputBuffers = this.mAudioEncoder.getOutputBuffers();
                continue;
            }
            if (outputBufferIndex == -2) {
                AACEncodeConsumer aACEncodeConsumer = this;
                synchronized (aACEncodeConsumer) {
                    Mp4MediaMuxer muxer;
                    this.newFormat = this.mAudioEncoder.getOutputFormat();
                    if (this.mMuxerRef != null && (muxer = (Mp4MediaMuxer)this.mMuxerRef.get()) != null) {
                        muxer.addTrack(this.newFormat, false);
                    }
                }
            } else {
                if ((mBufferInfo.flags & 2) != 0) {
                    mBufferInfo.size = 0;
                }
                if ((mBufferInfo.flags & 4) != 0) break;
                ByteBuffer mBuffer = ByteBuffer.allocate(10240);
                ByteBuffer outputBuffer = null;
                outputBuffer = !this.isLollipop() ? outputBuffers[outputBufferIndex] : this.mAudioEncoder.getOutputBuffer(outputBufferIndex);
                if (mBufferInfo.size != 0) {
                    Mp4MediaMuxer muxer;
                    if (outputBuffer == null) {
                        throw new RuntimeException("encodecOutputBuffer" + outputBufferIndex + "was null");
                    }
                    if (this.mMuxerRef != null && (muxer = (Mp4MediaMuxer)this.mMuxerRef.get()) != null) {
                        muxer.pumpStream(outputBuffer, mBufferInfo, false);
                    }
                    mBuffer.clear();
                    outputBuffer.get(mBuffer.array(), 7, mBufferInfo.size);
                    outputBuffer.clear();
                    mBuffer.position(7 + mBufferInfo.size);
                    this.addADTStoPacket(mBuffer.array(), mBufferInfo.size + 7);
                    mBuffer.flip();
                    if (this.listener != null) {
                        Log.i((String)TAG, (String)"----->\u5f97\u5230aac\u6570\u636e\u6d41<-----");
                        this.listener.onEncodeResult(mBuffer.array(), 0, mBufferInfo.size + 7, mBufferInfo.presentationTimeUs / 1000L);
                    }
                }
                this.mAudioEncoder.releaseOutputBuffer(outputBufferIndex, false);
            }
        } while (outputBufferIndex >= 0);
    }

    private void initAudioRecord() {
        Process.setThreadPriority((int)-16);
        int bufferSize = AudioRecord.getMinBufferSize((int)8000, (int)16, (int)2);
        this.mAudioRecord = new AudioRecord(1, 8000, 16, 2, bufferSize);
        this.mAudioRecord.startRecording();
    }

    private void initMediaCodec() {
        MediaCodecInfo mCodecInfo = this.selectSupportCodec(MIME_TYPE);
        if (mCodecInfo == null) {
            Log.e((String)TAG, (String)"\u7f16\u7801\u5668\u4e0d\u652f\u6301audio/mp4a-latm\u7c7b\u578b");
            return;
        }
        try {
            this.mAudioEncoder = MediaCodec.createByCodecName((String)mCodecInfo.getName());
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("\u521b\u5efa\u7f16\u7801\u5668\u5931\u8d25" + e.getMessage()));
            e.printStackTrace();
        }
        MediaFormat format = new MediaFormat();
        format.setString("mime", MIME_TYPE);
        format.setInteger("bitrate", 16000);
        format.setInteger("channel-count", 1);
        format.setInteger("sample-rate", 8000);
        format.setInteger("aac-profile", 2);
        format.setInteger("max-input-size", 1920);
        this.mAudioEncoder.configure(format, null, null, 1);
        this.mAudioEncoder.start();
        this.isEncoderStart = true;
    }

    private void stopAudioRecord() {
        if (this.mAudioRecord != null) {
            this.mAudioRecord.stop();
            this.mAudioRecord.release();
            this.mAudioRecord = null;
        }
    }

    private void stopMediaCodec() {
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.stop();
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
        }
        this.isEncoderStart = false;
    }

    private boolean isLollipop() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private boolean isKITKAT() {
        return Build.VERSION.SDK_INT <= 19;
    }

    private long getPTSUs() {
        long result = System.nanoTime() / 1000L;
        if (result < this.prevPresentationTimes) {
            result = this.prevPresentationTimes - result + result;
        }
        return result;
    }

    private MediaCodecInfo selectSupportCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                return codecInfo;
            }
        }
        return null;
    }

    private void addADTStoPacket(byte[] packet, int packetLen) {
        packet[0] = -1;
        packet[1] = -15;
        packet[2] = (byte)(64 + (this.mSamplingRateIndex << 2) + 0);
        packet[3] = (byte)(64 + (packetLen >> 11));
        packet[4] = (byte)((packetLen & 0x7FF) >> 3);
        packet[5] = (byte)(((packetLen & 7) << 5) + 31);
        packet[6] = -4;
    }

    private short[] transferByte2Short(byte[] data, int readBytes) {
        int shortLen = readBytes / 2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, readBytes);
        ShortBuffer shortBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
        short[] shortData = new short[shortLen];
        shortBuffer.get(shortData, 0, shortLen);
        return shortData;
    }

    public static interface OnAACEncodeResultListener {
        public void onEncodeResult(byte[] var1, int var2, int var3, long var4);
    }
}

