/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.encoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Environment;
import android.util.Log;
import com.jiangdg.usbcamera.utils.FileUtils;
import com.serenegiant.usb.encoder.MediaMuxerWrapper;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public abstract class MediaEncoder
implements Runnable {
    private static final boolean DEBUG = true;
    private static final String TAG = "MediaEncoder";
    public static final int TYPE_AUDIO = 0;
    public static final int TYPE_VIDEO = 1;
    protected static final int TIMEOUT_USEC = 10000;
    protected static final int MSG_FRAME_AVAILABLE = 1;
    protected static final int MSG_STOP_RECORDING = 9;
    private long lastPush;
    private long millisPerframe;
    private boolean isExit;
    protected final Object mSync = new Object();
    protected volatile boolean mIsCapturing;
    private int mRequestDrain;
    protected volatile boolean mRequestStop;
    protected boolean mIsEOS;
    protected boolean mMuxerStarted;
    protected int mTrackIndex;
    protected MediaCodec mMediaCodec;
    protected final WeakReference<MediaMuxerWrapper> mWeakMuxer;
    private MediaCodec.BufferInfo mBufferInfo;
    protected final MediaEncoderListener mListener;
    public static final int[] AUDIO_SAMPLING_RATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};
    ByteBuffer mBuffer = ByteBuffer.allocate(10240);
    private long prevOutputPTSUs = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEncoder(MediaMuxerWrapper muxer, MediaEncoderListener listener) {
        if (listener == null) {
            throw new NullPointerException("MediaEncoderListener is null");
        }
        if (muxer == null) {
            throw new NullPointerException("MediaMuxerWrapper is null");
        }
        this.mWeakMuxer = new WeakReference<MediaMuxerWrapper>(muxer);
        muxer.addEncoder(this);
        this.mListener = listener;
        Object object = this.mSync;
        synchronized (object) {
            this.mBufferInfo = new MediaCodec.BufferInfo();
            new Thread((Runnable)this, this.getClass().getSimpleName()).start();
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getOutputPath() {
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        return muxer != null ? muxer.getOutputPath() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return false;
            }
            ++this.mRequestDrain;
            this.mSync.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Object object2 = this.mSync;
        synchronized (object2) {
            this.mRequestStop = false;
            this.mRequestDrain = 0;
            this.mSync.notify();
        }
        boolean isRunning = true;
        FileUtils.createfile(Environment.getExternalStorageDirectory().getAbsolutePath() + "/test222.h264");
        while (true) {
            boolean localRequestDrain;
            boolean localRequestStop;
            object = this.mSync;
            synchronized (object) {
                localRequestStop = this.mRequestStop;
                boolean bl = localRequestDrain = this.mRequestDrain > 0;
                if (localRequestDrain) {
                    --this.mRequestDrain;
                }
            }
            if (localRequestStop) {
                this.drain();
                this.signalEndOfInputStream();
                this.drain();
                this.release();
                break;
            }
            if (localRequestDrain) {
                this.drain();
                continue;
            }
            object = this.mSync;
            synchronized (object) {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
            this.mRequestStop = true;
            this.mIsCapturing = false;
        }
        FileUtils.releaseFile();
    }

    abstract void prepare() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startRecording() {
        Log.v((String)TAG, (String)"startRecording");
        Object object = this.mSync;
        synchronized (object) {
            this.mIsCapturing = true;
            this.mRequestStop = false;
            this.isExit = false;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopRecording() {
        Log.v((String)TAG, (String)"stopRecording");
        Object object = this.mSync;
        synchronized (object) {
            if (!this.mIsCapturing || this.mRequestStop) {
                return;
            }
            this.mRequestStop = true;
            this.isExit = true;
            this.mSync.notifyAll();
        }
    }

    protected void release() {
        MediaMuxerWrapper muxer;
        Log.d((String)TAG, (String)"release:");
        try {
            this.mListener.onStopped(this);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"failed onStopped", (Throwable)e);
        }
        this.mIsCapturing = false;
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed releasing MediaCodec", (Throwable)e);
            }
        }
        if (this.mMuxerStarted && (muxer = (MediaMuxerWrapper)this.mWeakMuxer.get()) != null) {
            try {
                muxer.stop();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed stopping muxer", (Throwable)e);
            }
        }
        this.mBufferInfo = null;
    }

    protected void signalEndOfInputStream() {
        Log.d((String)TAG, (String)"sending EOS to encoder");
        this.encode((byte[])null, 0, this.getPTSUs());
    }

    protected void encode(byte[] buffer, int length, long presentationTimeUs) {
        if (!this.mIsCapturing) {
            return;
        }
        int ix = 0;
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing && ix < length) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                int sz = inputBuffer.remaining();
                int n = sz = ix + sz < length ? sz : length - ix;
                if (sz > 0 && buffer != null) {
                    inputBuffer.put(buffer, ix, sz);
                }
                ix += sz;
                if (length <= 0) {
                    this.mIsEOS = true;
                    Log.i((String)TAG, (String)"send BUFFER_FLAG_END_OF_STREAM");
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, sz, presentationTimeUs, 0);
                continue;
            }
            if (inputBufferIndex != -1) continue;
        }
    }

    protected void encode(ByteBuffer yuvBuffer, int len) {
        if (!this.mIsCapturing) {
            return;
        }
        try {
            long time;
            if (this.lastPush == 0L) {
                this.lastPush = System.currentTimeMillis();
            }
            if ((time = System.currentTimeMillis() - this.lastPush) >= 0L && (time = this.millisPerframe - time) > 0L) {
                Thread.sleep(time / 2L);
            }
            ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
            int bufferIndex = -1;
            try {
                bufferIndex = this.mMediaCodec.dequeueInputBuffer(0L);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            if (bufferIndex >= 0) {
                ByteBuffer mBuffer = Build.VERSION.SDK_INT >= 21 ? this.mMediaCodec.getInputBuffer(bufferIndex) : inputBuffers[bufferIndex];
                byte[] yuvData = new byte[yuvBuffer.capacity()];
                yuvBuffer.get(yuvData);
                mBuffer.clear();
                mBuffer.put(yuvData);
                mBuffer.clear();
                this.mMediaCodec.queueInputBuffer(bufferIndex, 0, yuvData.length, System.nanoTime() / 1000L, 1);
            }
            this.lastPush = System.currentTimeMillis();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        if (!this.mIsCapturing) {
            return;
        }
        int ix = 0;
        ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
        while (this.mIsCapturing && ix < length) {
            int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
            if (inputBufferIndex >= 0) {
                ByteBuffer inputBuffer = inputBuffers[inputBufferIndex];
                inputBuffer.clear();
                int sz = inputBuffer.remaining();
                int n = sz = ix + sz < length ? sz : length - ix;
                if (sz > 0 && buffer != null) {
                    buffer.position(ix + sz);
                    buffer.flip();
                    inputBuffer.put(buffer);
                }
                ix += sz;
                if (length <= 0) {
                    this.mIsEOS = true;
                    Log.i((String)TAG, (String)"send BUFFER_FLAG_END_OF_STREAM");
                    this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                    break;
                }
                this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, sz, presentationTimeUs, 0);
                continue;
            }
            if (inputBufferIndex != -1) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drain() {
        if (this.mMediaCodec == null) {
            return;
        }
        ByteBuffer[] encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
        int count = 0;
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        if (muxer == null) {
            Log.w((String)TAG, (String)"muxer is unexpectedly null");
            return;
        }
        byte[] mPpsSps = new byte[]{};
        byte[] h264 = new byte[307200];
        while (this.mIsCapturing) {
            int encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
            if (encoderStatus == -1) {
                if (this.mIsEOS || ++count <= 5) continue;
                break;
            }
            if (encoderStatus == -3) {
                encoderOutputBuffers = this.mMediaCodec.getOutputBuffers();
                continue;
            }
            if (encoderStatus == -2) {
                if (this.mMuxerStarted) {
                    throw new RuntimeException("format changed twice");
                }
                MediaFormat format = this.mMediaCodec.getOutputFormat();
                this.mTrackIndex = muxer.addTrack(format);
                this.mMuxerStarted = true;
                if (muxer.start()) continue;
                MediaMuxerWrapper mediaMuxerWrapper = muxer;
                synchronized (mediaMuxerWrapper) {
                    while (!muxer.isStarted()) {
                        try {
                            muxer.wait(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    continue;
                }
            }
            if (encoderStatus < 0) {
                Log.w((String)TAG, (String)("drain:unexpected result from encoder#dequeueOutputBuffer: " + encoderStatus));
                continue;
            }
            ByteBuffer encodedData = Build.VERSION.SDK_INT >= 21 ? this.mMediaCodec.getOutputBuffer(encoderStatus) : encoderOutputBuffers[encoderStatus];
            encodedData.position(this.mBufferInfo.offset);
            encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
            if (encodedData == null) {
                throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
            }
            if ((this.mBufferInfo.flags & 2) != 0) {
                Log.d((String)TAG, (String)"drain:BUFFER_FLAG_CODEC_CONFIG");
                this.mBufferInfo.size = 0;
            }
            if ((this.mBufferInfo.flags & 4) != 0) {
                this.mIsCapturing = false;
                this.mMuxerStarted = false;
                break;
            }
            if (this.mBufferInfo.size != 0) {
                count = 0;
                if (!this.mMuxerStarted) {
                    throw new RuntimeException("drain:muxer hasn't started");
                }
                this.mBufferInfo.presentationTimeUs = this.getPTSUs();
                muxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                this.prevOutputPTSUs = this.mBufferInfo.presentationTimeUs;
                if (this.mTrackIndex == 0) {
                    encodedData.position(this.mBufferInfo.offset);
                    encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                    boolean sync = false;
                    if ((this.mBufferInfo.flags & 2) != 0) {
                        boolean bl = sync = (this.mBufferInfo.flags & 1) != 0;
                        if (!sync) {
                            byte[] temp = new byte[this.mBufferInfo.size];
                            encodedData.get(temp);
                            mPpsSps = temp;
                            this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
                            continue;
                        }
                        mPpsSps = new byte[]{};
                    }
                    sync |= (this.mBufferInfo.flags & 1) != 0;
                    int len = mPpsSps.length + this.mBufferInfo.size;
                    if (len > h264.length) {
                        h264 = new byte[len];
                    }
                    if (sync) {
                        System.arraycopy(mPpsSps, 0, h264, 0, mPpsSps.length);
                        encodedData.get(h264, mPpsSps.length, this.mBufferInfo.size);
                        if (this.mListener != null) {
                            this.mListener.onEncodeResult(h264, 0, mPpsSps.length + this.mBufferInfo.size, this.mBufferInfo.presentationTimeUs / 1000L, 1);
                        }
                        FileUtils.putFileStream(h264, 0, mPpsSps.length + this.mBufferInfo.size);
                    } else {
                        encodedData.get(h264, 0, this.mBufferInfo.size);
                        if (this.mListener != null) {
                            this.mListener.onEncodeResult(h264, 0, this.mBufferInfo.size, this.mBufferInfo.presentationTimeUs / 1000L, 1);
                        }
                        FileUtils.putFileStream(h264, 0, this.mBufferInfo.size);
                    }
                } else if (this.mTrackIndex == 1) {
                    this.mBuffer.clear();
                    encodedData.get(this.mBuffer.array(), 7, this.mBufferInfo.size);
                    encodedData.clear();
                    this.mBuffer.position(7 + this.mBufferInfo.size);
                    this.addADTStoPacket(this.mBuffer.array(), this.mBufferInfo.size + 7);
                    this.mBuffer.flip();
                    if (this.mListener != null) {
                        this.mListener.onEncodeResult(this.mBuffer.array(), 0, this.mBufferInfo.size + 7, this.mBufferInfo.presentationTimeUs / 1000L, 0);
                    }
                }
            }
            this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
        }
    }

    private void addADTStoPacket(byte[] packet, int packetLen) {
        packet[0] = -1;
        packet[1] = -15;
        packet[2] = (byte)(64 + (this.getSamplingRateIndex() << 2) + 0);
        packet[3] = (byte)(64 + (packetLen >> 11));
        packet[4] = (byte)((packetLen & 0x7FF) >> 3);
        packet[5] = (byte)(((packetLen & 7) << 5) + 31);
        packet[6] = -4;
    }

    private int getSamplingRateIndex() {
        int mSamplingRateIndex = -1;
        for (int i = 0; i < AUDIO_SAMPLING_RATES.length; ++i) {
            if (AUDIO_SAMPLING_RATES[i] != 44100) continue;
            mSamplingRateIndex = i;
            break;
        }
        return mSamplingRateIndex;
    }

    protected long getPTSUs() {
        long result = System.nanoTime() / 1000L;
        if (result < this.prevOutputPTSUs) {
            result = this.prevOutputPTSUs - result + result;
        }
        return result;
    }

    public static interface MediaEncoderListener {
        public void onPrepared(MediaEncoder var1);

        public void onStopped(MediaEncoder var1);

        public void onEncodeResult(byte[] var1, int var2, int var3, long var4, int var6);
    }
}

