/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.usb.UsbDevice;
import android.media.MediaScannerConnection;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UVCCamera;
import com.serenegiant.usb.encoder.MediaEncoder;
import com.serenegiant.usb.encoder.MediaMuxerWrapper;
import com.serenegiant.usb.encoder.MediaSurfaceEncoder;
import com.serenegiant.usb.encoder.MediaVideoBufferEncoder;
import com.serenegiant.usb.encoder.MediaVideoEncoder;
import com.serenegiant.usb.encoder.RecordParams;
import com.serenegiant.usb.encoder.biz.AACEncodeConsumer;
import com.serenegiant.usb.encoder.biz.H264EncodeConsumer;
import com.serenegiant.usb.encoder.biz.Mp4MediaMuxer;
import com.serenegiant.usb.widget.CameraViewInterface;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractUVCCameraHandler
extends Handler {
    private static final boolean DEBUG = true;
    private static final String TAG = "AbsUVCCameraHandler";
    public static OnEncodeResultListener mListener;
    public static OnPreViewResultListener mPreviewListener;
    public static OnCaptureListener mCaptureListener;
    private static final int MSG_OPEN = 0;
    private static final int MSG_CLOSE = 1;
    private static final int MSG_PREVIEW_START = 2;
    private static final int MSG_PREVIEW_STOP = 3;
    private static final int MSG_CAPTURE_STILL = 4;
    private static final int MSG_CAPTURE_START = 5;
    private static final int MSG_CAPTURE_STOP = 6;
    private static final int MSG_MEDIA_UPDATE = 7;
    private static final int MSG_RELEASE = 9;
    private static final int MSG_CAMERA_FOUCS = 10;
    private final WeakReference<CameraThread> mWeakThread;
    private volatile boolean mReleased;
    protected static boolean isCaptureStill;

    protected AbstractUVCCameraHandler(CameraThread thread) {
        this.mWeakThread = new WeakReference<CameraThread>(thread);
    }

    public int getWidth() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null ? thread.getWidth() : 0;
    }

    public int getHeight() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null ? thread.getHeight() : 0;
    }

    public boolean isOpened() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.isCameraOpened();
    }

    public boolean isPreviewing() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.isPreviewing();
    }

    public boolean isRecording() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.isRecording();
    }

    public boolean isEqual(UsbDevice device) {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.isEqual(device);
    }

    protected boolean isCameraThread() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.getId() == Thread.currentThread().getId();
    }

    protected boolean isReleased() {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return this.mReleased || thread == null;
    }

    protected void checkReleased() {
        if (this.isReleased()) {
            throw new IllegalStateException("already released");
        }
    }

    public void open(USBMonitor.UsbControlBlock ctrlBlock) {
        this.checkReleased();
        this.sendMessage(this.obtainMessage(0, ctrlBlock));
    }

    public void close() {
        Log.v((String)TAG, (String)"close:");
        if (this.isOpened()) {
            this.stopPreview();
            this.sendEmptyMessage(1);
        }
        Log.v((String)TAG, (String)"close:finished");
    }

    public void resize(int width, int height) {
        this.checkReleased();
        throw new UnsupportedOperationException("does not support now");
    }

    public void startPreview(Object surface) {
        this.checkReleased();
        if (!(surface instanceof SurfaceHolder || surface instanceof Surface || surface instanceof SurfaceTexture)) {
            throw new IllegalArgumentException("surface should be one of SurfaceHolder, Surface or SurfaceTexture: " + surface);
        }
        this.sendMessage(this.obtainMessage(2, surface));
    }

    public void setOnPreViewResultListener(OnPreViewResultListener listener) {
        mPreviewListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPreview() {
        Log.v((String)TAG, (String)"stopPreview:");
        this.removeMessages(2);
        if (this.isRecording()) {
            this.stopRecording();
        }
        if (this.isPreviewing()) {
            CameraThread thread = (CameraThread)this.mWeakThread.get();
            if (thread == null) {
                return;
            }
            Object object = thread.mSync;
            synchronized (object) {
                this.sendEmptyMessage(3);
                if (!this.isCameraThread()) {
                    try {
                        thread.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        Log.v((String)TAG, (String)"stopPreview:finished");
    }

    public void captureStill(String path, OnCaptureListener listener) {
        mCaptureListener = listener;
        this.checkReleased();
        this.sendMessage(this.obtainMessage(4, path));
        isCaptureStill = true;
    }

    public void startRecording(RecordParams params, OnEncodeResultListener listener) {
        mListener = listener;
        this.checkReleased();
        this.sendMessage(this.obtainMessage(5, params));
    }

    public void stopRecording() {
        this.sendEmptyMessage(6);
    }

    public void startCameraFoucs() {
        this.sendEmptyMessage(10);
    }

    public List<Size> getSupportedPreviewSizes() {
        return ((CameraThread)this.mWeakThread.get()).getSupportedSizes();
    }

    public void release() {
        this.mReleased = true;
        this.close();
        this.sendEmptyMessage(9);
    }

    public void addCallback(CameraCallback callback) {
        CameraThread thread;
        this.checkReleased();
        if (!this.mReleased && callback != null && (thread = (CameraThread)this.mWeakThread.get()) != null) {
            thread.mCallbacks.add(callback);
        }
    }

    public void removeCallback(CameraCallback callback) {
        CameraThread thread;
        if (callback != null && (thread = (CameraThread)this.mWeakThread.get()) != null) {
            thread.mCallbacks.remove(callback);
        }
    }

    protected void updateMedia(String path) {
        this.sendMessage(this.obtainMessage(7, path));
    }

    public boolean checkSupportFlag(long flag) {
        this.checkReleased();
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        return thread != null && thread.mUVCCamera != null && thread.mUVCCamera.checkSupportFlag(flag);
    }

    public int getValue(int flag) {
        UVCCamera camera;
        this.checkReleased();
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        UVCCamera uVCCamera = camera = thread != null ? thread.mUVCCamera : null;
        if (camera != null) {
            if (flag == -2147483647) {
                return camera.getBrightness();
            }
            if (flag == -2147483646) {
                return camera.getContrast();
            }
        }
        throw new IllegalStateException();
    }

    public int setValue(int flag, int value) {
        UVCCamera camera;
        this.checkReleased();
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        UVCCamera uVCCamera = camera = thread != null ? thread.mUVCCamera : null;
        if (camera != null) {
            if (flag == -2147483647) {
                camera.setBrightness(value);
                return camera.getBrightness();
            }
            if (flag == -2147483646) {
                camera.setContrast(value);
                return camera.getContrast();
            }
        }
        throw new IllegalStateException();
    }

    public int resetValue(int flag) {
        UVCCamera camera;
        this.checkReleased();
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        UVCCamera uVCCamera = camera = thread != null ? thread.mUVCCamera : null;
        if (camera != null) {
            if (flag == -2147483647) {
                camera.resetBrightness();
                return camera.getBrightness();
            }
            if (flag == -2147483646) {
                camera.resetContrast();
                return camera.getContrast();
            }
        }
        throw new IllegalStateException();
    }

    public void handleMessage(Message msg) {
        CameraThread thread = (CameraThread)this.mWeakThread.get();
        if (thread == null) {
            return;
        }
        switch (msg.what) {
            case 0: {
                thread.handleOpen((USBMonitor.UsbControlBlock)msg.obj);
                break;
            }
            case 1: {
                thread.handleClose();
                break;
            }
            case 2: {
                thread.handleStartPreview(msg.obj);
                break;
            }
            case 3: {
                thread.handleStopPreview();
                break;
            }
            case 4: {
                thread.handleStillPicture((String)msg.obj);
                break;
            }
            case 5: {
                thread.handleStartPusher((RecordParams)msg.obj);
                break;
            }
            case 6: {
                thread.handleStopPusher();
                break;
            }
            case 7: {
                thread.handleUpdateMedia((String)msg.obj);
                break;
            }
            case 9: {
                thread.handleRelease();
                break;
            }
            case 10: {
                thread.handleCameraFoucs();
                break;
            }
            default: {
                throw new RuntimeException("unsupported message:what=" + msg.what);
            }
        }
    }

    public static final class CameraThread
    extends Thread {
        private static final String TAG_THREAD = "CameraThread";
        private final Object mSync = new Object();
        private final Class<? extends AbstractUVCCameraHandler> mHandlerClass;
        private final WeakReference<Activity> mWeakParent;
        private final WeakReference<CameraViewInterface> mWeakCameraView;
        private final int mEncoderType;
        private final Set<CameraCallback> mCallbacks = new CopyOnWriteArraySet<CameraCallback>();
        private int mWidth;
        private int mHeight;
        private int mPreviewMode;
        private float mBandwidthFactor;
        private boolean mIsPreviewing;
        private boolean mIsRecording;
        private AbstractUVCCameraHandler mHandler;
        private UVCCamera mUVCCamera;
        private MediaVideoBufferEncoder mVideoEncoder;
        private Mp4MediaMuxer mMuxer;
        private boolean isPushing;
        private String videoPath;
        private AACEncodeConsumer mAacConsumer;
        private H264EncodeConsumer mH264Consumer;
        private String picPath = null;
        private final IFrameCallback mIFrameCallback = new IFrameCallback(){

            @Override
            public void onFrame(ByteBuffer frame) {
                int len = frame.capacity();
                final byte[] yuv = new byte[len];
                frame.get(yuv);
                if (mPreviewListener != null) {
                    mPreviewListener.onPreviewResult(yuv);
                }
                if (isCaptureStill && !TextUtils.isEmpty((CharSequence)picPath)) {
                    isCaptureStill = false;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            this.saveYuv2Jpeg(picPath, yuv);
                        }
                    }).start();
                }
                if (mH264Consumer != null) {
                    mH264Consumer.setRawYuv(yuv, mWidth, mHeight);
                }
            }
        };
        private final MediaEncoder.MediaEncoderListener mMediaEncoderListener = new MediaEncoder.MediaEncoderListener(){

            @Override
            public void onPrepared(MediaEncoder encoder) {
                Log.v((String)AbstractUVCCameraHandler.TAG, (String)("onPrepared:encoder=" + encoder));
                mIsRecording = true;
                if (encoder instanceof MediaVideoEncoder) {
                    try {
                        ((CameraViewInterface)mWeakCameraView.get()).setVideoEncoder((MediaVideoEncoder)encoder);
                    }
                    catch (Exception e) {
                        Log.e((String)AbstractUVCCameraHandler.TAG, (String)"onPrepared:", (Throwable)e);
                    }
                }
                if (encoder instanceof MediaSurfaceEncoder) {
                    try {
                        ((CameraViewInterface)mWeakCameraView.get()).setVideoEncoder((MediaSurfaceEncoder)encoder);
                        mUVCCamera.startCapture(((MediaSurfaceEncoder)encoder).getInputSurface());
                    }
                    catch (Exception e) {
                        Log.e((String)AbstractUVCCameraHandler.TAG, (String)"onPrepared:", (Throwable)e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @TargetApi(value=17)
            public void onStopped(MediaEncoder encoder) {
                Log.v((String)CameraThread.TAG_THREAD, (String)("onStopped:encoder=" + encoder));
                if (encoder instanceof MediaVideoEncoder || encoder instanceof MediaSurfaceEncoder) {
                    try {
                        mIsRecording = false;
                        Activity parent = (Activity)mWeakParent.get();
                        ((CameraViewInterface)mWeakCameraView.get()).setVideoEncoder(null);
                        Object object = mSync;
                        synchronized (object) {
                            if (mUVCCamera != null) {
                                mUVCCamera.stopCapture();
                            }
                        }
                        String path = encoder.getOutputPath();
                        if (!TextUtils.isEmpty((CharSequence)path)) {
                            mHandler.sendMessageDelayed(mHandler.obtainMessage(7, path), 1000L);
                        } else {
                            boolean released;
                            boolean bl = released = mHandler == null || mHandler.mReleased;
                            if (released || parent == null || parent.isDestroyed()) {
                                this.handleRelease();
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)AbstractUVCCameraHandler.TAG, (String)"onPrepared:", (Throwable)e);
                    }
                }
            }

            @Override
            public void onEncodeResult(byte[] data, int offset, int length, long timestamp, int type) {
                if (mListener != null) {
                    mListener.onEncodeResult(data, offset, length, timestamp, type);
                }
            }
        };

        CameraThread(Class<? extends AbstractUVCCameraHandler> clazz, Activity parent, CameraViewInterface cameraView, int encoderType, int width, int height, int format, float bandwidthFactor) {
            super(TAG_THREAD);
            this.mHandlerClass = clazz;
            this.mEncoderType = encoderType;
            this.mWidth = width;
            this.mHeight = height;
            this.mPreviewMode = format;
            this.mBandwidthFactor = bandwidthFactor;
            this.mWeakParent = new WeakReference<Activity>(parent);
            this.mWeakCameraView = new WeakReference<CameraViewInterface>(cameraView);
        }

        protected void finalize() throws Throwable {
            Log.i((String)AbstractUVCCameraHandler.TAG, (String)"CameraThread#finalize");
            super.finalize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AbstractUVCCameraHandler getHandler() {
            Log.v((String)TAG_THREAD, (String)"getHandler:");
            Object object = this.mSync;
            synchronized (object) {
                if (this.mHandler == null) {
                    try {
                        this.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return this.mHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getWidth() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mWidth;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getHeight() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mHeight;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCameraOpened() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mUVCCamera != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPreviewing() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mUVCCamera != null && this.mIsPreviewing;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRecording() {
            Object object = this.mSync;
            synchronized (object) {
                return this.mUVCCamera != null && this.mH264Consumer != null;
            }
        }

        public boolean isEqual(UsbDevice device) {
            return this.mUVCCamera != null && this.mUVCCamera.getDevice() != null && this.mUVCCamera.getDevice().equals((Object)device);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleOpen(USBMonitor.UsbControlBlock ctrlBlock) {
            Log.v((String)TAG_THREAD, (String)"handleOpen:");
            this.handleClose();
            try {
                UVCCamera camera = new UVCCamera();
                camera.open(ctrlBlock);
                Object object = this.mSync;
                synchronized (object) {
                    this.mUVCCamera = camera;
                }
                this.callOnOpen();
            }
            catch (Exception e) {
                this.callOnError(e);
            }
            Log.i((String)AbstractUVCCameraHandler.TAG, (String)("supportedSize:" + (this.mUVCCamera != null ? this.mUVCCamera.getSupportedSize() : null)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleClose() {
            UVCCamera camera;
            Log.v((String)TAG_THREAD, (String)"handleClose:");
            this.handleStopPusher();
            Object object = this.mSync;
            synchronized (object) {
                camera = this.mUVCCamera;
                this.mUVCCamera = null;
            }
            if (camera != null) {
                camera.stopPreview();
                camera.destroy();
                this.callOnClose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStartPreview(Object surface) {
            Log.v((String)TAG_THREAD, (String)"handleStartPreview:");
            if (this.mUVCCamera == null || this.mIsPreviewing) {
                return;
            }
            try {
                this.mUVCCamera.setPreviewSize(this.mWidth, this.mHeight, 1, 31, this.mPreviewMode, this.mBandwidthFactor);
                this.mUVCCamera.setFrameCallback(this.mIFrameCallback, 4);
            }
            catch (IllegalArgumentException e) {
                try {
                    this.mUVCCamera.setPreviewSize(this.mWidth, this.mHeight, 1, 31, 0, this.mBandwidthFactor);
                }
                catch (IllegalArgumentException e1) {
                    this.callOnError(e1);
                    return;
                }
            }
            if (surface instanceof SurfaceHolder) {
                this.mUVCCamera.setPreviewDisplay((SurfaceHolder)surface);
            }
            if (surface instanceof Surface) {
                this.mUVCCamera.setPreviewDisplay((Surface)surface);
            } else {
                this.mUVCCamera.setPreviewTexture((SurfaceTexture)surface);
            }
            this.mUVCCamera.startPreview();
            this.mUVCCamera.updateCameraParams();
            Object object = this.mSync;
            synchronized (object) {
                this.mIsPreviewing = true;
            }
            this.callOnStartPreview();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleStopPreview() {
            Log.v((String)TAG_THREAD, (String)"handleStopPreview:");
            if (this.mIsPreviewing) {
                if (this.mUVCCamera != null) {
                    this.mUVCCamera.stopPreview();
                    this.mUVCCamera.setFrameCallback(null, 0);
                }
                Object object = this.mSync;
                synchronized (object) {
                    this.mIsPreviewing = false;
                    this.mSync.notifyAll();
                }
                this.callOnStopPreview();
            }
            Log.v((String)TAG_THREAD, (String)"handleStopPreview:finished");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleCaptureStill(String path) {
            Log.v((String)TAG_THREAD, (String)"handleCaptureStill:");
            Activity parent = (Activity)this.mWeakParent.get();
            if (parent == null) {
                return;
            }
            try {
                Bitmap bitmap = ((CameraViewInterface)this.mWeakCameraView.get()).captureStillImage(this.mWidth, this.mHeight);
                File outputFile = TextUtils.isEmpty((CharSequence)path) ? MediaMuxerWrapper.getCaptureFile(Environment.DIRECTORY_DCIM, ".jpg") : new File(path);
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outputFile));){
                    try {
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)os);
                        os.flush();
                        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, outputFile.getPath()));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (mCaptureListener != null) {
                    mCaptureListener.onCaptureResult(path);
                }
            }
            catch (Exception e) {
                this.callOnError(e);
            }
        }

        public void handleStartPusher(RecordParams params) {
            if (this.mUVCCamera == null || this.mH264Consumer != null) {
                return;
            }
            if (params != null) {
                this.videoPath = params.getRecordPath();
                this.mMuxer = new Mp4MediaMuxer(params.getRecordPath(), params.getRecordDuration() * 60 * 1000, params.isVoiceClose());
            }
            this.startVideoRecord();
            if (params != null && !params.isVoiceClose()) {
                this.startAudioRecord();
            }
            this.callOnStartRecording();
        }

        public void handleStopPusher() {
            if (this.mMuxer != null) {
                this.mMuxer.release();
                this.mMuxer = null;
                Log.i((String)AbstractUVCCameraHandler.TAG, (String)"AbsUVCCameraHandler---->\u505c\u6b62\u672c\u5730\u5f55\u5236");
            }
            this.stopAudioRecord();
            this.stopVideoRecord();
            ((CameraViewInterface)this.mWeakCameraView.get()).setVideoEncoder(null);
            this.callOnStopRecording();
            if (mListener != null) {
                mListener.onRecordResult(this.videoPath + ".mp4");
            }
        }

        private void startVideoRecord() {
            this.mH264Consumer = new H264EncodeConsumer(this.getWidth(), this.getHeight());
            this.mH264Consumer.setOnH264EncodeResultListener(new H264EncodeConsumer.OnH264EncodeResultListener(){

                @Override
                public void onEncodeResult(byte[] data, int offset, int length, long timestamp) {
                    if (mListener != null) {
                        mListener.onEncodeResult(data, offset, length, timestamp, 1);
                    }
                }
            });
            this.mH264Consumer.start();
            if (this.mMuxer != null && this.mH264Consumer != null) {
                this.mH264Consumer.setTmpuMuxer(this.mMuxer);
            }
        }

        private void stopVideoRecord() {
            if (this.mH264Consumer != null) {
                this.mH264Consumer.exit();
                this.mH264Consumer.setTmpuMuxer(null);
                try {
                    H264EncodeConsumer t2 = this.mH264Consumer;
                    this.mH264Consumer = null;
                    if (t2 != null) {
                        t2.interrupt();
                        t2.join();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void startAudioRecord() {
            this.mAacConsumer = new AACEncodeConsumer();
            this.mAacConsumer.setOnAACEncodeResultListener(new AACEncodeConsumer.OnAACEncodeResultListener(){

                @Override
                public void onEncodeResult(byte[] data, int offset, int length, long timestamp) {
                    if (mListener != null) {
                        mListener.onEncodeResult(data, offset, length, timestamp, 0);
                    }
                }
            });
            this.mAacConsumer.start();
            if (this.mMuxer != null && this.mAacConsumer != null) {
                this.mAacConsumer.setTmpuMuxer(this.mMuxer);
            }
        }

        private void stopAudioRecord() {
            if (this.mAacConsumer != null) {
                this.mAacConsumer.exit();
                this.mAacConsumer.setTmpuMuxer(null);
                try {
                    AACEncodeConsumer t1 = this.mAacConsumer;
                    this.mAacConsumer = null;
                    if (t1 != null) {
                        t1.interrupt();
                        t1.join();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void handleStillPicture(String picPath) {
            this.picPath = picPath;
        }

        private void saveYuv2Jpeg(String path, byte[] data) {
            YuvImage yuvImage = new YuvImage(data, 17, this.mWidth, this.mHeight, null);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
            boolean result = yuvImage.compressToJpeg(new Rect(0, 0, this.mWidth, this.mHeight), 100, (OutputStream)bos);
            if (result) {
                byte[] buffer = bos.toByteArray();
                File file = new File(path);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    fos.write(buffer);
                    fos.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (mCaptureListener != null) {
                    mCaptureListener.onCaptureResult(path);
                }
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @TargetApi(value=17)
        public void handleUpdateMedia(String path) {
            boolean released;
            Log.v((String)TAG_THREAD, (String)("handleUpdateMedia:path=" + path));
            Activity parent = (Activity)this.mWeakParent.get();
            boolean bl = released = this.mHandler == null || this.mHandler.mReleased;
            if (parent != null && parent.getApplicationContext() != null) {
                try {
                    Log.i((String)AbstractUVCCameraHandler.TAG, (String)"MediaScannerConnection#scanFile");
                    MediaScannerConnection.scanFile((Context)parent.getApplicationContext(), (String[])new String[]{path}, null, null);
                }
                catch (Exception e) {
                    Log.e((String)AbstractUVCCameraHandler.TAG, (String)"handleUpdateMedia:", (Throwable)e);
                }
                if (released || parent.isDestroyed()) {
                    this.handleRelease();
                }
            } else {
                Log.w((String)AbstractUVCCameraHandler.TAG, (String)"MainActivity already destroyed");
                this.handleRelease();
            }
        }

        public void handleRelease() {
            Log.v((String)TAG_THREAD, (String)("handleRelease:mIsRecording=" + this.mIsRecording));
            this.handleClose();
            this.mCallbacks.clear();
            if (!this.mIsRecording) {
                this.mHandler.mReleased = true;
                Looper.myLooper().quit();
            }
            Log.v((String)TAG_THREAD, (String)"handleRelease:finished");
        }

        public void handleCameraFoucs() {
            Log.v((String)TAG_THREAD, (String)"handleStartPreview:");
            if (this.mUVCCamera == null || !this.mIsPreviewing) {
                return;
            }
            this.mUVCCamera.setAutoFocus(true);
        }

        public List<Size> getSupportedSizes() {
            if (this.mUVCCamera == null || !this.mIsPreviewing) {
                return null;
            }
            return this.mUVCCamera.getSupportedSizeList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Looper.prepare();
            AbstractUVCCameraHandler handler = null;
            try {
                Constructor<? extends AbstractUVCCameraHandler> constructor = this.mHandlerClass.getDeclaredConstructor(CameraThread.class);
                handler = constructor.newInstance(this);
            }
            catch (NoSuchMethodException e) {
                Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
            }
            catch (InstantiationException e) {
                Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
            }
            if (handler != null) {
                object = this.mSync;
                synchronized (object) {
                    this.mHandler = handler;
                    this.mSync.notifyAll();
                }
                Looper.loop();
                if (this.mHandler != null) {
                    this.mHandler.mReleased = true;
                }
            }
            this.mCallbacks.clear();
            object = this.mSync;
            synchronized (object) {
                this.mHandler = null;
                this.mSync.notifyAll();
            }
        }

        private void callOnOpen() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onOpen();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnClose() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onClose();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnStartPreview() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onStartPreview();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnStopPreview() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onStopPreview();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnStartRecording() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onStartRecording();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnStopRecording() {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onStopRecording();
                }
                catch (Exception e) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }

        private void callOnError(Exception e) {
            for (CameraCallback callback : this.mCallbacks) {
                try {
                    callback.onError(e);
                }
                catch (Exception e1) {
                    this.mCallbacks.remove(callback);
                    Log.w((String)AbstractUVCCameraHandler.TAG, (Throwable)e);
                }
            }
        }
    }

    public static interface OnCaptureListener {
        public void onCaptureResult(String var1);
    }

    public static interface OnPreViewResultListener {
        public void onPreviewResult(byte[] var1);
    }

    public static interface OnEncodeResultListener {
        public void onEncodeResult(byte[] var1, int var2, int var3, long var4, int var6);

        public void onRecordResult(String var1);
    }

    public static interface CameraCallback {
        public void onOpen();

        public void onClose();

        public void onStartPreview();

        public void onStopPreview();

        public void onStartRecording();

        public void onStopRecording();

        public void onError(Exception var1);
    }
}

