/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.usb.UsbDevice;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import com.jiangdg.libusbcamera.R;
import com.serenegiant.usb.DeviceFilter;
import com.serenegiant.usb.USBMonitor;
import java.util.ArrayList;
import java.util.List;

public class CameraDialog
extends DialogFragment {
    private static final String TAG = CameraDialog.class.getSimpleName();
    protected USBMonitor mUSBMonitor;
    private Spinner mSpinner;
    private DeviceListAdapter mDeviceListAdapter;
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            switch (v.getId()) {
                case 16908315: {
                    CameraDialog.this.updateDevices();
                }
            }
        }
    };
    private final DialogInterface.OnClickListener mOnDialogClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            switch (which) {
                case -1: {
                    Object item = CameraDialog.this.mSpinner.getSelectedItem();
                    if (!(item instanceof UsbDevice)) break;
                    CameraDialog.this.mUSBMonitor.requestPermission((UsbDevice)item);
                    ((CameraDialogParent)CameraDialog.this.getActivity()).onDialogResult(false);
                    break;
                }
                case -2: {
                    ((CameraDialogParent)CameraDialog.this.getActivity()).onDialogResult(true);
                }
            }
        }
    };

    public static CameraDialog showDialog(Activity parent) {
        CameraDialog dialog = CameraDialog.newInstance();
        try {
            dialog.show(parent.getFragmentManager(), TAG);
        }
        catch (IllegalStateException e) {
            dialog = null;
        }
        return dialog;
    }

    public static CameraDialog newInstance() {
        CameraDialog dialog = new CameraDialog();
        Bundle args = new Bundle();
        dialog.setArguments(args);
        return dialog;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (this.mUSBMonitor == null) {
            try {
                this.mUSBMonitor = ((CameraDialogParent)activity).getUSBMonitor();
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.mUSBMonitor == null) {
            throw new ClassCastException(activity.toString() + " must implement CameraDialogParent#getUSBController");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            savedInstanceState = this.getArguments();
        }
    }

    public void onSaveInstanceState(Bundle saveInstanceState) {
        Bundle args = this.getArguments();
        if (args != null) {
            saveInstanceState.putAll(args);
        }
        super.onSaveInstanceState(saveInstanceState);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setView(this.initView());
        builder.setTitle(R.string.select);
        builder.setPositiveButton(17039370, this.mOnDialogClickListener);
        builder.setNegativeButton(0x1040000, this.mOnDialogClickListener);
        builder.setNeutralButton(R.string.refresh, null);
        AlertDialog dialog = builder.create();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    private final View initView() {
        View rootView = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_camera, null);
        this.mSpinner = (Spinner)rootView.findViewById(R.id.spinner1);
        View empty = rootView.findViewById(16908292);
        this.mSpinner.setEmptyView(empty);
        return rootView;
    }

    public void onResume() {
        super.onResume();
        this.updateDevices();
        Button button = (Button)this.getDialog().findViewById(16908315);
        if (button != null) {
            button.setOnClickListener(this.mOnClickListener);
        }
    }

    public void onCancel(DialogInterface dialog) {
        ((CameraDialogParent)this.getActivity()).onDialogResult(true);
        super.onCancel(dialog);
    }

    public void updateDevices() {
        List<DeviceFilter> filter = DeviceFilter.getDeviceFilters((Context)this.getActivity(), R.xml.device_filter);
        this.mDeviceListAdapter = new DeviceListAdapter((Context)this.getActivity(), this.mUSBMonitor.getDeviceList(filter.get(0)));
        this.mSpinner.setAdapter((SpinnerAdapter)this.mDeviceListAdapter);
    }

    private static final class DeviceListAdapter
    extends BaseAdapter {
        private final LayoutInflater mInflater;
        private final List<UsbDevice> mList;

        public DeviceListAdapter(Context context, List<UsbDevice> list) {
            this.mInflater = LayoutInflater.from((Context)context);
            this.mList = list != null ? list : new ArrayList();
        }

        public int getCount() {
            return this.mList.size();
        }

        public UsbDevice getItem(int position) {
            if (position >= 0 && position < this.mList.size()) {
                return this.mList.get(position);
            }
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.listitem_device, parent, false);
            }
            if (convertView instanceof CheckedTextView) {
                UsbDevice device = this.getItem(position);
                ((CheckedTextView)convertView).setText((CharSequence)String.format("UVC Camera:(%x:%x:%s)", device.getVendorId(), device.getProductId(), device.getDeviceName()));
            }
            return convertView;
        }
    }

    public static interface CameraDialogParent {
        public USBMonitor getUSBMonitor();

        public void onDialogResult(boolean var1);
    }
}

