/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnyx2012.horizontalpicker;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.github.jhonnyx2012.horizontalpicker.Day;
import com.github.jhonnyx2012.horizontalpicker.OnItemClickedListener;
import com.github.jhonnyx2012.horizontalpicker.R;
import java.util.ArrayList;
import org.joda.time.DateTime;

public class HorizontalPickerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final long DAY_MILLIS = 86400000L;
    private final int mBackgroundColor;
    private final int mDateSelectedTextColor;
    private final int mDateSelectedColor;
    private final int mTodayDateTextColor;
    private final int mTodayDateBackgroundColor;
    private final int mDayOfWeekTextColor;
    private final int mUnselectedDayTextColor;
    private int itemWidth;
    private final OnItemClickedListener listener;
    private ArrayList<Day> items = new ArrayList();

    public HorizontalPickerAdapter(int itemWidth, OnItemClickedListener listener, Context context, int daysToCreate, int offset, int mBackgroundColor, int mDateSelectedColor, int mDateSelectedTextColor, int mTodayDateTextColor, int mTodayDateBackgroundColor, int mDayOfWeekTextColor, int mUnselectedDayTextColor) {
        this.itemWidth = itemWidth;
        this.listener = listener;
        this.generateDays(daysToCreate, new DateTime().minusDays(offset).getMillis(), false);
        this.mBackgroundColor = mBackgroundColor;
        this.mDateSelectedTextColor = mDateSelectedTextColor;
        this.mDateSelectedColor = mDateSelectedColor;
        this.mTodayDateTextColor = mTodayDateTextColor;
        this.mTodayDateBackgroundColor = mTodayDateBackgroundColor;
        this.mDayOfWeekTextColor = mDayOfWeekTextColor;
        this.mUnselectedDayTextColor = mUnselectedDayTextColor;
    }

    public void generateDays(int n, long initialDate, boolean cleanArray) {
        if (cleanArray) {
            this.items.clear();
        }
        int i = 0;
        while (i < n) {
            DateTime actualDate = new DateTime(initialDate + 86400000L * (long)i++);
            this.items.add(new Day(actualDate));
        }
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_day, parent, false));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        Day item = this.getItem(position);
        holder.tvDay.setText((CharSequence)item.getDay());
        holder.tvWeekDay.setText((CharSequence)item.getWeekDay());
        holder.tvWeekDay.setTextColor(this.mDayOfWeekTextColor);
        if (item.isSelected()) {
            holder.tvDay.setBackgroundDrawable(this.getDaySelectedBackground(holder.itemView));
            holder.tvDay.setTextColor(this.mDateSelectedTextColor);
        } else if (item.isToday()) {
            holder.tvDay.setBackgroundDrawable(this.getDayTodayBackground(holder.itemView));
            holder.tvDay.setTextColor(this.mTodayDateTextColor);
        } else {
            holder.tvDay.setBackgroundColor(this.mBackgroundColor);
            holder.tvDay.setTextColor(this.mUnselectedDayTextColor);
        }
    }

    private Drawable getDaySelectedBackground(View view) {
        Drawable drawable2 = view.getResources().getDrawable(R.drawable.background_day_selected);
        DrawableCompat.setTint((Drawable)drawable2, (int)this.mDateSelectedColor);
        return drawable2;
    }

    private Drawable getDayTodayBackground(View view) {
        Drawable drawable2 = view.getResources().getDrawable(R.drawable.background_day_today);
        if (this.mTodayDateBackgroundColor != -1) {
            DrawableCompat.setTint((Drawable)drawable2, (int)this.mTodayDateBackgroundColor);
        }
        return drawable2;
    }

    public Day getItem(int position) {
        return this.items.get(position);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        TextView tvDay;
        TextView tvWeekDay;

        public ViewHolder(View itemView) {
            super(itemView);
            this.tvDay = (TextView)itemView.findViewById(R.id.tvDay);
            this.tvDay.setWidth(HorizontalPickerAdapter.this.itemWidth);
            this.tvWeekDay = (TextView)itemView.findViewById(R.id.tvWeekDay);
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            HorizontalPickerAdapter.this.listener.onClickView(v, this.getAdapterPosition());
        }
    }
}

