/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnyx2012.horizontalpicker;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSmoothScroller;
import android.support.v7.widget.LinearSnapHelper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.github.jhonnyx2012.horizontalpicker.HorizontalPickerAdapter;
import com.github.jhonnyx2012.horizontalpicker.HorizontalPickerListener;
import com.github.jhonnyx2012.horizontalpicker.OnItemClickedListener;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public class HorizontalPickerRecyclerView
extends RecyclerView
implements OnItemClickedListener,
View.OnClickListener {
    private HorizontalPickerAdapter adapter;
    private int lastPosition;
    private LinearLayoutManager layoutManager;
    private float itemWidth;
    private HorizontalPickerListener listener;
    private int offset;
    private RecyclerView.OnScrollListener onScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            switch (newState) {
                case 0: {
                    HorizontalPickerRecyclerView.this.listener.onStopDraggingPicker();
                    int position = (int)((double)((float)HorizontalPickerRecyclerView.this.computeHorizontalScrollOffset() / HorizontalPickerRecyclerView.this.itemWidth) + 3.5);
                    if (position == -1 || position == HorizontalPickerRecyclerView.this.lastPosition) break;
                    HorizontalPickerRecyclerView.this.selectItem(true, position);
                    HorizontalPickerRecyclerView.this.selectItem(false, HorizontalPickerRecyclerView.this.lastPosition);
                    HorizontalPickerRecyclerView.this.lastPosition = position;
                    break;
                }
                case 1: {
                    HorizontalPickerRecyclerView.this.listener.onDraggingPicker();
                }
            }
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
        }
    };

    public HorizontalPickerRecyclerView(Context context) {
        super(context);
    }

    public HorizontalPickerRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public HorizontalPickerRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void init(Context context, final int daysToPlus, final int initialOffset) {
        this.offset = initialOffset;
        this.layoutManager = new LinearLayoutManager(context, 0, false);
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.post(new Runnable(){

            @Override
            public void run() {
                HorizontalPickerRecyclerView.this.itemWidth = HorizontalPickerRecyclerView.this.getMeasuredWidth() / 7;
                HorizontalPickerRecyclerView.this.adapter = new HorizontalPickerAdapter((int)HorizontalPickerRecyclerView.this.itemWidth, HorizontalPickerRecyclerView.this, HorizontalPickerRecyclerView.this.getContext(), daysToPlus, initialOffset);
                HorizontalPickerRecyclerView.this.setAdapter(HorizontalPickerRecyclerView.this.adapter);
                LinearSnapHelper snapHelper = new LinearSnapHelper();
                snapHelper.attachToRecyclerView((RecyclerView)HorizontalPickerRecyclerView.this);
                HorizontalPickerRecyclerView.this.removeOnScrollListener(HorizontalPickerRecyclerView.this.onScrollListener);
                HorizontalPickerRecyclerView.this.addOnScrollListener(HorizontalPickerRecyclerView.this.onScrollListener);
            }
        });
    }

    private void selectItem(boolean isSelected, int position) {
        this.adapter.getItem(position).setSelected(isSelected);
        this.adapter.notifyItemChanged(position);
        if (isSelected) {
            this.listener.onDateSelected(this.adapter.getItem(position));
        }
    }

    public void setListener(HorizontalPickerListener listener) {
        this.listener = listener;
    }

    @Override
    public void onClickView(View v, int adapterPosition) {
        if (adapterPosition != this.lastPosition) {
            this.selectItem(true, adapterPosition);
            this.selectItem(false, this.lastPosition);
            this.lastPosition = adapterPosition;
        }
    }

    public void onClick(View v) {
        this.setDate(new DateTime());
    }

    public void smoothScrollToPosition(int position) {
        CenterSmoothScroller smoothScroller = new CenterSmoothScroller(this.getContext());
        smoothScroller.setTargetPosition(position);
        this.post(new Runnable((RecyclerView.SmoothScroller)smoothScroller){
            final /* synthetic */ RecyclerView.SmoothScroller val$smoothScroller;
            {
                this.val$smoothScroller = smoothScroller;
            }

            @Override
            public void run() {
                HorizontalPickerRecyclerView.this.layoutManager.startSmoothScroll(this.val$smoothScroller);
            }
        });
    }

    public void setDate(DateTime date) {
        DateTime today = new DateTime().withTime(0, 0, 0, 0);
        int difference = Days.daysBetween((ReadableInstant)date, (ReadableInstant)today).getDays() * ((long)date.getYear() < today.getMillis() ? -1 : 1);
        this.smoothScrollToPosition(this.offset + difference);
    }

    private static class CenterSmoothScroller
    extends LinearSmoothScroller {
        CenterSmoothScroller(Context context) {
            super(context);
        }

        public int calculateDtToFit(int viewStart, int viewEnd, int boxStart, int boxEnd, int snapPreference) {
            return boxStart + (boxEnd - boxStart) / 2 - (viewStart + (viewEnd - viewStart) / 2);
        }
    }
}

