/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnyx2012.horizontalpicker;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.jhonnyx2012.horizontalpicker.DatePickerListener;
import com.github.jhonnyx2012.horizontalpicker.Day;
import com.github.jhonnyx2012.horizontalpicker.HorizontalPickerListener;
import com.github.jhonnyx2012.horizontalpicker.HorizontalPickerRecyclerView;
import com.github.jhonnyx2012.horizontalpicker.R;
import org.joda.time.DateTime;

public class HorizontalPicker
extends LinearLayout
implements HorizontalPickerListener {
    private static final int NO_SETTED = -1;
    private View vHover;
    private TextView tvMonth;
    private TextView tvToday;
    private DatePickerListener listener;
    private HorizontalPickerRecyclerView rvDays;
    private int days;
    private int offset;

    public HorizontalPicker(Context context) {
        super(context);
        this.internInit();
    }

    public HorizontalPicker(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.internInit();
    }

    public HorizontalPicker(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.internInit();
    }

    private void internInit() {
        this.days = -1;
        this.offset = -1;
    }

    public HorizontalPicker setListener(DatePickerListener listener) {
        this.listener = listener;
        return this;
    }

    public void setDate(final DateTime date) {
        this.rvDays.post(new Runnable(){

            @Override
            public void run() {
                HorizontalPicker.this.rvDays.setDate(date);
            }
        });
    }

    public void init() {
        HorizontalPicker.inflate((Context)this.getContext(), (int)R.layout.horizontal_picker, (ViewGroup)this);
        this.rvDays = (HorizontalPickerRecyclerView)this.findViewById(R.id.rvDays);
        int DEFAULT_DAYS_TO_PLUS = 120;
        int finalDays = this.days == -1 ? DEFAULT_DAYS_TO_PLUS : this.days;
        int DEFAULT_INITIAL_OFFSET = 7;
        int finalOffset = this.offset == -1 ? DEFAULT_INITIAL_OFFSET : this.offset;
        this.vHover = this.findViewById(R.id.vHover);
        this.tvMonth = (TextView)this.findViewById(R.id.tvMonth);
        this.tvToday = (TextView)this.findViewById(R.id.tvToday);
        this.rvDays.setListener(this);
        this.tvToday.setOnClickListener((View.OnClickListener)this.rvDays);
        this.rvDays.init(this.getContext(), finalDays, finalOffset);
    }

    public boolean post(Runnable action) {
        return this.rvDays.post(action);
    }

    @Override
    public void onStopDraggingPicker() {
        if (this.vHover.getVisibility() == 0) {
            this.vHover.setVisibility(4);
        }
    }

    @Override
    public void onDraggingPicker() {
        if (this.vHover.getVisibility() == 4) {
            this.vHover.setVisibility(0);
        }
    }

    @Override
    public void onDateSelected(Day item) {
        this.tvMonth.setText((CharSequence)item.getMonth());
        this.tvToday.setVisibility(item.isToday() ? 4 : 0);
        if (this.listener != null) {
            this.listener.onDateSelected(item.getDate());
        }
    }

    public HorizontalPicker setDays(int days) {
        this.days = days;
        return this;
    }

    public int getDays() {
        return this.days;
    }

    public HorizontalPicker setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }
}

