/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnymertz.wkhtmltopdf.wrapper;

import com.github.jhonnymertz.wkhtmltopdf.wrapper.configurations.FilenameFilterConfig;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.configurations.WrapperConfig;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.exceptions.PDFExportException;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.exceptions.PDFGenerationException;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.exceptions.PDFTimeoutException;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.objects.BaseObject;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.objects.Cover;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.objects.Page;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.objects.SourceType;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.objects.TableOfContents;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.params.Param;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.params.Params;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pdf {
    private static final Logger logger = LoggerFactory.getLogger(Pdf.class);
    private static final String STDINOUT = "-";
    private final WrapperConfig wrapperConfig;
    private final Params params;
    private final List<BaseObject> objects;
    private TableOfContents lastToc;
    private int timeout = 10;
    private File tempDirectory;
    public static final String TEMPORARY_FILE_PREFIX = "java-wkhtmltopdf-wrapper";
    private String outputFilename = null;
    private List<Integer> successValues = new ArrayList<Integer>(Collections.singletonList(0));

    @Deprecated
    public Pdf() {
        this(new WrapperConfig());
    }

    public Pdf(WrapperConfig wrapperConfig) {
        this.wrapperConfig = wrapperConfig;
        this.params = new Params();
        this.objects = new ArrayList<BaseObject>();
        logger.info("Initialized with {}", (Object)wrapperConfig);
    }

    @Deprecated
    public Page addPage(String source, SourceType type) {
        Page page = new Page(source, type);
        this.objects.add(page);
        return page;
    }

    public Cover addCoverFromUrl(String source) {
        Cover cover = new Cover(source, SourceType.url);
        this.objects.add(cover);
        return cover;
    }

    public Cover addCoverFromString(String source) {
        Cover cover = new Cover(source, SourceType.htmlAsString);
        this.objects.add(cover);
        return cover;
    }

    public Cover addCoverFromFile(String source) {
        Cover cover = new Cover(source, SourceType.file);
        this.objects.add(cover);
        return cover;
    }

    public Page addPageFromUrl(String source) {
        Page page = new Page(source, SourceType.url);
        this.objects.add(page);
        return page;
    }

    public Page addPageFromString(String source) {
        Page page = new Page(source, SourceType.htmlAsString);
        this.objects.add(page);
        return page;
    }

    public Page addPageFromFile(String source) {
        Page page = new Page(source, SourceType.file);
        this.objects.add(page);
        return page;
    }

    public TableOfContents addToc() {
        TableOfContents toc = new TableOfContents();
        this.objects.add(toc);
        this.lastToc = toc;
        return toc;
    }

    public void addParam(Param param, Param ... params) {
        this.params.add(param, params);
    }

    @Deprecated
    public void addTocParam(Param param, Param ... params) {
        this.lastToc.addParam(param, params);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setAllowMissingAssets() {
        if (!this.successValues.contains(1)) {
            this.successValues.add(1);
        }
    }

    public boolean getAllowMissingAssets() {
        return this.successValues.contains(1);
    }

    public void setSuccessValues(List<Integer> successValues) {
        this.successValues = successValues;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public File saveAs(String path) throws IOException, InterruptedException {
        File file = new File(path);
        FileUtils.writeByteArrayToFile((File)file, (byte[])this.getPDF());
        logger.info("PDF successfully saved in {}", (Object)file.getAbsolutePath());
        return file;
    }

    public File saveAsDirect(String path) throws IOException, InterruptedException {
        File file = new File(path);
        this.outputFilename = file.getAbsolutePath();
        this.getPDF();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPDF() throws IOException, InterruptedException, PDFExportException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            String command = this.getCommand();
            logger.debug("Generating pdf with: {}", (Object)command);
            Process process = Runtime.getRuntime().exec(this.getCommandAsArray());
            Future<byte[]> inputStreamToByteArray = executor.submit(this.streamToByteArrayTask(process.getInputStream()));
            Future<byte[]> outputStreamToByteArray = executor.submit(this.streamToByteArrayTask(process.getErrorStream()));
            if (!process.waitFor(this.timeout, TimeUnit.SECONDS)) {
                process.destroy();
                logger.error("PDF generation failed by defined timeout of {}s, command: {}", (Object)this.timeout, (Object)command);
                throw new PDFTimeoutException(command, this.timeout, this.getFuture(inputStreamToByteArray));
            }
            if (!this.successValues.contains(process.exitValue())) {
                byte[] errorStream = this.getFuture(outputStreamToByteArray);
                logger.error("Error while generating pdf: {}", (Object)new String(errorStream));
                throw new PDFExportException(command, process.exitValue(), errorStream, this.getFuture(inputStreamToByteArray));
            }
            logger.debug("Wkhtmltopdf output:\n{}", (Object)new String(this.getFuture(outputStreamToByteArray)));
            logger.info("PDF successfully generated with: {}", (Object)command);
            byte[] byArray = this.getFuture(inputStreamToByteArray);
            return byArray;
        }
        finally {
            logger.debug("Shutting down executor for wkhtmltopdf.");
            executor.shutdownNow();
            this.cleanTempFiles();
        }
    }

    protected String[] getCommandAsArray() throws IOException {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.wrapperConfig.isXvfbEnabled()) {
            commandLine.addAll(this.wrapperConfig.getXvfbConfig().getCommandLine());
        }
        commandLine.addAll(Arrays.asList(this.wrapperConfig.getWkhtmltopdfCommandAsArray()));
        commandLine.addAll(this.params.getParamsAsStringList());
        if (this.wrapperConfig.getAlwaysPutTocFirst()) {
            List tocObjects = this.objects.stream().filter(TableOfContents.class::isInstance).collect(Collectors.toList());
            this.objects.removeAll(tocObjects);
            this.objects.addAll(0, tocObjects);
        }
        for (BaseObject object : this.objects) {
            commandLine.addAll(object.getCommandAsList(this));
        }
        commandLine.add(null != this.outputFilename ? this.outputFilename : STDINOUT);
        logger.debug("Command generated: {}", commandLine);
        return commandLine.toArray(new String[commandLine.size()]);
    }

    private Callable<byte[]> streamToByteArrayTask(InputStream input) {
        return () -> IOUtils.toByteArray((InputStream)input);
    }

    private byte[] getFuture(Future<byte[]> future) {
        try {
            return future.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            logger.error("PDF generation failed by defined timeout of {}s", (Object)this.timeout);
            throw new PDFTimeoutException(this.timeout, e);
        }
        catch (Exception e) {
            logger.error("Something went wrong while generating PDF.", (Throwable)e);
            throw new PDFGenerationException(e);
        }
    }

    private void cleanTempFiles() {
        logger.debug("Cleaning up temporary files...");
        for (BaseObject object : this.objects) {
            Page page;
            if (!(object instanceof Page) || !(page = (Page)object).getType().equals((Object)SourceType.htmlAsString)) continue;
            try {
                Path p = Paths.get(page.getFilePath(), new String[0]);
                logger.debug("Delete temp file at: '{}' Status: '{}'", (Object)page.getFilePath(), (Object)Files.deleteIfExists(p));
            }
            catch (IOException ex) {
                logger.warn("Couldn't delete temp file '{}'", (Object)page.getFilePath(), (Object)ex);
            }
        }
    }

    public void cleanAllTempFiles() {
        File[] files;
        logger.debug("Cleaning up temporary files...");
        File folder = new File(System.getProperty("java.io.tmpdir"));
        for (File file : files = folder.listFiles(new FilenameFilterConfig())) {
            if (file.delete()) continue;
            logger.warn("Couldn't delete temp file '{}'", (Object)file.getAbsolutePath());
        }
        logger.debug("{} temporary files removed.", (Object)files.length);
    }

    public String getCommand() throws IOException {
        return StringUtils.join((Object[])this.getCommandAsArray(), (String)" ");
    }
}

