/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnymertz.wkhtmltopdf.wrapper.configurations;

import com.github.jhonnymertz.wkhtmltopdf.wrapper.configurations.XvfbConfig;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class WrapperConfig {
    private XvfbConfig xvfbConfig;
    private String wkhtmltopdfCommand = "wkhtmltopdf";

    public WrapperConfig() {
        this.setWkhtmltopdfCommand(this.findExecutable());
    }

    public WrapperConfig(String wkhtmltopdfCommand) {
        this.setWkhtmltopdfCommand(wkhtmltopdfCommand);
    }

    public String getWkhtmltopdfCommand() {
        return this.wkhtmltopdfCommand;
    }

    public void setWkhtmltopdfCommand(String wkhtmltopdfCommand) {
        this.wkhtmltopdfCommand = wkhtmltopdfCommand;
    }

    public String findExecutable() {
        try {
            String osname = System.getProperty("os.name").toLowerCase();
            String cmd = osname.contains("windows") ? "where wkhtmltopdf" : "which wkhtmltopdf";
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            String text = IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset()).trim();
            if (text.isEmpty()) {
                throw new RuntimeException();
            }
            this.setWkhtmltopdfCommand(text);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return this.getWkhtmltopdfCommand();
    }

    public boolean isXvfbEnabled() {
        return this.xvfbConfig != null;
    }

    public XvfbConfig getXvfbConfig() {
        return this.xvfbConfig;
    }

    public void setXvfbConfig(XvfbConfig xvfbConfig) {
        this.xvfbConfig = xvfbConfig;
    }
}

