/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhonnymertz.wkhtmltopdf.wrapper;

import com.github.jhonnymertz.wkhtmltopdf.wrapper.configurations.WrapperConfig;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.page.Page;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.page.PageType;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.params.Param;
import com.github.jhonnymertz.wkhtmltopdf.wrapper.params.Params;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pdf {
    private static final String STDINOUT = "-";
    private final WrapperConfig wrapperConfig;
    private final Params params;
    private final Params tocParams;
    private final List<Page> pages;
    private boolean hasToc = false;

    public Pdf() {
        this(new WrapperConfig());
    }

    public Pdf(WrapperConfig wrapperConfig) {
        this.wrapperConfig = wrapperConfig;
        this.params = new Params();
        this.tocParams = new Params();
        this.pages = new ArrayList<Page>();
    }

    @Deprecated
    public void addPage(String source, PageType type) {
        this.pages.add(new Page(source, type));
    }

    public void addPageFromUrl(String source) {
        this.pages.add(new Page(source, PageType.url));
    }

    public void addPageFromString(String source) {
        this.pages.add(new Page(source, PageType.htmlAsString));
    }

    public void addPageFromFile(String source) {
        this.pages.add(new Page(source, PageType.file));
    }

    public void addToc() {
        this.hasToc = true;
    }

    public void addParam(Param param, Param ... params) {
        this.params.add(param, params);
    }

    public void addTocParam(Param param, Param ... params) {
        this.tocParams.add(param, params);
    }

    public File saveAs(String path) throws IOException, InterruptedException {
        File file = new File(path);
        FileUtils.writeByteArrayToFile((File)file, (byte[])this.getPDF());
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPDF() throws IOException, InterruptedException {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            Process process = Runtime.getRuntime().exec(this.getCommandAsArray());
            Future<byte[]> inputStreamToByteArray = executor.submit(this.streamToByteArrayTask(process.getInputStream()));
            Future<byte[]> errorStreamToByteArray = executor.submit(this.streamToByteArrayTask(process.getErrorStream()));
            process.waitFor();
            if (process.exitValue() != 0) {
                throw new RuntimeException("Process (" + this.getCommand() + ") exited with status code " + process.exitValue() + ":\n" + new String(this.getFuture(errorStreamToByteArray)));
            }
            byte[] byArray = this.getFuture(inputStreamToByteArray);
            return byArray;
        }
        finally {
            executor.shutdownNow();
            this.cleanTempFiles();
        }
    }

    private String[] getCommandAsArray() throws IOException {
        ArrayList<String> commandLine = new ArrayList<String>();
        if (this.wrapperConfig.isXvfbEnabled()) {
            commandLine.addAll(this.wrapperConfig.getXvfbConfig().getCommandLine());
        }
        commandLine.add(this.wrapperConfig.getWkhtmltopdfCommand());
        commandLine.addAll(this.params.getParamsAsStringList());
        if (this.hasToc) {
            commandLine.add("toc");
            commandLine.addAll(this.tocParams.getParamsAsStringList());
        }
        for (Page page : this.pages) {
            if (page.getType().equals((Object)PageType.htmlAsString)) {
                File temp = File.createTempFile("java-wkhtmltopdf-wrapper" + UUID.randomUUID().toString(), ".html");
                FileUtils.writeStringToFile((File)temp, (String)page.getSource(), (String)"UTF-8");
                page.setSource(temp.getAbsolutePath());
            }
            commandLine.add(page.getSource());
        }
        commandLine.add(STDINOUT);
        return commandLine.toArray(new String[commandLine.size()]);
    }

    private Callable<byte[]> streamToByteArrayTask(final InputStream input) {
        return new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return IOUtils.toByteArray((InputStream)input);
            }
        };
    }

    private byte[] getFuture(Future<byte[]> future) {
        try {
            return future.get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void cleanTempFiles() {
        for (Page page : this.pages) {
            if (!page.getType().equals((Object)PageType.htmlAsString)) continue;
            new File(page.getSource()).delete();
        }
    }

    public String getCommand() throws IOException {
        return StringUtils.join((Object[])this.getCommandAsArray(), (String)" ");
    }
}

