/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.attribute.DisplayList;
import com.github.jferard.fastods.ref.CellRef;
import com.github.jferard.fastods.util.ErrorMessage;
import com.github.jferard.fastods.util.StringUtil;
import com.github.jferard.fastods.util.Validation;
import java.util.Collection;

public class ValidationBuilder {
    private final String name;
    private String condition;
    private boolean allowEmptyCells;
    private CellRef baseCellAddress;
    private DisplayList displayList;
    private ErrorMessage errorMessage;

    public ValidationBuilder(String name) {
        this.name = name;
        this.allowEmptyCells = true;
        this.displayList = DisplayList.UNSORTED;
        this.errorMessage = ErrorMessage.create();
    }

    public ValidationBuilder dontAllowEmptyCells() {
        this.allowEmptyCells = false;
        return this;
    }

    public ValidationBuilder baseCellAddress(CellRef baseCellAddress) {
        this.baseCellAddress = baseCellAddress;
        return this;
    }

    public ValidationBuilder listCondition(Collection<String> allowedValues) {
        this.condition = "of:cell-content-is-in-list(\"" + StringUtil.join("\";\"", allowedValues) + "\")";
        this.baseCellAddress = null;
        return this;
    }

    public ValidationBuilder displayList(DisplayList displayList) {
        this.displayList = displayList;
        return this;
    }

    public ValidationBuilder errorMessage(ErrorMessage errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public Validation build() {
        return new Validation(this.name, this.condition, this.allowEmptyCells, this.baseCellAddress, this.displayList, this.errorMessage);
    }
}

