/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.attribute.DisplayList;
import com.github.jferard.fastods.ref.CellRef;
import com.github.jferard.fastods.util.ErrorMessage;
import com.github.jferard.fastods.util.NamedObject;
import com.github.jferard.fastods.util.ValidationBuilder;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class Validation
implements XMLConvertible,
NamedObject {
    private final String name;
    private final String condition;
    private final boolean allowEmptyCells;
    private final CellRef baseCellAddress;
    private final DisplayList displayList;
    private final ErrorMessage errorMessage;

    public static ValidationBuilder builder(String name) {
        return new ValidationBuilder(name);
    }

    public Validation(String name, String condition, boolean allowEmptyCells, CellRef baseCellAddress, DisplayList displayList, ErrorMessage errorMessage) {
        this.name = name;
        this.condition = condition;
        this.allowEmptyCells = allowEmptyCells;
        this.baseCellAddress = baseCellAddress;
        this.displayList = displayList;
        this.errorMessage = errorMessage;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:content-validation");
        util.appendEAttribute(appendable, "table:name", this.name);
        util.appendEAttribute(appendable, "table:condition", this.condition);
        if (!this.allowEmptyCells) {
            util.appendEAttribute(appendable, "table:allow-empty-cell", "false");
        }
        if (this.baseCellAddress != null) {
            util.appendEAttribute(appendable, "table:base-cell-address", this.baseCellAddress.toString());
        }
        if (this.baseCellAddress != null) {
            util.appendAttribute(appendable, (CharSequence)"table:base-cell-address", this.baseCellAddress.toString());
        }
        if (this.displayList != DisplayList.UNSORTED) {
            util.appendAttribute(appendable, (CharSequence)"table:base-cell-address", this.displayList);
        }
        if (this.errorMessage != null) {
            appendable.append(">");
            this.errorMessage.appendXMLContent(util, appendable);
            appendable.append("</table:content-validation>");
        } else {
            appendable.append("/>");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

