/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.attribute.FieldOrientation;
import com.github.jferard.fastods.attribute.PilotFunction;
import com.github.jferard.fastods.util.PilotTableLevel;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class PilotTableField
implements XMLConvertible {
    private final String sourceFieldName;
    private final FieldOrientation orientation;
    private final int usedHierarchy;
    private final boolean isDataLayout;
    private final PilotFunction function;
    private final PilotTableLevel level;

    public PilotTableField(String sourceFieldName, FieldOrientation orientation, int usedHierarchy, boolean isDataLayout, PilotFunction function, PilotTableLevel level) {
        this.sourceFieldName = sourceFieldName;
        this.orientation = orientation;
        this.usedHierarchy = usedHierarchy;
        this.isDataLayout = isDataLayout;
        this.function = function;
        this.level = level;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:data-pilot-field");
        util.appendAttribute(appendable, (CharSequence)"table:source-field-name", this.sourceFieldName);
        util.appendAttribute(appendable, (CharSequence)"table:orientation", this.orientation);
        if (this.usedHierarchy != -1) {
            util.appendAttribute(appendable, (CharSequence)"table:used-hierarchy", this.usedHierarchy);
        }
        if (this.isDataLayout) {
            util.appendAttribute(appendable, (CharSequence)"table:is-data-layout-field", true);
        }
        util.appendAttribute(appendable, (CharSequence)"table:function", this.function);
        if (this.level == null) {
            appendable.append("/>");
        } else {
            appendable.append(">");
            this.level.appendXMLContent(util, appendable);
            appendable.append("</table:data-pilot-field>");
        }
    }
}

