/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.attribute.FilterOperator;
import com.github.jferard.fastods.attribute.FilterType;
import com.github.jferard.fastods.util.Filter;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class FilterEnumerate
implements Filter {
    private final int colIndex;
    private final List<String> values;

    public FilterEnumerate(int colIndex, String ... values) {
        this.colIndex = colIndex;
        this.values = Arrays.asList(values);
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:filter-condition");
        util.appendAttribute(appendable, (CharSequence)"table:field-number", this.colIndex);
        util.appendAttribute(appendable, (CharSequence)"table:operator", FilterOperator.EQ);
        util.appendAttribute(appendable, (CharSequence)"table:value", this.values.get(0));
        util.appendAttribute(appendable, (CharSequence)"table:data-type", FilterType.TEXT);
        appendable.append(">");
        for (String value : this.values) {
            appendable.append("<table:filter-set-item");
            util.appendAttribute(appendable, (CharSequence)"table:value", value);
            appendable.append("/>");
        }
        appendable.append("</table:filter-condition>");
    }
}

