/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    private static final int BUFFER_SIZE = 65536;
    private static final int START_SIZE = 0x100000;
    private final int bufferSize;
    private final int startSize;

    public FileUtil(int bufferSize, int startSize) {
        this.bufferSize = bufferSize;
        this.startSize = startSize;
    }

    public static FileUtil create() {
        return new FileUtil(65536, 0x100000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        int length = (int)file.length();
        try {
            byte[] byArray = this.readStream(is, length);
            return byArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public byte[] readStream(InputStream is) throws IOException {
        return this.readStream(is, this.startSize);
    }

    public byte[] readStream(InputStream is, int customStartSize) throws IOException {
        int count;
        byte[] bytes = new byte[customStartSize <= this.bufferSize ? this.bufferSize : customStartSize];
        int totalCount = 0;
        while ((count = is.read(bytes = this.ensureBytes(totalCount, bytes), totalCount, this.bufferSize)) != -1) {
            totalCount += count;
        }
        byte[] new_bytes = new byte[totalCount];
        System.arraycopy(bytes, 0, new_bytes, 0, totalCount);
        return new_bytes;
    }

    private byte[] ensureBytes(int totalCount, byte[] curBytes) {
        int len;
        if (curBytes.length > totalCount + this.bufferSize) {
            return curBytes;
        }
        for (len = curBytes.length; len <= totalCount + this.bufferSize; len *= 2) {
        }
        byte[] new_bytes = new byte[len];
        System.arraycopy(curBytes, 0, new_bytes, 0, totalCount);
        return new_bytes;
    }
}

