/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FastFullList<E>
implements Iterable<E> {
    private static final int DEFAULT_CAPACITY = 10;
    private final E blankElement;
    private int capacity;
    private E[] arr;
    private int size;

    public static <F> FastFullList<F> newListWithCapacity(int capacity) {
        return new FastFullList<Object>(capacity, null);
    }

    public static <F> FastFullListBuilder<F> builder() {
        return new FastFullListBuilder();
    }

    public static <F> FastFullList<F> newList(F ... elements) {
        FastFullList<Object> l = new FastFullList<Object>(10, null);
        for (int i = 0; i < elements.length; ++i) {
            l.set(i, elements[i]);
        }
        return l;
    }

    public FastFullList(int capacity, E blankElement) {
        this.capacity = capacity;
        this.blankElement = blankElement;
        this.arr = new Object[this.capacity];
        this.size = 0;
    }

    public int usedSize() {
        return this.size;
    }

    public void set(int index, E element) {
        int lastIndex = this.size - 1;
        if (index < lastIndex) {
            this.arr[index] = element;
        } else if (index > lastIndex) {
            if (element != this.blankElement) {
                this.addMissingBlanks(index);
                this.arr[index] = element;
            }
        } else if (element == this.blankElement) {
            this.removeTrail();
        } else {
            this.arr[index] = element;
        }
    }

    private void addMissingBlanks(int index) {
        if (this.capacity <= index) {
            this.capacity = index * 2 + 1;
            Object[] newArr = new Object[this.capacity];
            System.arraycopy(this.arr, 0, newArr, 0, this.size);
            this.arr = newArr;
        }
        if (this.blankElement != null) {
            Arrays.fill(this.arr, this.size, index, this.blankElement);
        }
        this.size = index + 1;
    }

    private void removeTrail() {
        int last;
        for (last = this.size - 2; last >= 0 && this.arr[last] == this.blankElement; --last) {
        }
        this.size = last + 1;
    }

    public E get(int index) {
        if (index < this.size) {
            return this.arr[index];
        }
        return this.blankElement;
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return Arrays.asList(this.arr).subList(fromIndex, toIndex);
    }

    @Override
    public Iterator<E> iterator() {
        return Arrays.asList(this.arr).subList(0, this.size).iterator();
    }

    public static class FastFullListBuilder<F> {
        private F blankElement;
        private int capacity;

        public FastFullListBuilder<F> blankElement(F blankElement) {
            this.blankElement = blankElement;
            return this;
        }

        public FastFullListBuilder<F> capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public FastFullList<F> build() {
            return new FastFullList<F>(this.capacity, this.blankElement);
        }
    }
}

