/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.attribute.SimpleColor;
import com.github.jferard.fastods.style.TextProperties;
import com.github.jferard.fastods.style.TextStyle;

public class TextPropertiesBuilder {
    private Color fontColor;
    private String fontName;
    private String fontStyle;
    private Color fontUnderlineColor;
    private TextProperties.Underline fontUnderlineStyle;
    private String fontWeight;
    private Length fontSizeLength;
    private double fontSizePercentage;

    TextPropertiesBuilder() {
        this.fontSizePercentage = -1.0;
        this.fontColor = SimpleColor.NONE;
        this.fontUnderlineColor = SimpleColor.NONE;
    }

    TextPropertiesBuilder(Color fontColor, String fontName, String fontWeight, String fontStyle, double fontSizePercentage, Length fontSizeLength, Color fontUnderlineColor, TextProperties.Underline fontUnderlineStyle) {
        this.fontColor = fontColor;
        this.fontName = fontName;
        this.fontWeight = fontWeight;
        this.fontStyle = fontStyle;
        this.fontSizePercentage = fontSizePercentage;
        this.fontSizeLength = fontSizeLength;
        this.fontUnderlineColor = fontUnderlineColor;
        this.fontUnderlineStyle = fontUnderlineStyle;
    }

    public TextProperties build() {
        return new TextProperties(this.fontColor, this.fontName, this.fontWeight, this.fontStyle, this.fontSizePercentage, this.fontSizeLength, this.fontUnderlineColor, this.fontUnderlineStyle);
    }

    @Deprecated
    public TextStyle buildVisibleStyle(String name) {
        return new TextStyle(name, false, this.build());
    }

    @Deprecated
    public TextStyle buildHiddenStyle(String name) {
        if (this.fontSizePercentage > 0.0) {
            throw new IllegalArgumentException("20.183 fo:font-size: fontSizePercentage values can be used within common styles only");
        }
        return new TextStyle(name, true, this.build());
    }

    public TextPropertiesBuilder fontColor(Color color) {
        this.fontColor = color;
        return this;
    }

    public TextPropertiesBuilder fontName(String fontName) {
        this.fontName = fontName;
        return this;
    }

    public TextPropertiesBuilder fontSize(Length fontSize) {
        this.fontSizePercentage = -1.0;
        this.fontSizeLength = fontSize;
        return this;
    }

    public TextPropertiesBuilder fontSizePercentage(double percentage) {
        this.fontSizeLength = null;
        this.fontSizePercentage = percentage;
        return this;
    }

    public TextPropertiesBuilder fontStyleItalic() {
        this.fontStyle = "italic";
        return this;
    }

    public TextPropertiesBuilder fontStyleNormal() {
        this.fontStyle = "normal";
        return this;
    }

    public TextPropertiesBuilder fontUnderlineColor(Color color) {
        this.fontUnderlineColor = color;
        return this;
    }

    public TextPropertiesBuilder fontUnderlineStyle(TextProperties.Underline style) {
        this.fontUnderlineStyle = style;
        return this;
    }

    public TextPropertiesBuilder fontWeightBold() {
        this.fontWeight = "bold";
        return this;
    }

    public TextPropertiesBuilder fontWeightNormal() {
        this.fontWeight = "normal";
        return this;
    }

    public boolean hasFontSizePercentage() {
        return this.fontSizePercentage > 0.0;
    }
}

