/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.ShowableBuilder;
import com.github.jferard.fastods.style.TableStyle;
import com.github.jferard.fastods.util.NameChecker;
import com.github.jferard.fastods.util.StyleBuilder;

public class TableStyleBuilder
implements StyleBuilder<TableStyle>,
ShowableBuilder<TableStyleBuilder> {
    static final NameChecker checker = new NameChecker();
    private final String name;
    private PageStyle pageStyle;
    private boolean hidden;

    TableStyleBuilder(String name) {
        this.name = checker.checkStyleName(name);
        this.pageStyle = PageStyle.DEFAULT_MASTER_PAGE_STYLE;
        this.hidden = true;
    }

    @Override
    public TableStyle build() {
        return new TableStyle(this.name, this.hidden, this.pageStyle);
    }

    public TableStyleBuilder pageStyle(PageStyle masterPageStyle) {
        this.pageStyle = masterPageStyle;
        return this;
    }

    @Override
    public TableStyleBuilder visible() {
        this.hidden = false;
        return this;
    }
}

