/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Footer;
import com.github.jferard.fastods.Header;
import com.github.jferard.fastods.PageSection;
import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.attribute.PageCentering;
import com.github.jferard.fastods.attribute.PagePrintOrientation;
import com.github.jferard.fastods.attribute.PageWritingMode;
import com.github.jferard.fastods.attribute.SimpleColor;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.style.AddableToOdsElements;
import com.github.jferard.fastods.style.Margins;
import com.github.jferard.fastods.util.Hidable;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class PageLayoutStyle
implements AddableToOdsElements,
Hidable {
    private final Color backgroundColor;
    private final Footer footer;
    private final Header header;
    private final Margins margins;
    private final String name;
    private final String numFormat;
    private final Length pageHeight;
    private final Length pageWidth;
    private final PagePrintOrientation printOrientation;
    private final PageWritingMode writingMode;
    private final int scaleTo;
    private final int scaleToPages;
    private final int scaleToX;
    private final int scaleToY;
    private final PageCentering centering;

    PageLayoutStyle(String name, Margins margins, Length pageWidth, Length pageHeight, String numFormat, Color backgroundColor, Header header, Footer footer, PagePrintOrientation printOrientation, PageWritingMode writingMode, int scaleTo, int scaleToPages, int scaleToX, int scaleToY, PageCentering centering) {
        this.name = name;
        this.margins = margins;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.numFormat = numFormat;
        this.backgroundColor = backgroundColor;
        this.footer = footer;
        this.header = header;
        this.printOrientation = printOrientation;
        this.writingMode = writingMode;
        this.scaleTo = scaleTo;
        this.scaleToPages = scaleToPages;
        this.scaleToX = scaleToX;
        this.scaleToY = scaleToY;
        this.centering = centering;
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addPageLayoutStyle(this);
    }

    public void appendXMLToAutomaticStyle(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:page-layout");
        util.appendEAttribute(appendable, "style:name", this.name);
        appendable.append("><style:page-layout-properties");
        util.appendAttribute(appendable, (CharSequence)"fo:page-width", this.pageWidth);
        util.appendAttribute(appendable, (CharSequence)"fo:page-height", this.pageHeight);
        if (this.scaleTo != 100) {
            util.appendAttribute(appendable, (CharSequence)"style:scale-to", this.scaleTo + "%");
        }
        if (this.scaleToPages != 0) {
            util.appendAttribute(appendable, (CharSequence)"style:scale-to-pages", this.scaleToPages);
        }
        if (this.scaleToX != 0) {
            util.appendAttribute(appendable, (CharSequence)"style:scale-to-X", this.scaleToX);
            util.appendAttribute(appendable, (CharSequence)"loext:scale-to-X", this.scaleToX);
        }
        if (this.scaleToY != 0) {
            util.appendAttribute(appendable, (CharSequence)"style:scale-to-Y", this.scaleToY);
            util.appendAttribute(appendable, (CharSequence)"loext:scale-to-Y", this.scaleToY);
        }
        if (this.centering != PageCentering.NONE) {
            util.appendAttribute(appendable, (CharSequence)"style:table-centering", this.centering);
        }
        util.appendEAttribute(appendable, "style:num-format", this.numFormat);
        util.appendAttribute(appendable, (CharSequence)"style:writing-mode", this.writingMode);
        util.appendAttribute(appendable, (CharSequence)"style:print-orientation", this.printOrientation);
        this.appendBackgroundColor(util, appendable);
        this.margins.appendXMLContent(util, appendable);
        appendable.append("/>");
        PageSection.appendPageSectionStyleXMLToAutomaticStyle(this.header, util, appendable);
        PageSection.appendPageSectionStyleXMLToAutomaticStyle(this.footer, util, appendable);
        appendable.append("</style:page-layout>");
    }

    public String getName() {
        return this.name;
    }

    public PageWritingMode getWritingMode() {
        return this.writingMode;
    }

    private void appendBackgroundColor(XMLUtil util, Appendable appendable) throws IOException {
        if (this.backgroundColor != SimpleColor.NONE) {
            util.appendAttribute(appendable, (CharSequence)"fo:background-color", this.backgroundColor);
        }
    }

    @Override
    public boolean isHidden() {
        return true;
    }
}

