/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.attribute.Angle;
import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.DrawFill;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.ObjectStyleFamily;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class DrawFillHatch
implements DrawFill,
ObjectStyle {
    private final String name;
    private final Angle angle;
    private final Color color;
    private final Length distance;
    private String key;

    public DrawFillHatch(String name, Angle angle, Color color, Length distance) {
        this.name = name;
        this.angle = angle;
        this.color = color;
        this.distance = distance;
    }

    @Override
    public ObjectStyleFamily getFamily() {
        return ObjectStyleFamily.DRAW_FILL_HATCH;
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.key = (Object)((Object)this.getFamily()) + "@" + this.getName();
        }
        return this.key;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<draw:hatch");
        util.appendAttribute(appendable, (CharSequence)"draw:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"draw:angle", this.angle);
        util.appendAttribute(appendable, (CharSequence)"draw:color", this.color);
        util.appendAttribute(appendable, (CharSequence)"draw:distance", this.distance);
        appendable.append("/>");
    }

    @Override
    public void addToElements(OdsElements odsElements) {
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void appendAttributes(XMLUtil util, Appendable appendable) throws IOException {
        util.appendAttribute(appendable, (CharSequence)"draw:fill", "hatch");
        util.appendAttribute(appendable, (CharSequence)"draw:fill-hatch-name", this.name);
    }

    @Override
    public void addEmbeddedStyles(StylesContainer stylesContainer) {
        stylesContainer.addStylesStyle(this);
    }
}

