/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.ref.TableRefBuilder;
import com.github.jferard.fastods.util.EqualityUtil;
import java.io.IOException;

public class TableRef {
    private final TableNameUtil tableNameUtil;
    private final String filename;
    private final String tableName;
    private final int status;

    public static TableRefBuilder builder(TableNameUtil tableNameUtil) {
        return new TableRefBuilder(tableNameUtil);
    }

    public TableRef(TableNameUtil tableNameUtil, String filename, String tableName, int status) {
        this.tableNameUtil = tableNameUtil;
        this.filename = filename;
        this.tableName = tableName;
        this.status = status;
    }

    private void appendFilename(Appendable appendable) throws IOException {
        if (this.filename == null) {
            return;
        }
        appendable.append('\'');
        for (int i = 0; i < this.filename.length(); ++i) {
            char c = this.filename.charAt(i);
            if (c == '\'') {
                appendable.append('\'');
            }
            appendable.append(c);
        }
        appendable.append("'#");
    }

    private void appendTableName(Appendable appendable) throws IOException {
        if ((this.status & 4) == 4) {
            appendable.append('$');
        }
        appendable.append(this.tableNameUtil.escapeTableName(this.tableName));
    }

    public void write(Appendable appendable) throws IOException {
        this.appendFilename(appendable);
        this.appendTableName(appendable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        try {
            this.write(sb);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TableRef)) {
            return false;
        }
        TableRef other = (TableRef)o;
        return EqualityUtil.equal(this.filename, other.filename) && EqualityUtil.equal(this.tableName, other.tableName) && this.status == other.status;
    }

    public int hashCode() {
        return EqualityUtil.hashObjects(this.filename, this.tableName, this.status);
    }
}

