/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.ref.CellAddressParser;
import com.github.jferard.fastods.ref.CellRef;
import com.github.jferard.fastods.ref.LocalCellRef;
import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.ref.TableRef;
import java.io.IOException;
import java.text.ParseException;

public class PositionUtil {
    public static final int ALPHABET_SIZE = 26;
    public static final int ORD_A = 65;
    private final TableNameUtil tableNameUtil;

    public static PositionUtil create() {
        return new PositionUtil(new TableNameUtil());
    }

    public PositionUtil(TableNameUtil tableNameUtil) {
        this.tableNameUtil = tableNameUtil;
    }

    public CellRef newCellRef(String address) throws ParseException, IOException {
        return CellAddressParser.create(this.tableNameUtil).parse(address);
    }

    public CellRef newCellRef(int row, int col) {
        return new CellRef(null, new LocalCellRef(row, col, 0));
    }

    public CellRef newCellRef(Table table, int row, int col) {
        TableRef tableRef = new TableRef(this.tableNameUtil, null, table.getName(), 0);
        return new CellRef(tableRef, new LocalCellRef(row, col, 0));
    }

    public String toCellAddress(int row, int col) {
        return this.newCellRef(row, col).toString();
    }

    public String toCellAddress(Table table, int row, int col) {
        return this.newCellRef(table, row, col).toString();
    }

    public String toRangeAddress(int row1, int col1, int row2, int col2) {
        return this.toCellAddress(row1, col1) + ":" + this.toCellAddress(row2, col2);
    }

    public String toRangeAddress(Table table, int row1, int col1, int row2, int col2) {
        return this.toCellAddress(table, row1, col1) + ":" + this.toCellAddress(table, row2, col2);
    }

    public void checkTableName(CharSequence name) {
        this.tableNameUtil.checkTableName(name);
    }
}

