/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.ref.LocalCellRef;
import java.text.ParseException;

class LocalCellAddressParser {
    private static final int BEGIN_COL = 0;
    private static final int OPT_LETTER = 1;
    private static final int BEGIN_ROW = 2;
    private static final int OPT_DIGIT = 3;

    LocalCellAddressParser() {
    }

    public LocalCellRef parse(String address) throws ParseException {
        int status = 0;
        int col = 0;
        int row = 0;
        int state = 0;
        block6: for (int i = 0; i < address.length(); ++i) {
            char c = address.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '$') {
                        status |= 1;
                        continue block6;
                    }
                    if ('A' <= c && c <= 'Z') {
                        col = c - 65 + 1;
                        state = 1;
                        continue block6;
                    }
                    throw this.parseException("Expected letter or $", address, i, c);
                }
                case 2: {
                    if (c == '$') {
                        status |= 2;
                        continue block6;
                    }
                    if ('1' <= c && c <= '9') {
                        row = c - 48;
                        state = 3;
                        continue block6;
                    }
                    throw this.parseException("Expected digit (not 0) or $", address, i, c);
                }
                case 1: {
                    if ('A' <= c && c <= 'Z') {
                        col = col * 26 + c - 65 + 1;
                        continue block6;
                    }
                    state = 2;
                    --i;
                    continue block6;
                }
                case 3: {
                    if ('0' <= c && c <= '9') {
                        row = row * 10 + c - 48;
                        continue block6;
                    }
                    throw this.parseException("Expected digit", address, i, c);
                }
                default: {
                    throw this.parseException("Unexpected error", address, i, c);
                }
            }
        }
        if (state != 3) {
            throw new ParseException(String.format("Address too short, expected digit: %s[]", address), address.length());
        }
        return new LocalCellRef(row - 1, col - 1, status);
    }

    private ParseException parseException(String text, String address, int i, char c) {
        return new ParseException(String.format("%s: %s[%c]%s", text, address.substring(0, i), Character.valueOf(c), address.substring(i + 1)), i);
    }
}

