/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement.config;

import com.github.jferard.fastods.odselement.config.ConfigItemCollection;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConfigItemMapNamed
implements ConfigItemCollection<ConfigItemMapEntry> {
    private final String name;
    private final Map<String, ConfigItemMapEntry> map;

    public ConfigItemMapNamed(String name) {
        this.name = name;
        this.map = new HashMap<String, ConfigItemMapEntry>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(String name) {
        return this.map.containsKey(name);
    }

    public ConfigItemMapEntry getByName(String name) {
        return this.map.get(name);
    }

    public ConfigItemMapEntry put(ConfigItemMapEntry value) {
        return this.map.put(value.getName(), value);
    }

    public ConfigItemMapEntry removeByName(String name) {
        return this.map.remove(name);
    }

    @Override
    public Iterator<ConfigItemMapEntry> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        appendable.append("<config:config-item-map-named");
        util.appendEAttribute(appendable, "config:name", this.name);
        appendable.append(">");
        for (ConfigItemMapEntry entry : this.map.values()) {
            entry.appendXMLContent(util, appendable);
        }
        appendable.append("</config:config-item-map-named>");
    }

    public void clear() {
        this.map.clear();
    }
}

