/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.EncryptParameters;

public class EncryptParametersBuilder {
    private String compressedCheckSumType = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0#sha256-1k";
    private String startKeyGenerationName = "http://www.w3.org/2000/09/xmldsig#sha256";
    private int startKeySize = 32;
    private String keyDerivationName = "PBKDF2";
    private int derivedKeySize = 32;
    private int derivationIterationCount = 100000;
    private String algorithmName = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";

    public EncryptParameters build(int uncompressedSize, int compressedSize, long crc32, String compressedCheckSum, String derivationSalt, String algorithmInitializationVector) {
        return new EncryptParameters(uncompressedSize, compressedSize, crc32, this.compressedCheckSumType, compressedCheckSum, this.startKeyGenerationName, this.startKeySize, this.keyDerivationName, this.derivedKeySize, this.derivationIterationCount, derivationSalt, this.algorithmName, algorithmInitializationVector);
    }

    public EncryptParametersBuilder compressedCheckSumType(String compressedCheckSumType) {
        this.compressedCheckSumType = compressedCheckSumType;
        return this;
    }

    public EncryptParametersBuilder startKeyGenerationName(String startKeyGenerationName) {
        this.startKeyGenerationName = startKeyGenerationName;
        return this;
    }

    public EncryptParametersBuilder startKeySize(int startKeySize) {
        this.startKeySize = startKeySize;
        return this;
    }

    public EncryptParametersBuilder keyDerivationName(String keyDerivationName) {
        this.keyDerivationName = keyDerivationName;
        return this;
    }

    public EncryptParametersBuilder derivedKeySize(int derivedKeySize) {
        this.derivedKeySize = derivedKeySize;
        return this;
    }

    public EncryptParametersBuilder derivationIterationCount(int iterationCount) {
        this.derivationIterationCount = iterationCount;
        return this;
    }

    public EncryptParametersBuilder algorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }
}

