/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.datastyle.CurrencyStyle;
import com.github.jferard.fastods.datastyle.DataStyleBuilder;
import com.github.jferard.fastods.datastyle.DecimalStyleBuilder;
import com.github.jferard.fastods.datastyle.FloatStyleBuilder;
import com.github.jferard.fastods.datastyle.NumberStyleBuilder;
import java.util.Currency;
import java.util.Locale;

public class CurrencyStyleBuilder
implements DataStyleBuilder<CurrencyStyle, CurrencyStyleBuilder>,
NumberStyleBuilder<CurrencyStyle, CurrencyStyleBuilder>,
DecimalStyleBuilder<CurrencyStyleBuilder> {
    private final FloatStyleBuilder floatStyleBuilder;
    private CurrencyStyle.SymbolPosition currencyPosition;
    private String currencySymbol;

    public CurrencyStyleBuilder(String name, Locale locale) {
        this.floatStyleBuilder = new FloatStyleBuilder(name, locale);
        this.currencySymbol = Currency.getInstance(locale).getSymbol(locale);
        this.currencyPosition = CurrencyStyle.SymbolPosition.END;
    }

    @Override
    public CurrencyStyle build() {
        return new CurrencyStyle(this.floatStyleBuilder.build(), this.currencySymbol, this.currencyPosition);
    }

    public CurrencyStyleBuilder currencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
        return this;
    }

    public CurrencyStyleBuilder currencySymbolPosition(CurrencyStyle.SymbolPosition symbolPosition) {
        this.currencyPosition = symbolPosition;
        return this;
    }

    @Override
    public CurrencyStyleBuilder decimalPlaces(int decimalPlaces) {
        this.floatStyleBuilder.decimalPlaces(decimalPlaces);
        return this;
    }

    @Override
    public CurrencyStyleBuilder groupThousands(boolean grouping) {
        this.floatStyleBuilder.groupThousands(grouping);
        return this;
    }

    @Override
    public final CurrencyStyleBuilder locale(Locale locale) {
        this.floatStyleBuilder.locale(locale);
        this.currencySymbol = Currency.getInstance(locale).getSymbol(locale);
        return this;
    }

    @Override
    public CurrencyStyleBuilder minIntegerDigits(int minIntegerDigits) {
        this.floatStyleBuilder.minIntegerDigits(minIntegerDigits);
        return this;
    }

    @Override
    public CurrencyStyleBuilder negativeValueColor(Color negativeValueColor) {
        this.floatStyleBuilder.negativeValueColor(negativeValueColor);
        return this;
    }

    @Override
    public CurrencyStyleBuilder negativeValueRed() {
        this.floatStyleBuilder.negativeValueRed();
        return this;
    }

    @Override
    public CurrencyStyleBuilder country(String countryCode) {
        this.floatStyleBuilder.country(countryCode);
        return this;
    }

    @Override
    public CurrencyStyleBuilder language(String languageCode) {
        this.floatStyleBuilder.language(languageCode);
        return this;
    }

    @Override
    public CurrencyStyleBuilder volatileStyle(boolean volatileStyle) {
        this.floatStyleBuilder.volatileStyle(volatileStyle);
        return this;
    }

    @Override
    public CurrencyStyleBuilder visible() {
        this.floatStyleBuilder.visible();
        return this;
    }
}

