/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.attribute;

import com.github.jferard.fastods.attribute.AttributeValue;
import com.github.jferard.fastods.attribute.BorderAttributeBuilder;
import com.github.jferard.fastods.attribute.BorderStyle;
import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.attribute.Length;
import com.github.jferard.fastods.attribute.SimpleColor;
import com.github.jferard.fastods.attribute.SimpleLength;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class BorderAttribute
implements AttributeValue {
    public static final Color DEFAULT_BORDER_COLOR = SimpleColor.BLACK;
    public static final Length DEFAULT_BORDER_SIZE = SimpleLength.mm(1.0);
    public static final Position DEFAULT_POSITION = Position.ALL;
    public static final BorderStyle DEFAULT_STYLE = BorderStyle.SOLID;
    private final Color borderColor;
    private final Length borderSize;
    private final BorderStyle style;

    public static BorderAttributeBuilder builder() {
        return new BorderAttributeBuilder();
    }

    public BorderAttribute(Length size, Color color, BorderStyle style) {
        this.borderSize = size;
        this.borderColor = color;
        this.style = style;
    }

    @Override
    public CharSequence getValue() {
        StringBuilder sb = new StringBuilder();
        if (this.borderSize == null) {
            if (this.borderColor != SimpleColor.NONE) {
                sb.append(this.style.getValue()).append(' ').append(this.borderColor.getValue());
            }
        } else if (this.borderColor == SimpleColor.NONE) {
            sb.append(this.borderSize);
        } else {
            sb.append(this.borderSize).append(' ').append(this.style.getValue()).append(' ').append(this.borderColor.getValue());
        }
        return sb;
    }

    public String toString() {
        return "BorderAttribute[" + this.getValue() + "]";
    }

    public void appendXMLAttribute(XMLUtil util, Appendable appendable, String attrName) throws IOException {
        util.appendAttribute(appendable, (CharSequence)attrName, this);
    }

    public static enum Position {
        ALL("fo:border"),
        BOTTOM("fo:border-bottom"),
        LEFT("fo:border-left"),
        RIGHT("fo:border-right"),
        TOP("fo:border-top");

        private final String attrName;

        private Position(String attrName) {
            this.attrName = attrName;
        }

        String getAttrName() {
            return this.attrName;
        }
    }
}

