/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.Shape;
import com.github.jferard.fastods.TableBuilder;
import com.github.jferard.fastods.TableColumnImpl;
import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class PreambleAppender {
    private static final int MAX_COLUMN_COUNT = 1024;
    private final TableBuilder builder;

    public PreambleAppender(TableBuilder builder) {
        this.builder = builder;
    }

    public void appendForms(XMLUtil util, Appendable appendable) throws IOException {
        List<XMLConvertible> forms = this.builder.getForms();
        if (forms == null || forms.isEmpty()) {
            return;
        }
        appendable.append("<office:forms");
        util.appendAttribute(appendable, (CharSequence)"form:automatic-focus", false);
        util.appendAttribute(appendable, (CharSequence)"form:apply-design-mode", false);
        appendable.append(">");
        for (XMLConvertible form : forms) {
            form.appendXMLContent(util, appendable);
        }
        appendable.append("</office:forms>");
    }

    public void appendShapes(XMLUtil util, Appendable appendable) throws IOException {
        List<Shape> shapes = this.builder.getShapes();
        if (shapes == null || shapes.isEmpty()) {
            return;
        }
        appendable.append("<table:shapes>");
        for (Shape shape : shapes) {
            shape.appendXMLContent(util, appendable);
        }
        appendable.append("</table:shapes>");
    }

    public void appendColumns(XMLUtil xmlUtil, Appendable appendable) throws IOException {
        Iterator<TableColumnImpl> iterator = this.builder.getColumns().iterator();
        if (!iterator.hasNext()) {
            TableColumnImpl.DEFAULT_TABLE_COLUMN.appendXMLToTable(xmlUtil, appendable, 1024);
            return;
        }
        int headerColumnsCount = this.builder.getHeaderColumnsCount();
        if (headerColumnsCount > 0) {
            appendable.append("<table:table-header-columns>");
        }
        int count = 1;
        int endCount = 1024;
        TableColumnImpl curColumn = iterator.next();
        while (iterator.hasNext()) {
            TableColumnImpl prevColumn = curColumn;
            curColumn = iterator.next();
            if (--headerColumnsCount == 0) {
                prevColumn.appendXMLToTable(xmlUtil, appendable, count);
                endCount -= count;
                count = 1;
                appendable.append("</table:table-header-columns>");
                continue;
            }
            if (curColumn.equals(prevColumn)) {
                ++count;
                continue;
            }
            prevColumn.appendXMLToTable(xmlUtil, appendable, count);
            endCount -= count;
            count = 1;
        }
        curColumn.appendXMLToTable(xmlUtil, appendable, count);
        endCount -= count;
        if (--headerColumnsCount == 0) {
            appendable.append("</table:table-header-columns>");
        } else if (headerColumnsCount > 0) {
            TableColumnImpl.DEFAULT_TABLE_COLUMN.appendXMLToTable(xmlUtil, appendable, headerColumnsCount);
            endCount -= headerColumnsCount;
            appendable.append("</table:table-header-columns>");
        }
        TableColumnImpl.DEFAULT_TABLE_COLUMN.appendXMLToTable(xmlUtil, appendable, endCount);
    }
}

