/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.OdsFactory;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.datastyle.DataStylesBuilder;
import com.github.jferard.fastods.odselement.MetaElement;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.util.IntegerRepresentationCache;
import com.github.jferard.fastods.util.XMLUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class OdsFactoryBuilder {
    private final Logger logger;
    private final PositionUtil positionUtil;
    private final IntegerRepresentationCache cache;
    private final XMLUtil xmlUtil;
    private final Map<String, String> additionalNamespaceByPrefix;
    private DataStyles format;
    private boolean libreOfficeMode;
    private MetaElement metaElement;

    public OdsFactoryBuilder(Logger logger, Locale locale) {
        this.logger = logger;
        this.positionUtil = new PositionUtil(new TableNameUtil());
        this.cache = IntegerRepresentationCache.create();
        this.xmlUtil = XMLUtil.create();
        this.additionalNamespaceByPrefix = new HashMap<String, String>();
        this.format = DataStylesBuilder.create(locale).build();
        this.libreOfficeMode = true;
        this.metaElement = MetaElement.create();
    }

    public OdsFactory build() {
        return new OdsFactory(this.logger, this.positionUtil, this.cache, this.xmlUtil, this.additionalNamespaceByPrefix, this.format, this.libreOfficeMode, this.metaElement);
    }

    public OdsFactoryBuilder dataStyles(DataStyles ds) {
        this.format = ds;
        return this;
    }

    public OdsFactoryBuilder noLibreOfficeMode() {
        this.libreOfficeMode = false;
        return this;
    }

    public OdsFactoryBuilder metaElement(MetaElement metaElement) {
        this.metaElement = metaElement;
        return this;
    }

    public OdsFactoryBuilder addNamespaceByPrefix(Map<String, String> additionalNamespaceByPrefix) {
        this.additionalNamespaceByPrefix.putAll(additionalNamespaceByPrefix);
        return this;
    }
}

