/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.AnonymousOdsDocument;
import com.github.jferard.fastods.AnonymousOdsFileWriter;
import com.github.jferard.fastods.NamedOdsDocument;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.OdsFactoryBuilder;
import com.github.jferard.fastods.OdsFileDirectWriter;
import com.github.jferard.fastods.OdsFileWriterAdapter;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.MetaElement;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.util.IntegerRepresentationCache;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8WriterBuilderImpl;
import com.github.jferard.fastods.util.ZipUTF8WriterImpl;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;

public class OdsFactory {
    private final Logger logger;
    private final PositionUtil positionUtil;
    private final IntegerRepresentationCache cache;
    private final XMLUtil xmlUtil;
    private final Map<String, String> additionalNamespaceByPrefix;
    private DataStyles format;
    private boolean libreOfficeMode;
    private MetaElement metaElement;

    OdsFactory(Logger logger, PositionUtil positionUtil, IntegerRepresentationCache cache, XMLUtil xmlUtil, Map<String, String> additionalNamespaceByPrefix, DataStyles format, boolean libreOfficeMode, MetaElement metaElement) {
        this.logger = logger;
        this.positionUtil = positionUtil;
        this.cache = cache;
        this.xmlUtil = xmlUtil;
        this.additionalNamespaceByPrefix = additionalNamespaceByPrefix;
        this.format = format;
        this.libreOfficeMode = libreOfficeMode;
        this.metaElement = metaElement;
    }

    public static OdsFactoryBuilder builder(Logger logger, Locale locale) {
        return new OdsFactoryBuilder(logger, locale);
    }

    public static OdsFactory create() {
        return OdsFactory.create(Logger.getLogger(NamedOdsDocument.class.getName()), Locale.getDefault());
    }

    public static OdsFactory create(Logger logger, Locale locale) {
        return new OdsFactoryBuilder(logger, locale).build();
    }

    @Deprecated
    public OdsFactory dataStyles(DataStyles ds) {
        this.format = ds;
        return this;
    }

    @Deprecated
    public OdsFactory noLibreOfficeMode() {
        this.libreOfficeMode = false;
        return this;
    }

    @Deprecated
    public OdsFactory metaElement(MetaElement metaElement) {
        this.metaElement = metaElement;
        return this;
    }

    @Deprecated
    public OdsFactory addNamespaceByPrefix(Map<String, String> additionalNamespaceByPrefix) {
        this.additionalNamespaceByPrefix.putAll(additionalNamespaceByPrefix);
        return this;
    }

    private AnonymousOdsDocument createAnonymousDocument() {
        OdsElements odsElements = OdsElements.create(this.positionUtil, this.xmlUtil, this.cache, this.format, this.libreOfficeMode, this.metaElement, this.additionalNamespaceByPrefix);
        return AnonymousOdsDocument.create(this.logger, this.xmlUtil, odsElements);
    }

    private NamedOdsDocument createNamedDocument() {
        OdsElements odsElements = OdsElements.create(this.positionUtil, this.xmlUtil, this.cache, this.format, this.libreOfficeMode, this.metaElement, this.additionalNamespaceByPrefix);
        return NamedOdsDocument.create(this.logger, this.xmlUtil, odsElements);
    }

    public AnonymousOdsFileWriter createWriter() {
        AnonymousOdsDocument document = this.createAnonymousDocument();
        return new AnonymousOdsFileWriter(this.logger, document);
    }

    public NamedOdsFileWriter createWriter(String filename) throws IOException {
        NamedOdsDocument document = this.createNamedDocument();
        NamedOdsFileWriter writer = OdsFileDirectWriter.builder(this.logger, document).file(filename).build();
        document.addObserver(writer);
        document.prepare();
        return writer;
    }

    public NamedOdsFileWriter createWriter(File file) throws IOException {
        NamedOdsDocument document = this.createNamedDocument();
        NamedOdsFileWriter writer = OdsFileDirectWriter.builder(this.logger, document).file(file).build();
        document.addObserver(writer);
        document.prepare();
        return writer;
    }

    public OdsFileWriterAdapter createWriterAdapter(File file) throws IOException {
        NamedOdsDocument document = this.createNamedDocument();
        ZipUTF8WriterBuilderImpl zipUTF8Writer = ZipUTF8WriterImpl.builder().noWriterBuffer();
        OdsFileWriterAdapter writerAdapter = OdsFileWriterAdapter.create(this.logger, OdsFileDirectWriter.builder(this.logger, document).file(file).zipBuilder(zipUTF8Writer).build());
        document.addObserver(writerAdapter);
        document.prepare();
        return writerAdapter;
    }

    @Deprecated
    public static enum FileState {
        IS_DIRECTORY,
        FILE_EXISTS,
        OK;

    }
}

