/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.FastOdsException;
import com.github.jferard.fastods.TableCell;

public class FloatValue
implements CellValue {
    static final double FLOAT_DELTA = 1.0E-5;
    private final Number value;

    public static FloatValue from(Object o) throws FastOdsException {
        if (o instanceof Number) {
            return new FloatValue((Number)o);
        }
        if (o instanceof FloatValue) {
            return (FloatValue)o;
        }
        throw new FastOdsException("Can't cast " + o + " to Float");
    }

    FloatValue(Number value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FloatValue)) {
            return false;
        }
        FloatValue other = (FloatValue)o;
        return this.value.equals(other.value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public void setToCell(TableCell tableCell) {
        tableCell.setFloatValue(this.value);
    }

    public String toString() {
        return "FloatValue[" + this.value + "]";
    }
}

