/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods;

import com.github.jferard.fastods.DrawFrame;
import com.github.jferard.fastods.FrameContent;
import com.github.jferard.fastods.style.GraphicStyle;
import com.github.jferard.fastods.style.TextStyle;
import com.github.jferard.fastods.util.SVGRectangle;

public class DrawFrameBuilder {
    private final String name;
    private final FrameContent content;
    private final SVGRectangle rectangle;
    private TextStyle textStyle;
    private GraphicStyle drawStyle;
    private int zIndex;

    DrawFrameBuilder(String name, FrameContent content, SVGRectangle rectangle) {
        this.name = name;
        this.content = content;
        this.rectangle = rectangle;
        this.zIndex = 0;
        this.drawStyle = null;
        this.textStyle = null;
    }

    public DrawFrameBuilder zIndex(int zIndex) {
        this.zIndex = zIndex;
        return this;
    }

    public DrawFrameBuilder style(GraphicStyle drawStyle) {
        this.drawStyle = drawStyle;
        return this;
    }

    public DrawFrameBuilder textStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
        return this;
    }

    public DrawFrame build() {
        return new DrawFrame(this.name, this.content, this.rectangle, this.zIndex, this.drawStyle, this.textStyle);
    }
}

