/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.XMLConvertible;
import com.github.jferard.fastods.util.PilotTableBuilder;
import com.github.jferard.fastods.util.PilotTableField;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class PilotTable
implements XMLConvertible {
    private final List<PilotTableField> fields;
    private final String sourceCellRange;
    private final String name;
    private final String targetRange;
    private final List<String> buttons;
    private final boolean showFilterButton;
    private final boolean drillDownOnDoubleClick;

    public static PilotTableBuilder builder(String name, String sourceCellRange, String targetRange, List<String> buttons) {
        return new PilotTableBuilder(name, sourceCellRange, targetRange, buttons);
    }

    public PilotTable(String name, String sourceCellRange, String targetRange, List<String> buttons, List<PilotTableField> fields, boolean showFilterButton, boolean drillDownOnDoubleClick) {
        this.fields = fields;
        this.sourceCellRange = sourceCellRange;
        this.name = name;
        this.targetRange = targetRange;
        this.buttons = buttons;
        this.showFilterButton = showFilterButton;
        this.drillDownOnDoubleClick = drillDownOnDoubleClick;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<table:data-pilot-table");
        util.appendAttribute(appendable, (CharSequence)"table:name", this.name);
        util.appendAttribute(appendable, (CharSequence)"table:application-data", "");
        util.appendAttribute(appendable, (CharSequence)"table:target-range-address", this.targetRange);
        if (this.buttons.size() > 0) {
            util.appendAttribute(appendable, (CharSequence)"table:buttons", this.buildButtonsAttr());
        }
        util.appendAttribute(appendable, (CharSequence)"table:show-filter-button", this.showFilterButton);
        util.appendAttribute(appendable, (CharSequence)"table:drill-down-on-double-click", this.drillDownOnDoubleClick);
        appendable.append(">");
        appendable.append("<table:source-cell-range");
        util.appendAttribute(appendable, (CharSequence)"table:cell-range-address", this.sourceCellRange);
        appendable.append("/>");
        for (PilotTableField field : this.fields) {
            field.appendXMLContent(util, appendable);
        }
        appendable.append("</table:data-pilot-table>");
    }

    private StringBuilder buildButtonsAttr() {
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = this.buttons.iterator();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(' ').append(it.next());
        }
        return sb;
    }
}

