/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Container<K, V> {
    private final Map<K, V> valueByKey;
    private final Logger logger;
    private boolean closed;
    private boolean debug;
    private Mode mode;

    public Container(Logger logger) {
        this.logger = logger;
        this.valueByKey = new HashMap();
        this.closed = false;
        this.debug = false;
        this.mode = Mode.CREATE;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public boolean add(K key, V value) {
        V curValue = this.valueByKey.get(key);
        if (curValue == null ? this.mode == Mode.UPDATE : this.mode == Mode.CREATE) {
            return false;
        }
        if (this.closed && !this.valueByKey.containsKey(key)) {
            throw new IllegalStateException("Container put(" + key + ", " + value + ")");
        }
        if (this.debug && !this.valueByKey.containsKey(key)) {
            this.logger.severe("Container put(" + key + ", " + value + ")");
        }
        this.valueByKey.put(key, value);
        return true;
    }

    public void debug() {
        this.debug = true;
    }

    public void freeze() {
        this.closed = true;
    }

    public V get(K key) {
        return this.valueByKey.get(key);
    }

    public Map<K, V> getValueByKey() {
        return this.valueByKey;
    }

    public Iterable<V> getValues() {
        return this.valueByKey.values();
    }

    public static enum Mode {
        CREATE,
        CREATE_OR_UPDATE,
        UPDATE;

    }
}

