/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.TableCellWalker;
import com.github.jferard.fastods.ref.CellRef;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.style.TableCellStyle;
import java.io.IOException;
import java.text.ParseException;

public class TableHelper {
    private final PositionUtil positionUtil;

    public static TableHelper create() {
        return new TableHelper(PositionUtil.create());
    }

    public TableHelper(PositionUtil positionUtil) {
        this.positionUtil = positionUtil;
    }

    @Deprecated
    public void setCellMerge(Table table, int rowIndex, int colIndex, int rowMerge, int columnMerge) throws IOException {
        table.setCellMerge(rowIndex, colIndex, rowMerge, columnMerge);
    }

    public void setCellMerge(Table table, String address, int rowMerge, int columnMerge) throws IOException, ParseException {
        CellRef position = this.positionUtil.newCellRef(address);
        int row = position.getRow();
        int col = position.getColumn();
        table.setCellMerge(row, col, rowMerge, columnMerge);
    }

    public void setCellValue(Table table, int rowIndex, int colIndex, CellValue value, TableCellStyle ts) throws IOException {
        TableCellWalker cell = this.getCell(table, rowIndex, colIndex);
        cell.setCellValue(value);
        cell.setStyle(ts);
    }

    public void setCellValue(Table table, int rowIndex, int colIndex, CellValue value) throws IOException {
        TableCellWalker cell = this.getCell(table, rowIndex, colIndex);
        cell.setCellValue(value);
    }

    public void setCellValue(Table table, String address, CellValue value, TableCellStyle ts) throws IOException, ParseException {
        CellRef position = this.positionUtil.newCellRef(address);
        int row = position.getRow();
        int col = position.getColumn();
        this.setCellValue(table, row, col, value, ts);
    }

    public void setCellValue(Table table, String address, CellValue value) throws IOException, ParseException {
        CellRef position = this.positionUtil.newCellRef(address);
        int row = position.getRow();
        int col = position.getColumn();
        this.setCellValue(table, row, col, value);
    }

    public TableCellWalker getCell(Table table, int rowIndex, int colIndex) throws IOException {
        TableCellWalker walker = table.getWalker();
        walker.toRow(rowIndex);
        walker.to(colIndex);
        return walker;
    }

    public TableCellWalker getCell(Table table, String address) throws IOException, ParseException {
        CellRef position = this.positionUtil.newCellRef(address);
        return this.getCell(table, position.getRow(), position.getColumn());
    }
}

