/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.tool;

import com.github.jferard.fastods.CellValue;
import com.github.jferard.fastods.NamedOdsDocument;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.ref.CellRef;
import com.github.jferard.fastods.ref.PositionUtil;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.tool.TableHelper;
import java.io.IOException;
import java.text.ParseException;

public class OdsFileHelper {
    private final NamedOdsDocument odsDocument;
    private final PositionUtil positionUtil;
    private final TableHelper tableHelper;

    public OdsFileHelper(NamedOdsDocument odsDocument, TableHelper tableHelper, PositionUtil positionUtil) {
        this.odsDocument = odsDocument;
        this.tableHelper = tableHelper;
        this.positionUtil = positionUtil;
    }

    public void setCellMergeInAllTables(int rowIndex, int colIndex, int rowMerge, int columnMerge) throws IOException {
        for (Table table : this.odsDocument.getTables()) {
            this.tableHelper.setCellMerge(table, rowIndex, colIndex, rowMerge, columnMerge);
        }
    }

    public void setCellMergeInAllTables(String address, int rowMerge, int columnMerge) throws IOException, ParseException {
        CellRef position = this.positionUtil.newCellRef(address);
        int row = position.getRow();
        int col = position.getColumn();
        this.setCellMergeInAllTables(row, col, rowMerge, columnMerge);
    }

    public void setCellValueInAllTables(int rowIndex, int colIndex, CellValue value, TableCellStyle ts) throws IOException {
        for (Table table : this.odsDocument.getTables()) {
            this.tableHelper.setCellValue(table, rowIndex, colIndex, value, ts);
        }
    }

    public void setCellValueInAllTables(String address, CellValue value, TableCellStyle ts) throws IOException, ParseException {
        CellRef position = this.positionUtil.newCellRef(address);
        int row = position.getRow();
        int col = position.getColumn();
        this.setCellValueInAllTables(row, col, value, ts);
    }
}

