/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.ref.TableRef;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;

class TableAddressParser {
    public static final int SINGLE_QUOTE = 39;
    private static final int HASH = 35;
    private final TableNameUtil tableNameUtil;
    private int status;

    public TableAddressParser(TableNameUtil tableNameUtil) {
        this.tableNameUtil = tableNameUtil;
    }

    public TableRef parse(String tableAddress) throws ParseException, UnsupportedEncodingException {
        String escapedTableName;
        String filename;
        int hashIndex = tableAddress.indexOf(35);
        if (hashIndex == -1) {
            filename = null;
            escapedTableName = tableAddress;
        } else {
            String escapedFilename = tableAddress.substring(0, hashIndex);
            filename = this.tableNameUtil.unescapeFilename(escapedFilename);
            escapedTableName = tableAddress.substring(hashIndex + 1);
        }
        String tableName = this.tableNameUtil.unescapeQuotes(escapedTableName);
        if (tableName.charAt(0) == '$') {
            this.status = 4;
            tableName = tableName.substring(1);
        }
        return new TableRef(this.tableNameUtil, filename, tableName, this.status);
    }
}

