/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.ref;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.ref.CellRef;
import com.github.jferard.fastods.ref.LocalCellRef;
import com.github.jferard.fastods.ref.LocalCellRefBuilder;
import com.github.jferard.fastods.ref.TableNameUtil;
import com.github.jferard.fastods.ref.TableRef;
import com.github.jferard.fastods.ref.TableRefBuilder;
import java.io.File;

public class CellRefBuilder {
    private final TableRefBuilder tableRefBuilder;
    private final LocalCellRefBuilder localCellRefBuilder;

    CellRefBuilder(TableNameUtil tableNameUtil) {
        this.tableRefBuilder = TableRef.builder(tableNameUtil);
        this.localCellRefBuilder = LocalCellRef.builder();
    }

    public CellRefBuilder row(int r) {
        this.localCellRefBuilder.row(r);
        return this;
    }

    public CellRefBuilder absRow(int r) {
        this.localCellRefBuilder.absRow(r);
        return this;
    }

    public CellRefBuilder column(int c) {
        this.localCellRefBuilder.column(c);
        return this;
    }

    public CellRefBuilder absColumn(int c) {
        this.localCellRefBuilder.absColumn(c);
        return this;
    }

    public CellRefBuilder table(String tableName) {
        this.tableRefBuilder.table(tableName);
        return this;
    }

    public CellRefBuilder absTable(String tableName) {
        this.tableRefBuilder.absTable(tableName);
        return this;
    }

    public CellRefBuilder table(Table table) {
        this.tableRefBuilder.table(table);
        return this;
    }

    public CellRefBuilder absTable(Table table) {
        this.tableRefBuilder.absTable(table);
        return this;
    }

    public CellRefBuilder file(String fileName) {
        this.tableRefBuilder.file(fileName);
        return this;
    }

    public CellRefBuilder file(File file) {
        this.tableRefBuilder.file(file);
        return this;
    }

    public CellRef build() {
        return new CellRef(this.tableRefBuilder.build(), this.localCellRefBuilder.build());
    }
}

