/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement.config;

import com.github.jferard.fastods.odselement.config.ConfigBlock;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfigItemMapEntrySet
implements ConfigItemMapEntry {
    private final Map<String, ConfigBlock> blockByName;
    private final String name;

    public static ConfigItemMapEntrySet createSet() {
        return new ConfigItemMapEntrySet(new HashSet<ConfigBlock>());
    }

    public static ConfigItemMapEntrySet createSet(String name) {
        return new ConfigItemMapEntrySet(name, new HashSet<ConfigBlock>());
    }

    ConfigItemMapEntrySet(Set<ConfigBlock> blocks) {
        this(null, blocks);
    }

    ConfigItemMapEntrySet(String name, Set<ConfigBlock> blocks) {
        this.name = name;
        this.blockByName = new HashMap<String, ConfigBlock>();
        for (ConfigBlock block : blocks) {
            this.blockByName.put(block.getName(), block);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int size() {
        return this.blockByName.size();
    }

    @Override
    public boolean isEmpty() {
        return this.blockByName.isEmpty();
    }

    public boolean contains(String name) {
        return this.blockByName.containsKey(name);
    }

    @Override
    public boolean add(ConfigBlock block) {
        String name = block.getName();
        if (this.blockByName.containsKey(name)) {
            return false;
        }
        this.blockByName.put(name, block);
        return true;
    }

    @Override
    public ConfigBlock put(ConfigBlock block) {
        String name = block.getName();
        return this.blockByName.put(name, block);
    }

    public void remove(Object o) {
        this.blockByName.remove(o);
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<config:config-item-map-entry");
        if (this.name != null) {
            util.appendEAttribute(appendable, "config:name", this.name);
        }
        appendable.append(">");
        for (ConfigBlock block : this.blockByName.values()) {
            block.appendXMLContent(util, appendable);
        }
        appendable.append("</config:config-item-map-entry>");
    }

    @Override
    public Iterator<ConfigBlock> iterator() {
        return this.blockByName.values().iterator();
    }

    public ConfigBlock getByName(String name) {
        return this.blockByName.get(name);
    }

    public String set(String name, String value) {
        ConfigBlock block = this.blockByName.get(name);
        if (block instanceof ConfigItem) {
            ConfigItem item = (ConfigItem)block;
            String previousValue = item.getValue();
            item.setValue(value);
            return previousValue;
        }
        return null;
    }

    @Override
    public boolean add(String name, String type, String value) {
        ConfigBlock block = this.getByName(name);
        if (block instanceof ConfigItem) {
            return false;
        }
        this.blockByName.put(name, new ConfigItem(name, type, value));
        return true;
    }
}

