/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.Settings;
import com.github.jferard.fastods.odselement.config.ConfigBlock;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;

public class SettingsElement
implements OdsElement {
    private final Settings settings;
    private List<Table> tables;

    static SettingsElement create() {
        return new SettingsElement(Settings.create());
    }

    SettingsElement(Settings settings) {
        this.settings = settings;
    }

    public void addTableConfig(ConfigItemMapEntry configEntry) {
        this.settings.addTableConfig(configEntry);
    }

    public void setTables(List<Table> tables) {
        this.settings.setTables(tables);
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putNextEntry(new ZipEntry("settings.xml"));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        writer.write("<office:document-settings xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:config=\"urn:oasis:names:tc:opendocument:xmlns:config:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" office:version=\"1.1\">");
        writer.write("<office:settings>");
        for (ConfigBlock block : this.settings.getRootBlocks()) {
            block.appendXMLContent(util, writer);
        }
        writer.write("</office:settings>");
        writer.write("</office:document-settings>");
        writer.flush();
        writer.closeEntry();
    }

    public void setActiveTable(Table table) {
        this.settings.setActiveTable(table);
    }

    public void setViewSetting(String viewId, String item, String value) {
        this.settings.setViewSetting(viewId, item, value);
    }
}

