/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.datastyle.CoreDataStyle;
import com.github.jferard.fastods.datastyle.NumberStyle;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

class NumberStyleHelper
implements NumberStyle {
    private final CoreDataStyle dataStyle;
    private final boolean grouping;
    private final int minIntegerDigits;
    private final Color negativeValueColor;

    NumberStyleHelper(CoreDataStyle dataStyle, boolean grouping, int minIntegerDigits, Color negativeValueColor) {
        this.dataStyle = dataStyle;
        this.grouping = grouping;
        this.negativeValueColor = negativeValueColor;
        this.minIntegerDigits = minIntegerDigits;
    }

    void appendXMLHelper(XMLUtil util, Appendable appendable, String numberStyleName, CharSequence number) throws IOException {
        this.appendOpenTag(util, appendable, numberStyleName, this.dataStyle.getName());
        appendable.append(number);
        this.appendCloseTag(appendable, numberStyleName);
        if (this.negativeValueColor != null) {
            this.appendOpenTag(util, appendable, numberStyleName, this.dataStyle.getName() + "-neg");
            this.appendStyleColor(util, appendable);
            appendable.append("<number:text>-</number:text>");
            appendable.append(number);
            this.appendStyleMap(util, appendable);
            this.appendCloseTag(appendable, numberStyleName);
        }
    }

    private void appendCloseTag(Appendable appendable, CharSequence numberStyleName) throws IOException {
        appendable.append("</number:").append(numberStyleName).append(">");
    }

    private void appendOpenTag(XMLUtil util, Appendable appendable, CharSequence numberStyleName, String name) throws IOException {
        appendable.append("<number:").append(numberStyleName);
        util.appendEAttribute(appendable, "style:name", name);
        this.dataStyle.appendLVAttributes(util, appendable);
        appendable.append(">");
    }

    private void appendGroupingAttribute(XMLUtil util, Appendable appendable) throws IOException {
        if (this.grouping) {
            util.appendAttribute(appendable, (CharSequence)"number:grouping", "true");
        }
    }

    private void appendMinIntegerDigitsAttribute(XMLUtil util, Appendable appendable) throws IOException {
        if (this.minIntegerDigits > 0) {
            util.appendAttribute(appendable, (CharSequence)"number:min-integer-digits", this.minIntegerDigits);
        }
    }

    public void appendNumberAttribute(XMLUtil util, Appendable appendable) throws IOException {
        this.appendMinIntegerDigitsAttribute(util, appendable);
        this.appendGroupingAttribute(util, appendable);
    }

    private void appendStyleColor(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:text-properties");
        util.appendAttribute(appendable, (CharSequence)"fo:color", this.negativeValueColor);
        appendable.append("/>");
    }

    private void appendStyleMap(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:map");
        util.appendEAttribute(appendable, "style:condition", "value()>=0");
        util.appendEAttribute(appendable, "style:apply-style-name", this.dataStyle.getName());
        appendable.append("/>");
    }

    @Override
    public String getName() {
        return this.dataStyle.getName();
    }

    @Override
    public boolean isHidden() {
        return this.dataStyle.isHidden();
    }
}

