/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.datastyle;

import com.github.jferard.fastods.attribute.Color;
import com.github.jferard.fastods.datastyle.DataStyleBuilder;
import com.github.jferard.fastods.datastyle.DecimalStyleBuilder;
import com.github.jferard.fastods.datastyle.FloatStyle;
import com.github.jferard.fastods.datastyle.NumberStyleBuilder;
import com.github.jferard.fastods.datastyle.NumberStyleHelperBuilder;
import java.util.Locale;

public class FloatStyleBuilder
implements DataStyleBuilder<FloatStyle, FloatStyleBuilder>,
NumberStyleBuilder<FloatStyle, FloatStyleBuilder>,
DecimalStyleBuilder<FloatStyleBuilder> {
    private final NumberStyleHelperBuilder numberStyleHelperBuilder;
    private int decimalPlaces;

    public FloatStyleBuilder(String name, Locale locale) {
        this.numberStyleHelperBuilder = new NumberStyleHelperBuilder(name, locale);
        this.decimalPlaces = 2;
    }

    @Override
    public FloatStyle build() {
        return new FloatStyle(this.numberStyleHelperBuilder.build(), this.decimalPlaces);
    }

    @Override
    public FloatStyleBuilder visible() {
        this.numberStyleHelperBuilder.visible();
        return this;
    }

    @Override
    public FloatStyleBuilder decimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
        return this;
    }

    @Override
    public FloatStyleBuilder groupThousands(boolean grouping) {
        this.numberStyleHelperBuilder.groupThousands(grouping);
        return this;
    }

    @Override
    public FloatStyleBuilder minIntegerDigits(int minIntegerDigits) {
        this.numberStyleHelperBuilder.minIntegerDigits(minIntegerDigits);
        return this;
    }

    @Override
    public FloatStyleBuilder negativeValueColor(Color negativeValueColor) {
        this.numberStyleHelperBuilder.negativeValueColor(negativeValueColor);
        return this;
    }

    @Override
    public FloatStyleBuilder negativeValueRed() {
        this.numberStyleHelperBuilder.negativeValueRed();
        return this;
    }

    @Override
    public FloatStyleBuilder country(String countryCode) {
        this.numberStyleHelperBuilder.country(countryCode);
        return this;
    }

    @Override
    public FloatStyleBuilder language(String languageCode) {
        this.numberStyleHelperBuilder.language(languageCode);
        return this;
    }

    @Override
    public FloatStyleBuilder locale(Locale locale) {
        this.numberStyleHelperBuilder.locale(locale);
        return this;
    }

    @Override
    public FloatStyleBuilder volatileStyle(boolean volatileStyle) {
        this.numberStyleHelperBuilder.volatileStyle(volatileStyle);
        return this;
    }
}

